/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

public enum MemoryEvent {
    ADD("ADD"),
    UPDATE("UPDATE"),
    DELETE("DELETE"),
    NONE("NONE");

    private final String value;

    private MemoryEvent(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static MemoryEvent fromString(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Memory event value cannot be null");
        }
        for (MemoryEvent event : MemoryEvent.values()) {
            if (!event.value.equalsIgnoreCase(value)) continue;
            return event;
        }
        throw new IllegalArgumentException("Unknown memory event: " + value);
    }

    public String toString() {
        return this.value;
    }
}

