/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.resthandler.RestSearchAlertingCommentActionKt;
import org.opensearch.alerting.util.RestHandlerUtilsKt;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.commons.alerting.action.SearchCommentRequest;
import org.opensearch.commons.alerting.model.Comment;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/opensearch/alerting/resthandler/RestSearchAlertingCommentAction;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "getName", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "searchCommentResponse", "Lorg/opensearch/rest/action/RestResponseListener;", "Lorg/opensearch/action/search/SearchResponse;", "channel", "Lorg/opensearch/rest/RestChannel;", "opensearch-alerting"})
public final class RestSearchAlertingCommentAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "search_alerting_comments_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.GET, AlertingPlugin.COMMENTS_BASE_URI + "/_search"), new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.COMMENTS_BASE_URI + "/_search")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestSearchAlertingCommentActionKt.access$getLog$p().info(request.method() + " " + AlertingPlugin.COMMENTS_BASE_URI + "/_search");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(RestHandlerUtilsKt.context(request));
        String[] stringArray = new String[]{".opensearch-alerting-comments*"};
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(stringArray);
        Intrinsics.checkNotNull((Object)searchRequest);
        SearchCommentRequest searchCommentRequest = new SearchCommentRequest(searchRequest);
        return arg_0 -> RestSearchAlertingCommentAction.prepareRequest$lambda$0(client, searchCommentRequest, this, arg_0);
    }

    private final RestResponseListener<SearchResponse> searchCommentResponse(RestChannel channel) {
        return (RestResponseListener)new RestResponseListener<SearchResponse>(channel){
            final /* synthetic */ RestChannel $channel;
            {
                this.$channel = $channel;
                super($channel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RestResponse buildResponse(SearchResponse response2) throws Exception {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (response2.isTimedOut()) {
                    return (RestResponse)new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, response2.toString());
                }
                try {
                    Iterator iterator = response2.getHits().iterator();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        SearchHit hit = (SearchHit)iterator2.next();
                        Closeable closeable = (Closeable)XContentType.JSON.xContent().createParser(this.$channel.request().getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                        Throwable throwable = null;
                        try {
                            XContentParser hitsParser = (XContentParser)closeable;
                            boolean bl = false;
                            hitsParser.nextToken();
                            Intrinsics.checkNotNull((Object)hitsParser);
                            String string = hit.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                            Comment comment = Comment.Companion.parse(hitsParser, string);
                            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder(...)");
                            ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                            Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
                            XContentBuilder xcb = comment.toXContent(xContentBuilder, params);
                            SearchHit searchHit = hit.sourceRef(BytesReference.bytes((XContentBuilder)xcb));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                }
                catch (Exception e) {
                    RestSearchAlertingCommentActionKt.access$getLog$p().error("The comment parsing failed. Will return response as is.");
                }
                return (RestResponse)new BytesRestResponse(RestStatus.OK, response2.toXContent(this.$channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, SearchCommentRequest $searchCommentRequest, RestSearchAlertingCommentAction this$0, RestChannel channel) {
        ActionRequest actionRequest = (ActionRequest)$searchCommentRequest;
        Intrinsics.checkNotNull((Object)channel);
        $client.execute(AlertingActions.SEARCH_COMMENTS_ACTION_TYPE, actionRequest, (ActionListener)this$0.searchCommentResponse(channel));
    }
}

