/*
 * Decompiled with CFR 0.152.
 */
package org.passay.entropy;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.passay.AllowedCharacterRule;
import org.passay.CharacterCharacteristicsRule;
import org.passay.CharacterRule;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.entropy.RandomPasswordEntropy;

public final class RandomPasswordEntropyFactory {
    private RandomPasswordEntropyFactory() {
    }

    public static RandomPasswordEntropy createEntropy(List<? extends Rule> passwordRules, PasswordData passwordData) {
        if (!passwordData.getOrigin().equals((Object)PasswordData.Origin.Generated)) {
            throw new IllegalArgumentException("Password data must have an origin of " + (Object)((Object)PasswordData.Origin.Generated));
        }
        HashSet uniqueCharacters = new HashSet();
        passwordRules.forEach(rule -> {
            if (rule instanceof CharacterCharacteristicsRule) {
                CharacterCharacteristicsRule characteristicRule = (CharacterCharacteristicsRule)rule;
                characteristicRule.getRules().forEach(characterRule -> uniqueCharacters.addAll(RandomPasswordEntropyFactory.getUniqueCharacters(characterRule.getValidCharacters())));
            } else if (rule instanceof CharacterRule) {
                CharacterRule characterRule2 = (CharacterRule)rule;
                uniqueCharacters.addAll(RandomPasswordEntropyFactory.getUniqueCharacters(characterRule2.getValidCharacters()));
            } else if (rule instanceof AllowedCharacterRule) {
                AllowedCharacterRule allowedCharacterRule = (AllowedCharacterRule)rule;
                uniqueCharacters.addAll(RandomPasswordEntropyFactory.getUniqueCharacters(String.valueOf(allowedCharacterRule.getAllowedCharacters())));
            }
        });
        if (uniqueCharacters.isEmpty()) {
            throw new IllegalArgumentException("Password rules must contain at least 1 unique character by CharacterRule definition");
        }
        return new RandomPasswordEntropy(uniqueCharacters.size(), passwordData.getPassword().length());
    }

    private static Set<Character> getUniqueCharacters(String characters) {
        HashSet<Character> uniqueCharacters = new HashSet<Character>();
        if (characters != null) {
            for (char c : characters.toCharArray()) {
                uniqueCharacters.add(Character.valueOf(c));
            }
        }
        return uniqueCharacters;
    }
}

