/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.indices;

import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndicesManager;

public enum SearchRelevanceIndices {
    QUERY_SET("search-relevance-queryset", "mappings/queryset.json", false),
    EXPERIMENT(".plugins-search-relevance-experiment", "mappings/experiment.json", true),
    SEARCH_CONFIGURATION("search-relevance-search-config", "mappings/search_configuration.json", false),
    JUDGMENT("search-relevance-judgment", "mappings/judgment.json", false),
    EVALUATION_RESULT("search-relevance-evaluation-result", "mappings/evaluation_result.json", false),
    JUDGMENT_CACHE(".plugins-search-relevance-judgment-cache", "mappings/judgment_cache.json", false),
    EXPERIMENT_VARIANT("search-relevance-experiment-variant", "mappings/experiment_variant.json", false),
    SCHEDULED_JOBS(".search-relevance-scheduled-experiment-jobs", "mappings/scheduled_job.json", false),
    SCHEDULED_EXPERIMENT_HISTORY(".search-relevance-scheduled-experiment-history", "mappings/scheduled_experiment_history.json", false);

    private final String indexName;
    private final String mapping;
    private final boolean isProtected;

    private SearchRelevanceIndices(String indexName, String mappingPath, boolean isProtected) {
        this.indexName = Objects.requireNonNull(indexName, "Index name cannot be null.");
        this.mapping = this.loadMapping(mappingPath);
        this.isProtected = isProtected;
    }

    private String loadMapping(String mappingPath) {
        try {
            return SearchRelevanceIndicesManager.getIndexMappings(mappingPath);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to load mapping under path: " + mappingPath, e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    @Generated
    public String getMapping() {
        return this.mapping;
    }

    @Generated
    public boolean isProtected() {
        return this.isProtected;
    }
}

