/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.javascript.utils;

import com.intellij.json.psi.JsonFile;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.javascript.model.SimplifiedNpmPackageLockModel;
import com.intellij.packageChecker.javascript.model.SimplifiedPackageInfoLockModel;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.PackageType;
import com.intellij.packageChecker.util.SerializationUtils;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tJ\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/packageChecker/javascript/utils/NpmPackageLockParser;", "", "<init>", "()V", "NPM_PACKAGE_LOCK_FILENAME", "", "ROOT_PACKAGE_PREFIX", "findAndReadLockFile", "packageJsonFile", "Lcom/intellij/psi/PsiFile;", "readPackages", "", "Lcom/intellij/packageChecker/javascript/utils/NpmPackageLockParser$PackageToLockModel;", "lockFileContent", "project", "Lcom/intellij/openapi/project/Project;", "convertPackageLockFileInfo", "Lcom/intellij/packageChecker/model/Dependency;", "packageName", "packagesFromLockFile", "PackageToLockModel", "intellij.packageChecker.javascript"})
@SourceDebugExtension(value={"SMAP\nNpmPackageLockParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpmPackageLockParser.kt\ncom/intellij/packageChecker/javascript/utils/NpmPackageLockParser\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n216#2,2:78\n136#2,9:80\n216#2:89\n217#2:91\n145#2:92\n1#3:90\n*S KotlinDebug\n*F\n+ 1 NpmPackageLockParser.kt\ncom/intellij/packageChecker/javascript/utils/NpmPackageLockParser\n*L\n43#1:78,2\n64#1:80,9\n64#1:89\n64#1:91\n64#1:92\n64#1:90\n*E\n"})
public final class NpmPackageLockParser {
    @NotNull
    public static final NpmPackageLockParser INSTANCE = new NpmPackageLockParser();
    @NotNull
    public static final String NPM_PACKAGE_LOCK_FILENAME = "package-lock.json";
    @NotNull
    public static final String ROOT_PACKAGE_PREFIX = "node_modules";

    private NpmPackageLockParser() {
    }

    @Nullable
    public final String findAndReadLockFile(@NotNull PsiFile packageJsonFile) {
        Intrinsics.checkNotNullParameter((Object)packageJsonFile, (String)"packageJsonFile");
        if (!(packageJsonFile instanceof JsonFile) || !Intrinsics.areEqual((Object)((JsonFile)packageJsonFile).getName(), (Object)"package.json")) {
            return null;
        }
        PsiDirectory psiDirectory = ((JsonFile)packageJsonFile).getContainingDirectory();
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory directory = psiDirectory;
        PsiFile psiFile = directory.findFile(NPM_PACKAGE_LOCK_FILENAME);
        JsonFile jsonFile = psiFile instanceof JsonFile ? (JsonFile)psiFile : null;
        if (jsonFile == null) {
            return null;
        }
        JsonFile npmLockFile = jsonFile;
        return npmLockFile.getText();
    }

    @NotNull
    public final Map<String, PackageToLockModel> readPackages(@NotNull String lockFileContent, @NotNull Project project) {
        Object object;
        block6: {
            Intrinsics.checkNotNullParameter((Object)lockFileContent, (String)"lockFileContent");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (project.isDisposed()) {
                return MapsKt.emptyMap();
            }
            try {
                object = (SimplifiedNpmPackageLockModel)SerializationUtils.INSTANCE.getOm().readValue(lockFileContent, SimplifiedNpmPackageLockModel.class);
            }
            catch (Exception exception) {
                return MapsKt.emptyMap();
            }
            SimplifiedNpmPackageLockModel packageLock = object;
            Object $this$readPackages_u24lambda_u241 = object = MapsKt.createMapBuilder();
            boolean bl = false;
            Map<String, SimplifiedPackageInfoLockModel> map2 = packageLock.getPackages();
            if (map2 == null) break block6;
            Map<String, SimplifiedPackageInfoLockModel> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, SimplifiedPackageInfoLockModel>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                String version;
                Map map3;
                Map.Entry<String, SimplifiedPackageInfoLockModel> element$iv;
                Map.Entry<String, SimplifiedPackageInfoLockModel> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String coordinates = entry.getKey();
                SimplifiedPackageInfoLockModel infoLockModel = entry.getValue();
                if (infoLockModel == null) continue;
                String packageName = StringsKt.substringAfterLast$default((String)coordinates, (String)"/", null, (int)2, null);
                if (infoLockModel.getVersion() == null) continue;
                Map map4 = infoLockModel.getDependencies();
                if (map4 == null) {
                    map4 = MapsKt.emptyMap();
                }
                if ((map3 = infoLockModel.getOptionalDependencies()) == null) {
                    map3 = MapsKt.emptyMap();
                }
                Map childrenOfPackage = MapsKt.plus((Map)map4, map3);
                Package pkg = Package.Companion.create$default(Package.Companion, project, PackageType.npm, null, packageName, version, 4, null);
                PackageToLockModel packageToLockModel = new PackageToLockModel(pkg, childrenOfPackage);
                $this$readPackages_u24lambda_u241.put(coordinates, packageToLockModel);
            }
        }
        return MapsKt.build((Map)object);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Dependency convertPackageLockFileInfo(@NotNull String packageName, @NotNull Map<String, PackageToLockModel> packagesFromLockFile) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(packagesFromLockFile, (String)"packagesFromLockFile");
        v0 = packagesFromLockFile.get(packageName);
        if (v0 == null) {
            return null;
        }
        packageInfoLockModel = v0;
        $this$convertPackageLockFileInfo_u24lambda_u243 = var5_4 = SetsKt.createSetBuilder();
        $i$a$-buildSet-NpmPackageLockParser$convertPackageLockFileInfo$dependencies$1 = false;
        $this$mapNotNull$iv = packageInfoLockModel.getChildrenOfPackage();
        $i$f$mapNotNull = false;
        var10_9 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var15_14 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (var15_14.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var15_14.next();
            $i$a$-forEach-MapsKt___MapsKt$mapNotNullTo$1$iv$iv = false;
            var19_18 = element$iv$iv;
            $i$a$-mapNotNull-NpmPackageLockParser$convertPackageLockFileInfo$dependencies$1$1 = false;
            name = (String)var19_18.getKey();
            v1 = packagesFromLockFile.get(packageName + "/node_modules/" + name);
            if (v1 != null && (v1 = v1.getPkg()) != null) ** GOTO lbl30
            v2 = packagesFromLockFile.get("node_modules/" + name);
            if (v2 == null) {
                v3 = null;
            } else {
                v1 = v2.getPkg();
lbl30:
                // 2 sources

                pkg = v1;
                v3 = $this$convertPackageLockFileInfo_u24lambda_u243.add(new Dependency((Package)pkg, SetsKt.emptySet(), null, 4, null));
            }
            if (v3 == null) continue;
            it$iv$iv = v3;
            $i$a$-let-MapsKt___MapsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        (List)destination$iv$iv;
        dependencies = SetsKt.build((Set)var5_4);
        return new Dependency(packageInfoLockModel.getPkg(), dependencies, null, 4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0017\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u00c6\u0003J+\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/packageChecker/javascript/utils/NpmPackageLockParser$PackageToLockModel;", "", "pkg", "Lcom/intellij/packageChecker/model/Package;", "childrenOfPackage", "", "", "<init>", "(Lcom/intellij/packageChecker/model/Package;Ljava/util/Map;)V", "getPkg", "()Lcom/intellij/packageChecker/model/Package;", "getChildrenOfPackage", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.packageChecker.javascript"})
    public static final class PackageToLockModel {
        @NotNull
        private final Package pkg;
        @NotNull
        private final Map<String, String> childrenOfPackage;

        public PackageToLockModel(@NotNull Package pkg, @NotNull Map<String, String> childrenOfPackage) {
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Intrinsics.checkNotNullParameter(childrenOfPackage, (String)"childrenOfPackage");
            this.pkg = pkg;
            this.childrenOfPackage = childrenOfPackage;
        }

        @NotNull
        public final Package getPkg() {
            return this.pkg;
        }

        @NotNull
        public final Map<String, String> getChildrenOfPackage() {
            return this.childrenOfPackage;
        }

        @NotNull
        public final Package component1() {
            return this.pkg;
        }

        @NotNull
        public final Map<String, String> component2() {
            return this.childrenOfPackage;
        }

        @NotNull
        public final PackageToLockModel copy(@NotNull Package pkg, @NotNull Map<String, String> childrenOfPackage) {
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Intrinsics.checkNotNullParameter(childrenOfPackage, (String)"childrenOfPackage");
            return new PackageToLockModel(pkg, childrenOfPackage);
        }

        public static /* synthetic */ PackageToLockModel copy$default(PackageToLockModel packageToLockModel, Package package_, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                package_ = packageToLockModel.pkg;
            }
            if ((n & 2) != 0) {
                map2 = packageToLockModel.childrenOfPackage;
            }
            return packageToLockModel.copy(package_, map2);
        }

        @NotNull
        public String toString() {
            return "PackageToLockModel(pkg=" + this.pkg + ", childrenOfPackage=" + this.childrenOfPackage + ")";
        }

        public int hashCode() {
            int result = this.pkg.hashCode();
            result = result * 31 + ((Object)this.childrenOfPackage).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PackageToLockModel)) {
                return false;
            }
            PackageToLockModel packageToLockModel = (PackageToLockModel)other;
            if (!Intrinsics.areEqual((Object)this.pkg, (Object)packageToLockModel.pkg)) {
                return false;
            }
            return Intrinsics.areEqual(this.childrenOfPackage, packageToLockModel.childrenOfPackage);
        }
    }
}

