/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class Constants {
    private static final Logger logger = Logger.getLogger(Constants.class.getName());
    private static final Map<Integer, BigDecimal> piCache = new HashMap<Integer, BigDecimal>();

    Constants() {
    }

    static final class Pi {
        private static final BigDecimal TWO = new BigDecimal("2");
        private static final BigDecimal THREE = new BigDecimal("3");
        private static final BigDecimal FOUR = new BigDecimal("4");
        private static final BigDecimal FIVE = new BigDecimal("5");
        private static final BigDecimal TWO_THIRTY_NINE = new BigDecimal("239");

        private Pi() {
        }

        public static BigDecimal ofNumDigits(int numDigits) {
            if (numDigits <= 0) {
                throw new IllegalArgumentException("numDigits is required to be greater than zero");
            }
            return piCache.computeIfAbsent(numDigits, __ -> {
                int calcDigits = numDigits + 10;
                return FOUR.multiply(FOUR.multiply(Pi.arccot(FIVE, calcDigits)).subtract(Pi.arccot(TWO_THIRTY_NINE, calcDigits))).setScale(numDigits, RoundingMode.DOWN);
            });
        }

        private static BigDecimal arccot(BigDecimal x, int numDigits) {
            BigDecimal unity = BigDecimal.ONE.setScale(numDigits, RoundingMode.DOWN);
            BigDecimal sum = unity.divide(x, RoundingMode.DOWN);
            BigDecimal xpower = new BigDecimal(sum.toString());
            BigDecimal term = null;
            int nTerms = 0;
            BigDecimal nearZero = BigDecimal.ONE.scaleByPowerOfTen(-numDigits);
            logger.log(Level.FINER, "arccot: ARGUMENT=" + x + " (nearZero=" + nearZero + ")");
            boolean add = false;
            BigDecimal n = THREE;
            while (!(term != null && term.equals(BigDecimal.ZERO) || term != null && term.compareTo(nearZero) < 0)) {
                xpower = xpower.divide(x.pow(2), RoundingMode.DOWN);
                term = xpower.divide(n, RoundingMode.DOWN);
                sum = add ? sum.add(term) : sum.subtract(term);
                add = !add;
                logger.log(Level.FINEST, "arccot: term=" + term);
                ++nTerms;
                n = n.add(TWO);
            }
            logger.log(Level.FINER, "arccot: done. nTerms=" + nTerms);
            return sum;
        }
    }
}

