/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleEditorCustomization;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.CollectionFactory;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class SpellCheckingEditorCustomization
extends SimpleEditorCustomization {
    SpellCheckingEditorCustomization(boolean enabled) {
        super(enabled);
    }

    public void customize(@NotNull EditorEx editor) {
        DaemonCodeAnalyzer analyzer;
        if (editor == null) {
            SpellCheckingEditorCustomization.$$$reportNull$$$0(0);
        }
        boolean apply = this.isEnabled();
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        PsiFile file = (PsiFile)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)editor.getDocument()));
        if (file == null) {
            return;
        }
        Function strategy = InspectionProfileWrapper.getCustomInspectionProfileWrapper((PsiFile)file);
        if (strategy == null) {
            strategy = new MyInspectionProfileStrategy();
            InspectionProfileWrapper.setCustomInspectionProfileWrapperTemporarily((PsiFile)file, (Function)strategy);
        }
        if (!(strategy instanceof MyInspectionProfileStrategy)) {
            return;
        }
        ((MyInspectionProfileStrategy)strategy).setUseSpellCheck(apply);
        if (apply) {
            editor.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, (Object)false);
        }
        if ((analyzer = DaemonCodeAnalyzer.getInstance((Project)project)) != null) {
            analyzer.restart(file, (Object)this);
        }
    }

    public static boolean isSpellCheckingDisabled(@NotNull PsiFile file) {
        Function strategy;
        if (file == null) {
            SpellCheckingEditorCustomization.$$$reportNull$$$0(1);
        }
        return (strategy = InspectionProfileWrapper.getCustomInspectionProfileWrapper((PsiFile)file)) instanceof MyInspectionProfileStrategy && !((MyInspectionProfileStrategy)strategy).myUseSpellCheck;
    }

    static Set<String> getSpellCheckingToolNames() {
        return Set.of("SpellCheckingInspection");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "customize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpellCheckingDisabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyInspectionProfileStrategy
    implements Function<InspectionProfile, InspectionProfileWrapper> {
        private final ConcurrentMap<InspectionProfile, MyInspectionProfileWrapper> myWrappers = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        private boolean myUseSpellCheck;

        private MyInspectionProfileStrategy() {
        }

        @Override
        @NotNull
        public InspectionProfileWrapper apply(@NotNull InspectionProfile profile) {
            MyInspectionProfileWrapper wrapper;
            if (profile == null) {
                MyInspectionProfileStrategy.$$$reportNull$$$0(0);
            }
            MyInspectionProfileWrapper myInspectionProfileWrapper = (wrapper = (MyInspectionProfileWrapper)((Object)this.myWrappers.get(profile))) == null ? (InspectionProfileWrapper)ConcurrencyUtil.cacheOrGet(this.myWrappers, (Object)profile, (Object)((Object)new MyInspectionProfileWrapper(profile, this.myUseSpellCheck))) : wrapper;
            if (myInspectionProfileWrapper == null) {
                MyInspectionProfileStrategy.$$$reportNull$$$0(1);
            }
            return myInspectionProfileWrapper;
        }

        public void setUseSpellCheck(boolean useSpellCheck) {
            this.myUseSpellCheck = useSpellCheck;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization$MyInspectionProfileStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization$MyInspectionProfileStrategy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyInspectionProfileWrapper
    extends InspectionProfileWrapper {
        private final boolean myUseSpellCheck;

        MyInspectionProfileWrapper(@NotNull InspectionProfile inspectionProfile, boolean useSpellCheck) {
            if (inspectionProfile == null) {
                MyInspectionProfileWrapper.$$$reportNull$$$0(0);
            }
            super((InspectionProfileImpl)inspectionProfile);
            this.myUseSpellCheck = useSpellCheck;
        }

        public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
            return key != null && SpellCheckingEditorCustomization.getSpellCheckingToolNames().contains(key.getShortName()) ? this.myUseSpellCheck : super.isToolEnabled(key, element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization$MyInspectionProfileWrapper", "<init>"));
        }
    }
}

