/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.ide.util.RunOnceUtil;
import com.intellij.notification.Notification;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.fetch.GitFetchSupport;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitShallowRepositoryCheckKt;
import git4idea.repo.ShallowRepositoryNotification;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lgit4idea/repo/GitShallowRepositoryCheck;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "suggestToUnshallow", "repository", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
public final class GitShallowRepositoryCheck
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        List<GitRepository> list = GitRepositoryManager.getInstance(project).getRepositories();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
        GitRepository gitRepository = (GitRepository)CollectionsKt.singleOrNull(list);
        if (gitRepository == null) {
            return Unit.INSTANCE;
        }
        GitRepository repository2 = gitRepository;
        RunOnceUtil.runOnceForProject((Project)project, (String)"git.unshallow", () -> GitShallowRepositoryCheck.execute$lambda$0(this, repository2, project));
        return Unit.INSTANCE;
    }

    private final void suggestToUnshallow(GitRepository repository2, Project project) {
        if (repository2.getInfo().isShallow()) {
            GitFetchSupport gitFetchSupport = GitFetchSupport.fetchSupport(project);
            Intrinsics.checkNotNullExpressionValue((Object)gitFetchSupport, (String)"fetchSupport(...)");
            GitFetchSupport fetcher = gitFetchSupport;
            GitRemote remote = fetcher.getDefaultRemoteToFetch(repository2);
            if (remote == null) {
                GitShallowRepositoryCheckKt.access$getLOG$p().debug("Couldn't detect remote for shallow repository");
                return;
            }
            VcsNotifier.getInstance((Project)project).notify((Notification)new ShallowRepositoryNotification());
        }
    }

    private static final void execute$lambda$0(GitShallowRepositoryCheck this$0, GitRepository $repository, Project $project) {
        this$0.suggestToUnshallow($repository, $project);
    }
}

