/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class PositionStackGeocoder
extends JsonGeocoder {
    private static String formatUrl(String key) {
        return "http://api.positionstack.com/v1/reverse?access_key=" + key + "&query=%f,%f";
    }

    public PositionStackGeocoder(Client client, String key, int cacheSize, AddressFormat addressFormat) {
        super(client, PositionStackGeocoder.formatUrl(key), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonArray result = json.getJsonArray("data");
        if (result != null && !result.isEmpty()) {
            JsonObject record = result.getJsonObject(0);
            Address address = new Address();
            address.setFormattedAddress(this.readValue(record, "label"));
            address.setHouse(this.readValue(record, "number"));
            address.setStreet(this.readValue(record, "street"));
            address.setSuburb(this.readValue(record, "neighbourhood"));
            address.setSettlement(this.readValue(record, "locality"));
            address.setState(this.readValue(record, "region"));
            address.setCountry(this.readValue(record, "country_code"));
            address.setPostcode(this.readValue(record, "postal_code"));
            return address;
        }
        return null;
    }
}

