/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.internal.NonNull;
import com.google.firebase.remoteconfig.OneOfCondition;
import com.google.firebase.remoteconfig.internal.ServerTemplateResponse;
import java.util.Objects;

final class ServerCondition {
    private String name;
    private OneOfCondition serverCondition;

    ServerCondition(@NonNull String name, @NonNull OneOfCondition condition) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"condition name must not be null or empty");
        this.name = name;
        this.serverCondition = condition;
    }

    ServerCondition(@NonNull ServerTemplateResponse.ServerConditionResponse serverConditionResponse) {
        Preconditions.checkNotNull((Object)serverConditionResponse);
        this.name = serverConditionResponse.getName();
        this.serverCondition = new OneOfCondition(serverConditionResponse.getServerCondition());
    }

    @NonNull
    String getName() {
        return this.name;
    }

    @NonNull
    OneOfCondition getCondition() {
        return this.serverCondition;
    }

    ServerCondition setName(@NonNull String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"condition name must not be null or empty");
        this.name = name;
        return this;
    }

    ServerCondition setServerCondition(@NonNull OneOfCondition condition) {
        Preconditions.checkNotNull((Object)condition, (Object)"condition must not be null or empty");
        this.serverCondition = condition;
        return this;
    }

    ServerTemplateResponse.ServerConditionResponse toServerConditionResponse() {
        return new ServerTemplateResponse.ServerConditionResponse().setName(this.name).setServerCondition(this.serverCondition.toOneOfConditionResponse());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerCondition condition = (ServerCondition)o;
        return Objects.equals(this.name, condition.name) && Objects.equals(this.serverCondition, condition.serverCondition);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.serverCondition);
    }
}

