/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geofence;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.traccar.geofence.GeofenceGeometry;
import org.traccar.helper.DistanceCalculator;

public class GeofenceCircle
extends GeofenceGeometry {
    private final double centerLatitude;
    private final double centerLongitude;
    private final double radius;

    public GeofenceCircle(String wkt) throws ParseException {
        DecodedCircle decoded = this.fromWkt(wkt);
        this.centerLatitude = decoded.latitude;
        this.centerLongitude = decoded.longitude;
        this.radius = decoded.radius;
        this.setMin(new GeofenceGeometry.Coordinate(this.centerLatitude - this.radius, this.centerLongitude - this.radius));
        this.setMax(new GeofenceGeometry.Coordinate(this.centerLatitude + this.radius, this.centerLongitude + this.radius));
    }

    @Override
    protected boolean containsPointInternal(double latitude, double longitude) {
        return DistanceCalculator.distance(this.centerLatitude, this.centerLongitude, latitude, longitude) <= this.radius;
    }

    @Override
    public double calculateArea() {
        return Math.PI * this.radius * this.radius;
    }

    @Override
    public String toWkt() {
        Object wkt = "CIRCLE (";
        wkt = (String)wkt + String.valueOf(this.centerLatitude);
        wkt = (String)wkt + " ";
        wkt = (String)wkt + String.valueOf(this.centerLongitude);
        wkt = (String)wkt + ", ";
        DecimalFormat format = new DecimalFormat("0.#");
        wkt = (String)wkt + format.format(this.radius);
        wkt = (String)wkt + ")";
        return wkt;
    }

    public DecodedCircle fromWkt(String wkt) throws ParseException {
        double radius;
        double centerLongitude;
        double centerLatitude;
        if (!wkt.startsWith("CIRCLE")) {
            throw new ParseException("Mismatch geometry type", 0);
        }
        String content = wkt.substring(wkt.indexOf("(") + 1, wkt.indexOf(")"));
        if (content.isEmpty()) {
            throw new ParseException("No content", 0);
        }
        String[] commaTokens = content.split(",");
        if (commaTokens.length != 2) {
            throw new ParseException("Not valid content", 0);
        }
        String[] tokens = commaTokens[0].split("\\s");
        if (tokens.length != 2) {
            throw new ParseException("Too much or less coordinates", 0);
        }
        try {
            centerLatitude = Double.parseDouble(tokens[0]);
        }
        catch (NumberFormatException e) {
            throw new ParseException(tokens[0] + " is not a double", 0);
        }
        try {
            centerLongitude = Double.parseDouble(tokens[1]);
        }
        catch (NumberFormatException e) {
            throw new ParseException(tokens[1] + " is not a double", 0);
        }
        try {
            radius = Double.parseDouble(commaTokens[1]);
        }
        catch (NumberFormatException e) {
            throw new ParseException(commaTokens[1] + " is not a double", 0);
        }
        return new DecodedCircle(centerLatitude, centerLongitude, radius);
    }

    public record DecodedCircle(double latitude, double longitude, double radius) {
    }
}

