/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LineBasedFrameDecoder;
import org.traccar.NetworkMessage;

public class AlematicsFrameDecoder
extends LineBasedFrameDecoder {
    private static final int MESSAGE_MINIMUM_LENGTH = 2;

    public AlematicsFrameDecoder(int maxFrameLength) {
        super(maxFrameLength);
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
        if (buf.readableBytes() < 2) {
            return null;
        }
        if (buf.getUnsignedShort(buf.readerIndex()) == 64248) {
            ByteBuf heartbeat = buf.readRetainedSlice(12);
            if (ctx != null && ctx.channel() != null) {
                ctx.channel().writeAndFlush((Object)new NetworkMessage(heartbeat, ctx.channel().remoteAddress()));
            }
        }
        return super.decode(ctx, buf);
    }
}

