/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import jakarta.inject.Inject;
import org.traccar.BaseProtocol;
import org.traccar.CharacterDelimiterFrameDecoder;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerServer;
import org.traccar.config.Config;
import org.traccar.protocol.Gps103ProtocolDecoder;
import org.traccar.protocol.Gps103ProtocolEncoder;

public class Gps103Protocol
extends BaseProtocol {
    @Inject
    public Gps103Protocol(Config config) {
        this.setSupportedDataCommands("custom", "positionSingle", "positionPeriodic", "positionStop", "engineStop", "engineResume", "alarmArm", "alarmDisarm", "requestPhoto");
        this.addServer(new TrackerServer(config, this.getName(), false){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                pipeline.addLast((ChannelHandler)new CharacterDelimiterFrameDecoder(2048, false, "\r\n", "\n", ";", "*"));
                pipeline.addLast((ChannelHandler)new StringEncoder());
                pipeline.addLast((ChannelHandler)new StringDecoder());
                pipeline.addLast((ChannelHandler)new Gps103ProtocolEncoder(Gps103Protocol.this));
                pipeline.addLast((ChannelHandler)new Gps103ProtocolDecoder(Gps103Protocol.this));
            }
        });
        this.addServer(new TrackerServer(config, this.getName(), true){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                pipeline.addLast((ChannelHandler)new StringEncoder());
                pipeline.addLast((ChannelHandler)new StringDecoder());
                pipeline.addLast((ChannelHandler)new Gps103ProtocolEncoder(Gps103Protocol.this));
                pipeline.addLast((ChannelHandler)new Gps103ProtocolDecoder(Gps103Protocol.this));
            }
        });
    }
}

