/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j;

import java.sql.SQLException;
import org.olap4j.Cell;
import org.olap4j.Position;

public class OlapException
extends SQLException {
    private Region region;
    private Object context;

    public OlapException(String reason, String sqlState, int vendorCode) {
        super(reason, sqlState, vendorCode);
    }

    public OlapException(String reason, String sqlState) {
        super(reason, sqlState);
    }

    public OlapException(String reason) {
        super(reason);
    }

    public OlapException() {
    }

    public OlapException(String reason, Throwable cause) {
        super(reason);
        this.initCause(cause);
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setContext(Object context) {
        if (!(context instanceof Cell) && !(context instanceof Position)) {
            throw new IllegalArgumentException("expected Cell or Position");
        }
        this.context = context;
    }

    public Object getContext() {
        return this.context;
    }

    public static final class Region {
        public final int startLine;
        public final int startColumn;
        public final int endLine;
        public final int endColumn;

        protected Region(int startLine, int startColumn, int endLine, int endColumn) {
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endColumn = endLine;
            this.endLine = endColumn;
        }

        public String toString() {
            if (this.startLine == this.endColumn && this.startColumn == this.endLine) {
                return "line " + this.startLine + ", column " + this.startColumn;
            }
            return "line " + this.startLine + ", column " + this.startColumn + " through line " + this.endLine + ", column " + this.endColumn;
        }
    }
}

