/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.MiniMapFreeColPanel;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.PropertyList;
import net.sf.freecol.common.resources.ResourceManager;

public final class CornerMapControls
extends MapControls {
    private static final Logger logger = Logger.getLogger(CornerMapControls.class.getName());
    private final ImageLibrary lib;
    private final JLabel compassRose;
    private final JPanel miniMapPanel;
    private Image miniMapSkin;
    private MiniMapPanelSkin miniMapPanelSkin;
    private boolean oldUseSkin = false;
    private boolean forceUpdate = false;

    public CornerMapControls(FreeColClient freeColClient) {
        super(freeColClient);
        this.lib = freeColClient.getGUI().getFixedImageLibrary();
        this.compassRose = this.lib.getCompassRose();
        this.compassRose.setFocusable(false);
        this.compassRose.setSize(this.compassRose.getPreferredSize());
        this.compassRose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Unit unit = CornerMapControls.this.getGUI().getActiveUnit();
                if (unit == null) {
                    return;
                }
                int x = e.getX() - CornerMapControls.this.compassRose.getWidth() / 2;
                int y = e.getY() - CornerMapControls.this.compassRose.getHeight() / 2;
                double theta = Math.atan2(y, x) + 1.5707963267948966 + 0.39269908169872414;
                if (theta < 0.0) {
                    theta += Math.PI * 2;
                }
                CornerMapControls.this.igc().moveUnit(unit, Direction.angleToDirection(theta));
            }
        });
        this.miniMapPanel = new MiniMapFreeColPanel(freeColClient);
        this.miniMapPanelSkin = new MiniMapPanelSkin();
        this.miniMapPanel.add(this.miniMapToggleBorders);
        this.miniMapPanel.add(this.miniMapToggleFogOfWarButton);
        this.miniMapPanel.add(this.miniMapZoomInButton);
        this.miniMapPanel.add(this.miniMapZoomOutButton);
        this.miniMapPanel.add(this.miniMapPanelSkin);
        this.miniMapPanel.add(this.miniMap);
        this.updateLayoutIfNeeded();
    }

    @Override
    public void updateLayoutIfNeeded() {
        super.updateLayoutIfNeeded();
        BufferedImage newMinimapSkin = this.lib.getMiniMapSkin();
        if (!(this.forceUpdate || this.oldUseSkin != this.isUseSkin() || this.oldUseSkin && this.miniMapSkin != newMinimapSkin)) {
            return;
        }
        if (!this.isUseSkin()) {
            newMinimapSkin = null;
            MigLayout layout = new MigLayout("ins 0 0 0 0, gap 0 0");
            this.miniMapPanel.setLayout(layout);
            layout.addLayoutComponent(this.miniMap, "newline, grow, shrink, span, w 100%, h 100%");
        } else {
            this.miniMapPanel.setLayout(null);
        }
        this.oldUseSkin = this.isUseSkin();
        this.miniMapSkin = newMinimapSkin;
        this.forceUpdate = false;
        int width = this.lib.scaleInt(220);
        int height = this.lib.scaleInt(128);
        this.miniMap.setSize(new Dimension(width, height));
        if (this.miniMapSkin != null) {
            width = this.miniMapSkin.getWidth(null);
            height = this.miniMapSkin.getHeight(null);
            this.miniMapPanel.setSize(width, height);
            this.miniMapPanelSkin.setLocation(0, 0);
            this.miniMapPanelSkin.setSize(width, height);
            this.miniMapPanel.setOpaque(false);
        } else {
            this.miniMapPanel.setOpaque(true);
        }
        if (this.isUseSkin()) {
            PropertyList pl = ResourceManager.getPropertyList("image.skin.MiniMap.properties");
            this.miniMap.setLocation(this.lib.scaleInt(pl.getInt("minimap.x")), this.lib.scaleInt(pl.getInt("minimap.y")));
            this.miniMap.setSize(this.lib.scaleInt(pl.getInt("minimap.width")), this.lib.scaleInt(pl.getInt("minimap.height")));
            this.centerComponentOnCoordinate(this.miniMapToggleBorders, pl, "politicalButton");
            this.centerComponentOnCoordinate(this.miniMapToggleFogOfWarButton, pl, "fogOfWarButton");
            this.centerComponentOnCoordinate(this.miniMapZoomInButton, pl, "zoomInButton");
            this.centerComponentOnCoordinate(this.miniMapZoomOutButton, pl, "zoomOutButton");
        } else {
            this.miniMapPanel.setPreferredSize(new Dimension(width, height));
            this.getGUI().restoreSavedSize(this.miniMapPanel, new Dimension(width, height));
        }
        this.miniMapPanel.revalidate();
        this.miniMapPanel.repaint();
    }

    private void centerComponentOnCoordinate(JComponent component, PropertyList pl, String key) {
        int x = this.lib.scaleInt(pl.getInt(key + ".x"));
        int y = this.lib.scaleInt(pl.getInt(key + ".y"));
        component.setLocation(x - component.getWidth() / 2, y - component.getHeight() / 2);
    }

    @Override
    public List<JComponent> getComponentsToAdd(Dimension newSize) {
        ArrayList<JComponent> ret = new ArrayList<JComponent>();
        if (this.getGame() == null) {
            return ret;
        }
        int cw = newSize.width;
        int ch = newSize.height;
        if (!this.infoPanel.isShowing() && !this.miniMapPanel.isShowing()) {
            this.forceUpdate = true;
            this.updateLayoutIfNeeded();
            if (!this.getFreeColClient().isMapEditor()) {
                this.infoPanel.setLocation(cw - this.infoPanel.getWidth(), ch - this.infoPanel.getHeight());
                this.miniMapPanel.setLocation(0, ch - this.miniMapPanel.getHeight());
            }
            this.infoPanel.refresh();
            ret.add(this.infoPanel);
            ret.add(this.miniMapPanel);
        }
        if (!this.getFreeColClient().isMapEditor()) {
            boolean rose = this.getClientOptions().getBoolean("model.option.displayCompassRose");
            if (rose && !this.compassRose.isShowing()) {
                this.compassRose.setLocation(cw - this.compassRose.getWidth() - 20, 20);
                ret.add(this.compassRose);
            }
            ret.addAll(this.unitButtons.stream().filter(b -> !b.isShowing()).collect(Collectors.toList()));
            if (!this.unitButtons.isEmpty()) {
                int UNSCALED_SPACE_BETWEEN_BUTTONS = 5;
                int spaceBetweenButtons = this.lib.scaleInt(5);
                Dimension buttonsDimension = CornerMapControls.calculateTotalDimension(this.unitButtons, spaceBetweenButtons);
                int totalWidth = buttonsDimension.width + this.miniMapPanel.getWidth() + this.infoPanel.getWidth();
                if (totalWidth < newSize.width) {
                    Point firstButtonPoint = this.calculateFirstPosition(newSize, this.unitButtons, spaceBetweenButtons, buttonsDimension);
                    this.layoutUnitButtons(this.unitButtons, buttonsDimension, firstButtonPoint, spaceBetweenButtons);
                } else {
                    int numberInTopRow = this.unitButtons.size() / 2;
                    List<UnitButton> bottomRowButtons = this.unitButtons.subList(numberInTopRow, this.unitButtons.size());
                    Dimension buttonsBottomRowDimension = CornerMapControls.calculateTotalDimension(bottomRowButtons, spaceBetweenButtons);
                    Point firstButtonBottomRowPoint = this.calculateFirstPosition(newSize, bottomRowButtons, spaceBetweenButtons, buttonsBottomRowDimension);
                    this.layoutUnitButtons(bottomRowButtons, buttonsDimension, firstButtonBottomRowPoint, spaceBetweenButtons);
                    List<UnitButton> topRowButtons = this.unitButtons.subList(0, numberInTopRow);
                    Dimension buttonsTopRowDimension = CornerMapControls.calculateTotalDimension(topRowButtons, spaceBetweenButtons);
                    Point firstButtonTopRowPoint = this.calculateFirstPosition(newSize, bottomRowButtons, spaceBetweenButtons, buttonsTopRowDimension);
                    this.layoutUnitButtons(topRowButtons, buttonsDimension, new Point(firstButtonTopRowPoint.x, firstButtonBottomRowPoint.y - buttonsTopRowDimension.height - spaceBetweenButtons), spaceBetweenButtons);
                }
            }
        }
        return ret;
    }

    private static Dimension calculateTotalDimension(List<UnitButton> unitButtons, int spaceBetweenButtons) {
        int width = -spaceBetweenButtons;
        int height = 0;
        for (UnitButton ub : unitButtons) {
            if (ub.isShowing()) continue;
            height = Math.max(height, ub.getHeight());
            width += spaceBetweenButtons + ub.getWidth();
        }
        return new Dimension(width, height);
    }

    private Point calculateFirstPosition(Dimension newSize, List<UnitButton> unitButtons, int spaceBetweenButtons, Dimension buttonsDimension) {
        int x = this.miniMapPanel.getWidth() + 1 + (this.infoPanel.getX() - this.miniMapPanel.getWidth() - buttonsDimension.width) / 2;
        int y = newSize.height - buttonsDimension.height - spaceBetweenButtons;
        return new Point(x, y);
    }

    private void layoutUnitButtons(List<UnitButton> unitButtons, Dimension buttonsDimension, Point firstButtonPoint, int spaceBetweenButtons) {
        int x = firstButtonPoint.x;
        int y = firstButtonPoint.y;
        for (UnitButton ub : unitButtons) {
            if (ub.isShowing()) continue;
            ub.setLocation(x, y);
            x += spaceBetweenButtons + ub.getWidth();
            ub.refreshAction();
        }
    }

    @Override
    public List<JComponent> getComponentsPresent() {
        boolean rose;
        ArrayList<JComponent> ret = new ArrayList<JComponent>();
        if (this.isShowingOrIconified(this.infoPanel)) {
            ret.add(this.infoPanel);
        }
        if (this.isShowingOrIconified(this.miniMapPanel)) {
            ret.add(this.miniMapPanel);
        }
        if ((rose = this.getClientOptions().getBoolean("model.option.displayCompassRose")) && this.compassRose.isShowing()) {
            ret.add(this.compassRose);
        }
        for (UnitButton ub : this.unitButtons) {
            if (!ub.isShowing()) continue;
            ret.add(ub);
        }
        return ret;
    }

    private boolean isShowingOrIconified(JComponent panel) {
        JInternalFrame f = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, panel);
        if (f != null && f.isIcon()) {
            return true;
        }
        return panel.isShowing();
    }

    private class MiniMapPanelSkin
    extends JPanel {
        MiniMapPanelSkin() {
            this.setOpaque(false);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (CornerMapControls.this.miniMapSkin != null) {
                graphics.drawImage(CornerMapControls.this.miniMapSkin, 0, 0, null);
            }
        }
    }
}

