/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.parameters.converters;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.TemporalParamConverter;

public class OffsetDateTimeParamConverter
extends TemporalParamConverter<OffsetDateTime> {
    public OffsetDateTimeParamConverter() {
        super(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public OffsetDateTimeParamConverter(DateTimeFormatter formatter) {
        super(formatter);
    }

    @Override
    protected OffsetDateTime convert(String value) {
        return OffsetDateTime.parse(value);
    }

    @Override
    protected OffsetDateTime convert(String value, DateTimeFormatter formatter) {
        return OffsetDateTime.parse(value, formatter);
    }

    public static class Supplier
    extends TemporalParamConverter.TemporalSupplier<OffsetDateTimeParamConverter> {
        public Supplier() {
        }

        public Supplier(String pattern, String dateTimeFormatterProviderClassName) {
            super(pattern, dateTimeFormatterProviderClassName);
        }

        @Override
        protected OffsetDateTimeParamConverter createConverter(DateTimeFormatter dateTimeFormatter) {
            return new OffsetDateTimeParamConverter(dateTimeFormatter);
        }

        @Override
        public String getClassName() {
            return OffsetDateTimeParamConverter.class.getName();
        }
    }
}

