/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ForwardedInfo;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;

final class LocationUtil {
    LocationUtil() {
    }

    static URI determineLocation(URI location) {
        ResteasyReactiveRequestContext request;
        if (!location.isAbsolute() && (request = CurrentRequestManager.get()) != null) {
            location = LocationUtil.getUri(location.toString(), request, true);
        }
        return location;
    }

    static URI getUri(String path, ResteasyReactiveRequestContext request, boolean usePrefix) {
        try {
            String prefix;
            String string = prefix = usePrefix ? LocationUtil.determinePrefix(request.serverRequest(), request.getDeployment()) : "";
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            return new URI(request.getScheme(), request.getAuthority(), null, null, null).resolve(prefix + (String)path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static String determinePrefix(ServerHttpRequest serverHttpRequest, Deployment deployment) {
        ForwardedInfo forwardedInfo;
        Object prefix = "";
        if (deployment != null) {
            prefix = deployment.getPrefix();
        }
        if ((forwardedInfo = serverHttpRequest.getForwardedInfo()) != null && forwardedInfo.getPrefix() != null && !forwardedInfo.getPrefix().isEmpty()) {
            Object forwardedPrefix = forwardedInfo.getPrefix();
            if (!((String)forwardedPrefix).startsWith("/")) {
                forwardedPrefix = "/" + (String)forwardedPrefix;
            }
            prefix = (String)forwardedPrefix + (String)prefix;
        }
        if (((String)prefix).endsWith("/")) {
            prefix = ((String)prefix).substring(0, ((String)prefix).length() - 1);
        }
        return prefix;
    }

    static URI determineContentLocation(URI location) {
        ResteasyReactiveRequestContext request;
        if (!location.isAbsolute() && (request = CurrentRequestManager.get()) != null) {
            location = LocationUtil.getUri(location.toString(), request, false);
        }
        return location;
    }
}

