/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.type;

import org.hibernate.boot.model.relational.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.type.OracleArrayJdbcType;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class OracleNestedTableJdbcType
extends OracleArrayJdbcType {
    public OracleNestedTableJdbcType(JdbcType elementJdbcType, String typeName) {
        super(elementJdbcType, typeName);
    }

    @Override
    public int getDdlTypeCode() {
        return 4000;
    }

    @Override
    public String getExtraCreateTableInfo(JavaType<?> javaType, String columnName, String tableName, Database database) {
        Dialect dialect = database.getDialect();
        BasicPluralJavaType pluralJavaType = (BasicPluralJavaType)((Object)javaType);
        String elementTypeName = OracleNestedTableJdbcType.getTypeName(pluralJavaType.getElementJavaType(), this.getElementJdbcType(), dialect);
        return " nested table " + columnName + " store as \"" + StringHelper.truncate(tableName + " " + columnName + " " + elementTypeName, dialect.getMaxIdentifierLength()) + "\"";
    }

    @Override
    public String toString() {
        return "OracleNestedTableTypeDescriptor(" + this.getSqlTypeName() + ")";
    }
}

