/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.WorkflowStepProvider;

public abstract class GroupBasedStepProvider
implements WorkflowStepProvider {
    private final Logger log = Logger.getLogger(GroupBasedStepProvider.class);
    public static final String CONFIG_GROUP = "group";
    private final KeycloakSession session;
    private final ComponentModel model;

    public GroupBasedStepProvider(KeycloakSession session, ComponentModel model) {
        this.session = session;
        this.model = model;
    }

    public void run(WorkflowExecutionContext context) {
        UserModel user = this.session.users().getUserById(this.getRealm(), context.getResourceId());
        if (user != null) {
            try {
                this.getGroups().forEach(group -> this.run(user, (GroupModel)group));
            }
            catch (Exception e) {
                this.log.errorf((Throwable)e, "Failed to manage group membership for user %s", (Object)user.getId());
            }
        }
    }

    protected abstract void run(UserModel var1, GroupModel var2);

    public void close() {
    }

    private Stream<GroupModel> getGroups() {
        return ((List)this.model.getConfig().getOrDefault((Object)CONFIG_GROUP, List.of())).stream().map(name -> KeycloakModelUtils.findGroupByPath((KeycloakSession)this.session, (RealmModel)this.getRealm(), (String)name));
    }

    private RealmModel getRealm() {
        return this.session.getContext().getRealm();
    }
}

