/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.inputs.http.util;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.time.Duration;
import org.logstash.plugins.inputs.http.util.ExecutionObserver;

public class RejectWhenBlockedInboundHandler
extends ChannelInboundHandlerAdapter {
    private final ExecutionObserver executionObserver;
    private final FullHttpResponse REJECT_RESPONSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.TOO_MANY_REQUESTS, Unpooled.EMPTY_BUFFER);
    private final Duration blockThreshold;

    public RejectWhenBlockedInboundHandler(ExecutionObserver executionObserver, Duration blockThreshold) {
        this.executionObserver = executionObserver;
        this.blockThreshold = blockThreshold;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            if (this.executionObserver.anyExecuting(this.blockThreshold)) {
                FullHttpResponse rejection = this.REJECT_RESPONSE.retainedDuplicate();
                ReferenceCountUtil.release((Object)msg);
                ChannelFuture channelFuture = ctx.writeAndFlush((Object)rejection);
                if (HttpUtil.isKeepAlive((HttpMessage)req) && HttpUtil.is100ContinueExpected((HttpMessage)req)) {
                    channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                } else {
                    channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                return;
            }
        }
        super.channelRead(ctx, msg);
    }
}

