/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.EqualityComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public abstract class CollatingFunction
extends SystemFunctionCall {
    protected StringCollator staticCollation = null;
    private URI expressionBaseURI = null;
    private AtomicComparer atomicComparer = null;

    public void bindStaticContext(StaticContext env) throws XPathException {
        this.expressionBaseURI = ExpressionTool.getBaseURI(env, this, false);
        this.staticCollation = env.getConfiguration().getCollation(env.getDefaultCollationName(), this.expressionBaseURI.toString(), "FOCH0002");
    }

    protected abstract int getCollationArgument();

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        this.preEvaluateCollation(visitor.getStaticContext());
    }

    public URI getExpressionBaseURI() {
        return this.expressionBaseURI;
    }

    public StringCollator getStaticCollation() {
        return this.staticCollation;
    }

    private void preEvaluateCollation(StaticContext env) throws XPathException {
        if ((this.getDetails().properties & 0x20) == 0) {
            GroundedValue collationVal;
            Expression collationExp = this.argument[this.getNumberOfArguments() - 1];
            GroundedValue groundedValue = collationVal = collationExp instanceof Literal ? ((Literal)collationExp).getValue() : null;
            if (collationVal instanceof AtomicValue) {
                String collationName = ((AtomicValue)collationVal).getStringValue();
                try {
                    this.staticCollation = env.getConfiguration().getCollation(collationName, this.expressionBaseURI.toString(), "FOCH0002");
                }
                catch (XPathException e) {
                    e.setLocator(this);
                    throw e;
                }
            } else {
                this.staticCollation = null;
            }
        }
    }

    public Expression copy() {
        CollatingFunction d = (CollatingFunction)super.copy();
        d.expressionBaseURI = this.expressionBaseURI;
        d.staticCollation = this.staticCollation;
        d.atomicComparer = this.atomicComparer;
        return d;
    }

    public boolean equals(Object o) {
        return o instanceof CollatingFunction && super.equals(o) && CollatingFunction.equalOrNull(this.expressionBaseURI, ((CollatingFunction)o).expressionBaseURI) && CollatingFunction.equalOrNull(this.staticCollation, ((CollatingFunction)o).staticCollation);
    }

    public StringCollator getCollator(XPathContext context) throws XPathException {
        StringCollator collator;
        if (this.staticCollation != null) {
            return this.staticCollation;
        }
        int arg = this.getCollationArgument();
        AtomicValue av = (AtomicValue)this.argument[arg].evaluateItem(context);
        StringValue collationValue = (StringValue)av;
        String collationName = collationValue.getStringValue();
        try {
            collationName = CollatingFunction.expandCollationURI(collationName, this.expressionBaseURI);
        }
        catch (XPathException err) {
            err.setLocator(this);
        }
        try {
            collator = context.getConfiguration().getCollation(collationName);
        }
        catch (XPathException e) {
            e.setLocator(this);
            e.setXPathContext(context);
            throw e;
        }
        if (collator == null) {
            XPathException xe = new XPathException("Unrecognized collation: " + collationName, "FOCH0002");
            xe.setLocator(this);
            xe.setXPathContext(context);
            throw xe;
        }
        return collator;
    }

    protected StringCollator getCollatorFromLastArgument(Sequence[] arguments, int arg, XPathContext context) throws XPathException {
        if (arguments.length > arg) {
            String collationName = arguments[arg].head().getStringValue();
            try {
                collationName = CollatingFunction.expandCollationURI(collationName, this.expressionBaseURI);
            }
            catch (XPathException err) {
                err.setLocator(this);
            }
            StringCollator collator = context.getConfiguration().getCollation(collationName);
            if (collator == null) {
                XPathException e = new XPathException("Unknown collation " + collationName);
                e.setErrorCode("FOCH0002");
                throw e;
            }
            return collator;
        }
        return this.staticCollation;
    }

    public static String expandCollationURI(String collationName, URI expressionBaseURI) throws XPathException {
        try {
            URI collationURI = new URI(collationName);
            if (!collationURI.isAbsolute()) {
                if (expressionBaseURI == null) {
                    throw new XPathException("Cannot resolve relative collation URI '" + collationName + "': unknown or invalid base URI", "FOCH0002");
                }
                collationURI = expressionBaseURI.resolve(collationURI);
                collationName = collationURI.toString();
            }
        }
        catch (URISyntaxException e) {
            throw new XPathException("Collation name '" + collationName + "' is not a valid URI", "FOCH0002");
        }
        return collationName;
    }

    protected void preAllocateComparer(AtomicType type0, AtomicType type1, StaticContext env, boolean NaNequalsNaN) {
        StringCollator collation;
        if (type0 == ErrorType.getInstance() || type1 == ErrorType.getInstance()) {
            this.atomicComparer = EqualityComparer.getInstance();
            return;
        }
        if (this.argument.length <= this.getCollationArgument()) {
            collation = this.staticCollation;
        } else if (this.argument[this.argument.length - 1] instanceof StringLiteral) {
            String collationName = ((StringLiteral)this.argument[this.argument.length - 1]).getStringValue();
            try {
                collation = env.getConfiguration().getCollation(collationName, this.expressionBaseURI.toString(), "FOCH0002");
            }
            catch (XPathException err) {
                err.setLocator(this);
                this.argument[this.argument.length - 1] = new ErrorExpression(err);
                return;
            }
        } else {
            return;
        }
        this.atomicComparer = NaNequalsNaN ? AtomicSortComparer.makeSortComparer(collation, type0.getPrimitiveType(), env.makeEarlyEvaluationContext()) : GenericAtomicComparer.makeAtomicComparer((BuiltInAtomicType)type0.getBuiltInBaseType(), (BuiltInAtomicType)type1.getBuiltInBaseType(), this.staticCollation, env.makeEarlyEvaluationContext());
    }

    public AtomicComparer getPreAllocatedAtomicComparer() {
        return this.atomicComparer;
    }

    public AtomicComparer getAtomicComparer(StringCollator collator, XPathContext context) {
        if (this.atomicComparer != null) {
            return this.atomicComparer.provideContext(context);
        }
        return new GenericAtomicComparer(collator, context);
    }
}

