/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common.io;

import java.nio.ByteBuffer;
import java.util.OptionalInt;
import org.logstash.common.io.RecordType;

public class RecordHeader {
    private final RecordType type;
    private final int size;
    private final OptionalInt totalEventSize;
    private final int checksum;

    public RecordHeader(RecordType type, int size, OptionalInt totalEventSize, int checksum) {
        this.type = type;
        this.size = size;
        this.totalEventSize = totalEventSize;
        this.checksum = checksum;
    }

    public RecordType getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public OptionalInt getTotalEventSize() {
        return this.totalEventSize;
    }

    public static RecordHeader get(ByteBuffer currentBlock) {
        RecordType type = RecordType.fromByte(currentBlock.get());
        if (type == null) {
            return null;
        }
        int size = currentBlock.getInt();
        int totalSize = currentBlock.getInt();
        OptionalInt totalEventSize = totalSize != -1 ? OptionalInt.of(totalSize) : OptionalInt.empty();
        int checksum = currentBlock.getInt();
        return new RecordHeader(type, size, totalEventSize, checksum);
    }
}

