/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.common.SourceWithMetadata;
import org.logstash.config.ir.InvalidIRException;
import org.logstash.config.ir.PipelineIR;
import org.logstash.config.ir.PluginDefinition;
import org.logstash.config.ir.graph.Graph;
import org.logstash.config.ir.imperative.Statement;
import org.logstash.plugins.ConfigVariableExpander;

public final class ConfigCompiler {
    private ConfigCompiler() {
    }

    public static PipelineIR configToPipelineIR(List<SourceWithMetadata> sourcesWithMetadata, boolean supportEscapes, ConfigVariableExpander cve) throws InvalidIRException {
        return ConfigCompiler.compileSources(sourcesWithMetadata, supportEscapes, cve);
    }

    public static PipelineIR compileSources(List<SourceWithMetadata> sourcesWithMetadata, boolean supportEscapes, ConfigVariableExpander cve) throws InvalidIRException {
        Map groupedPipelineSections = sourcesWithMetadata.stream().map(swm -> ConfigCompiler.compileGraph(swm, supportEscapes, cve)).flatMap(m -> m.entrySet().stream()).filter(e -> e.getValue() != null).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        Graph inputGraph = Graph.combine((Graph[])groupedPipelineSections.get((Object)((Object)PluginDefinition.Type.INPUT)).toArray(new Graph[0])).graph;
        Graph outputGraph = Graph.combine((Graph[])groupedPipelineSections.get((Object)((Object)PluginDefinition.Type.OUTPUT)).toArray(new Graph[0])).graph;
        Graph filterGraph = groupedPipelineSections.get((Object)PluginDefinition.Type.FILTER).stream().reduce(ConfigCompiler::chainWithUntypedException).orElse(null);
        String originalSource = sourcesWithMetadata.stream().map(SourceWithMetadata::getText).collect(Collectors.joining("\n"));
        return new PipelineIR(inputGraph, filterGraph, outputGraph, originalSource);
    }

    private static Graph chainWithUntypedException(Graph g1, Graph g2) {
        try {
            return g1.chain(g2);
        }
        catch (InvalidIRException iirex) {
            throw new IllegalArgumentException(iirex);
        }
    }

    private static Map<PluginDefinition.Type, Statement> compileImperative(SourceWithMetadata sourceWithMetadata, boolean supportEscapes) {
        IRubyObject compiler = RubyUtil.RUBY.executeScript("require 'logstash/compiler'\nLogStash::Compiler", "");
        IRubyObject code = compiler.callMethod(RubyUtil.RUBY.getCurrentContext(), "compile_imperative", new IRubyObject[]{JavaUtil.convertJavaToRuby((Ruby)RubyUtil.RUBY, (Object)sourceWithMetadata), RubyUtil.RUBY.newBoolean(supportEscapes)});
        RubyHash hash = (RubyHash)code;
        HashMap<PluginDefinition.Type, Statement> result = new HashMap<PluginDefinition.Type, Statement>();
        result.put(PluginDefinition.Type.INPUT, ConfigCompiler.readStatementFromRubyHash(hash, "input"));
        result.put(PluginDefinition.Type.FILTER, ConfigCompiler.readStatementFromRubyHash(hash, "filter"));
        result.put(PluginDefinition.Type.OUTPUT, ConfigCompiler.readStatementFromRubyHash(hash, "output"));
        return result;
    }

    private static Statement readStatementFromRubyHash(RubyHash hash, String key) {
        IRubyObject inputValue = hash.fastARef((IRubyObject)RubyUtil.RUBY.newString(key).intern());
        return (Statement)inputValue.toJava(Statement.class);
    }

    private static Map<PluginDefinition.Type, Graph> compileGraph(SourceWithMetadata swm, boolean supportEscapes, ConfigVariableExpander cve) {
        Map<PluginDefinition.Type, Statement> pluginStatements = ConfigCompiler.compileImperative(swm, supportEscapes);
        return pluginStatements.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ConfigCompiler.toGraphWithUntypedException((Statement)e.getValue(), cve)));
    }

    private static Graph toGraphWithUntypedException(Statement s, ConfigVariableExpander cve) {
        try {
            return s.toGraph(cve);
        }
        catch (InvalidIRException iirex) {
            throw new IllegalArgumentException(iirex);
        }
    }
}

