/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.Sort;
import org.apache.derby.iapi.store.access.conglomerate.SortFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class ExternalSortFactory
implements SortFactory,
ModuleControl,
ModuleSupportable,
SortCostController {
    private boolean userSpecified;
    private int defaultSortBufferMax;
    private int sortBufferMax;
    private static final String IMPLEMENTATIONID = "sort external";
    private static final String FORMATUUIDSTRING = "D2976090-D9F5-11d0-B54D-00A024BF8879";
    private UUID formatUUID = null;
    private static final int DEFAULT_SORTBUFFERMAX = 1024;
    private static final int MINIMUM_SORTBUFFERMAX = 4;
    protected static final int DEFAULT_MEM_USE = 0x100000;
    protected static final int DEFAULT_MAX_MERGE_RUN = 512;
    private static final int SORT_ROW_OVERHEAD = 44;

    @Override
    public Properties defaultProperties() {
        return new Properties();
    }

    @Override
    public boolean supportsImplementation(String implementationId) {
        return implementationId.equals(IMPLEMENTATIONID);
    }

    @Override
    public String primaryImplementationType() {
        return IMPLEMENTATIONID;
    }

    @Override
    public boolean supportsFormat(UUID formatid) {
        return formatid.equals(this.formatUUID);
    }

    @Override
    public UUID primaryFormat() {
        return this.formatUUID;
    }

    protected MergeSort getMergeSort() {
        return new MergeSort();
    }

    @Override
    public Sort createSort(TransactionController tran, int segment, Properties implParameters, DataValueDescriptor[] template, ColumnOrdering[] columnOrdering, SortObserver sortObserver, boolean alreadyInOrder, long estimatedRows, int estimatedRowSize) throws StandardException {
        MergeSort sort = this.getMergeSort();
        if (!this.userSpecified) {
            this.sortBufferMax = estimatedRowSize > 0 ? 0x100000 / (estimatedRowSize += 44 + template.length * 16 + 8) : this.defaultSortBufferMax;
            if (estimatedRows > (long)this.sortBufferMax && (double)estimatedRows * 1.1 < (double)(this.sortBufferMax * 2)) {
                this.sortBufferMax = (int)(estimatedRows / 2L + estimatedRows / 10L);
            }
            if (this.sortBufferMax < 4) {
                this.sortBufferMax = 4;
            }
        } else {
            this.sortBufferMax = this.defaultSortBufferMax;
        }
        if (SanityManager.DEBUG_ON((String)"SortTuning")) {
            SanityManager.DEBUG((String)"SortTuning", (String)("sortBufferMax = " + this.sortBufferMax + " estimatedRows = " + estimatedRows + " estimatedRowSize = " + estimatedRowSize + " defaultSortBufferMax = " + this.defaultSortBufferMax));
        }
        sort.initialize(template, columnOrdering, sortObserver, alreadyInOrder, estimatedRows, this.sortBufferMax);
        return sort;
    }

    @Override
    public SortCostController openSortCostController() throws StandardException {
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public double getSortCost(DataValueDescriptor[] template, ColumnOrdering[] columnOrdering, boolean alreadyInOrder, long estimatedInputRows, long estimatedExportRows, int estimatedRowSize) throws StandardException {
        if (estimatedInputRows == 0L) {
            return 0.0;
        }
        SanityManager.ASSERT((estimatedInputRows >= 0L ? 1 : 0) != 0);
        SanityManager.ASSERT((estimatedExportRows >= 0L ? 1 : 0) != 0);
        double ret_val = 1.0 + 0.32 * (double)estimatedInputRows * Math.log(estimatedInputRows);
        return ret_val;
    }

    @Override
    public boolean canSupport(Properties startParams) {
        if (startParams == null) {
            return false;
        }
        String impl = startParams.getProperty("derby.access.Conglomerate.type");
        if (impl == null) {
            return false;
        }
        return this.supportsImplementation(impl);
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        UUIDFactory uuidFactory = ExternalSortFactory.getMonitor().getUUIDFactory();
        this.formatUUID = uuidFactory.recreateUUID(FORMATUUIDSTRING);
        this.defaultSortBufferMax = PropertyUtil.getSystemInt("derby.storage.sortBufferMax", 0, Integer.MAX_VALUE, 0);
        if (this.defaultSortBufferMax == 0) {
            this.userSpecified = false;
            this.defaultSortBufferMax = 1024;
        } else {
            this.userSpecified = true;
            if (this.defaultSortBufferMax < 4) {
                this.defaultSortBufferMax = 4;
            }
        }
    }

    @Override
    public void stop() {
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

