/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.TypeError;
import org.logstash.config.ir.compiler.ConditionalEvaluationError;
import org.logstash.config.ir.compiler.EventCondition;
import org.logstash.ext.JrubyEventExtLibrary;

public class Utils {
    private static final Logger logger = LogManager.getLogger(Utils.class);

    public static void copyNonCancelledEvents(Collection<JrubyEventExtLibrary.RubyEvent> input, List output) {
        for (JrubyEventExtLibrary.RubyEvent e : input) {
            if (e.getEvent().isCancelled()) continue;
            output.add(e);
        }
    }

    public static void filterEvents(Collection<JrubyEventExtLibrary.RubyEvent> input, EventCondition filter, List fulfilled, List unfulfilled) {
        for (JrubyEventExtLibrary.RubyEvent e : input) {
            boolean isFulfilled;
            try {
                isFulfilled = filter.fulfilled(e);
            }
            catch (IllegalArgumentException | ArgumentError | TypeError ex) {
                e.getEvent().cancel();
                throw new ConditionalEvaluationError(ex, e.getEvent());
            }
            if (isFulfilled) {
                fulfilled.add(e);
                continue;
            }
            unfulfilled.add(e);
        }
    }
}

