/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.secret.password;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class PasswordParamConverter {
    private static final Map<Class, Function<String, ?>> converters = new HashMap();

    public static <T> T convert(Class<T> klass, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value must not be empty.");
        }
        if (Objects.isNull(converters.get(klass))) {
            throw new IllegalArgumentException("No conversion supported for given class.");
        }
        return (T)converters.get(klass).apply(value);
    }

    static {
        converters.put(Integer.class, Integer::parseInt);
        converters.put(String.class, String::toString);
        converters.put(Boolean.class, Boolean::parseBoolean);
        converters.put(Double.class, Double::parseDouble);
    }
}

