/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filters.parser;

import java.math.BigDecimal;
import org.joda.time.Instant;
import org.logstash.filters.parser.TimestampParser;

public class TAI64NParser
implements TimestampParser {
    @Override
    public Instant parse(String value) {
        int offset = 0;
        if (value.startsWith("@")) {
            offset = 1;
        }
        long secondsSinceEpoch = Long.parseLong(value.substring(offset, 16 + offset), 16) & 0x3FFFFFFFFFFFFFFFL;
        int nanoseconds = Integer.parseInt(value.substring(16 + offset, 24 + offset), 16);
        return new Instant((secondsSinceEpoch -= 10L) * 1000L + (long)(nanoseconds / 1000000));
    }

    @Override
    public Instant parse(Long value) {
        throw new IllegalArgumentException("Expected a string value, but got a long (" + value + "). Cannot parse date.");
    }

    @Override
    public Instant parse(Double value) {
        throw new IllegalArgumentException("Expected a string value, but got a double (" + value + "). Cannot parse date.");
    }

    @Override
    public Instant parse(BigDecimal value) {
        throw new IllegalArgumentException("Expected a string value, but got a bigdecimal (" + value + "). Cannot parse date.");
    }

    @Override
    public Instant parseWithTimeZone(String value, String timezone) {
        return this.parse(value);
    }
}

