/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.util.spvc.SpvcErrorCallbackI;
import org.lwjgl.util.spvc.SpvcHLSLResourceBinding;
import org.lwjgl.util.spvc.SpvcHlslRootConstants;
import org.lwjgl.util.spvc.SpvcHlslVertexAttributeRemap;
import org.lwjgl.util.spvc.SpvcMslConstexprSampler;
import org.lwjgl.util.spvc.SpvcMslResourceBinding;
import org.lwjgl.util.spvc.SpvcMslSamplerYcbcrConversion;
import org.lwjgl.util.spvc.SpvcMslShaderInput;
import org.lwjgl.util.spvc.SpvcMslVertexAttribute;
import org.lwjgl.util.spvc.SpvcSpecializationConstant;

public class Spvc {
    private static final SharedLibrary SPVC = Library.loadNative(Spvc.class, (String)"org.lwjgl.spvc", (String)((String)Configuration.SPVC_LIBRARY_NAME.get((Object)Platform.mapLibraryNameBundled((String)"spirv-cross"))), (boolean)true);
    public static final int SPVC_C_API_VERSION_MAJOR = 0;
    public static final int SPVC_C_API_VERSION_MINOR = 48;
    public static final int SPVC_C_API_VERSION_PATCH = 0;
    public static final int SPVC_COMPILER_OPTION_COMMON_BIT = 0x1000000;
    public static final int SPVC_COMPILER_OPTION_GLSL_BIT = 0x2000000;
    public static final int SPVC_COMPILER_OPTION_HLSL_BIT = 0x4000000;
    public static final int SPVC_COMPILER_OPTION_MSL_BIT = 0x8000000;
    public static final int SPVC_COMPILER_OPTION_LANG_BITS = 0xF000000;
    public static final int SPVC_COMPILER_OPTION_ENUM_BITS = 0xFFFFFF;
    public static final int SPVC_MSL_PUSH_CONSTANT_DESC_SET = -1;
    public static final int SPVC_MSL_PUSH_CONSTANT_BINDING = 0;
    public static final int SPVC_MSL_SWIZZLE_BUFFER_BINDING = -2;
    public static final int SPVC_MSL_BUFFER_SIZE_BUFFER_BINDING = -3;
    public static final int SPVC_MSL_ARGUMENT_BUFFER_BINDING = -4;
    public static final int SPVC_MSL_AUX_BUFFER_STRUCT_VERSION = 1;
    public static final int SPVC_SUCCESS = 0;
    public static final int SPVC_ERROR_INVALID_SPIRV = -1;
    public static final int SPVC_ERROR_UNSUPPORTED_SPIRV = -2;
    public static final int SPVC_ERROR_OUT_OF_MEMORY = -3;
    public static final int SPVC_ERROR_INVALID_ARGUMENT = -4;
    public static final int SPVC_CAPTURE_MODE_COPY = 0;
    public static final int SPVC_CAPTURE_MODE_TAKE_OWNERSHIP = 1;
    public static final int SPVC_BACKEND_NONE = 0;
    public static final int SPVC_BACKEND_GLSL = 1;
    public static final int SPVC_BACKEND_HLSL = 2;
    public static final int SPVC_BACKEND_MSL = 3;
    public static final int SPVC_BACKEND_CPP = 4;
    public static final int SPVC_BACKEND_JSON = 5;
    public static final int SPVC_RESOURCE_TYPE_UNKNOWN = 0;
    public static final int SPVC_RESOURCE_TYPE_UNIFORM_BUFFER = 1;
    public static final int SPVC_RESOURCE_TYPE_STORAGE_BUFFER = 2;
    public static final int SPVC_RESOURCE_TYPE_STAGE_INPUT = 3;
    public static final int SPVC_RESOURCE_TYPE_STAGE_OUTPUT = 4;
    public static final int SPVC_RESOURCE_TYPE_SUBPASS_INPUT = 5;
    public static final int SPVC_RESOURCE_TYPE_STORAGE_IMAGE = 6;
    public static final int SPVC_RESOURCE_TYPE_SAMPLED_IMAGE = 7;
    public static final int SPVC_RESOURCE_TYPE_ATOMIC_COUNTER = 8;
    public static final int SPVC_RESOURCE_TYPE_PUSH_CONSTANT = 9;
    public static final int SPVC_RESOURCE_TYPE_SEPARATE_IMAGE = 10;
    public static final int SPVC_RESOURCE_TYPE_SEPARATE_SAMPLERS = 11;
    public static final int SPVC_RESOURCE_TYPE_ACCELERATION_STRUCTURE = 12;
    public static final int SPVC_RESOURCE_TYPE_RAY_QUERY = 13;
    public static final int SPVC_BUILTIN_RESOURCE_TYPE_UNKNOWN = 0;
    public static final int SPVC_BUILTIN_RESOURCE_TYPE_STAGE_INPUT = 1;
    public static final int SPVC_BUILTIN_RESOURCE_TYPE_STAGE_OUTPUT = 2;
    public static final int SPVC_BASETYPE_UNKNOWN = 0;
    public static final int SPVC_BASETYPE_VOID = 1;
    public static final int SPVC_BASETYPE_BOOLEAN = 2;
    public static final int SPVC_BASETYPE_INT8 = 3;
    public static final int SPVC_BASETYPE_UINT8 = 4;
    public static final int SPVC_BASETYPE_INT16 = 5;
    public static final int SPVC_BASETYPE_UINT16 = 6;
    public static final int SPVC_BASETYPE_INT32 = 7;
    public static final int SPVC_BASETYPE_UINT32 = 8;
    public static final int SPVC_BASETYPE_INT64 = 9;
    public static final int SPVC_BASETYPE_UINT64 = 10;
    public static final int SPVC_BASETYPE_ATOMIC_COUNTER = 11;
    public static final int SPVC_BASETYPE_FP16 = 12;
    public static final int SPVC_BASETYPE_FP32 = 13;
    public static final int SPVC_BASETYPE_FP64 = 14;
    public static final int SPVC_BASETYPE_STRUCT = 15;
    public static final int SPVC_BASETYPE_IMAGE = 16;
    public static final int SPVC_BASETYPE_SAMPLED_IMAGE = 17;
    public static final int SPVC_BASETYPE_SAMPLER = 18;
    public static final int SPVC_BASETYPE_ACCELERATION_STRUCTURE = 19;
    public static final int SPVC_MSL_PLATFORM_IOS = 0;
    public static final int SPVC_MSL_PLATFORM_MACOS = 1;
    public static final int SPVC_MSL_INDEX_TYPE_NONE = 0;
    public static final int SPVC_MSL_INDEX_TYPE_UINT16 = 1;
    public static final int SPVC_MSL_INDEX_TYPE_UINT32 = 2;
    public static final int SPVC_MSL_SHADER_INPUT_FORMAT_OTHER = 0;
    public static final int SPVC_MSL_SHADER_INPUT_FORMAT_UINT8 = 1;
    public static final int SPVC_MSL_SHADER_INPUT_FORMAT_UINT16 = 2;
    public static final int SPVC_MSL_SHADER_INPUT_FORMAT_ANY16 = 3;
    public static final int SPVC_MSL_SHADER_INPUT_FORMAT_ANY32 = 4;
    public static final int SPVC_MSL_VERTEX_FORMAT_OTHER = 0;
    public static final int SPVC_MSL_VERTEX_FORMAT_UINT8 = 1;
    public static final int SPVC_MSL_VERTEX_FORMAT_UINT16 = 2;
    public static final int SPVC_MSL_SAMPLER_COORD_NORMALIZED = 0;
    public static final int SPVC_MSL_SAMPLER_COORD_PIXEL = 1;
    public static final int SPVC_MSL_SAMPLER_FILTER_NEAREST = 0;
    public static final int SPVC_MSL_SAMPLER_FILTER_LINEAR = 1;
    public static final int SPVC_MSL_SAMPLER_MIP_FILTER_NONE = 0;
    public static final int SPVC_MSL_SAMPLER_MIP_FILTER_NEAREST = 1;
    public static final int SPVC_MSL_SAMPLER_MIP_FILTER_LINEAR = 2;
    public static final int SPVC_MSL_SAMPLER_ADDRESS_CLAMP_TO_ZERO = 0;
    public static final int SPVC_MSL_SAMPLER_ADDRESS_CLAMP_TO_EDGE = 1;
    public static final int SPVC_MSL_SAMPLER_ADDRESS_CLAMP_TO_BORDER = 2;
    public static final int SPVC_MSL_SAMPLER_ADDRESS_REPEAT = 3;
    public static final int SPVC_MSL_SAMPLER_ADDRESS_MIRRORED_REPEAT = 4;
    public static final int SPVC_MSL_SAMPLER_COMPARE_FUNC_NEVER = 0;
    public static final int SPVC_MSL_SAMPLER_COMPARE_FUNC_LESS = 1;
    public static final int SPVC_MSL_SAMPLER_COMPARE_FUNC_LESS_EQUAL = 2;
    public static final int SPVC_MSL_SAMPLER_COMPARE_FUNC_GREATER = 3;
    public static final int SPVC_MSL_SAMPLER_COMPARE_FUNC_GREATER_EQUAL = 4;
    public static final int SPVC_MSL_SAMPLER_COMPARE_FUNC_EQUAL = 5;
    public static final int SPVC_MSL_SAMPLER_COMPARE_FUNC_NOT_EQUAL = 6;
    public static final int SPVC_MSL_SAMPLER_COMPARE_FUNC_ALWAYS = 7;
    public static final int SPVC_MSL_SAMPLER_BORDER_COLOR_TRANSPARENT_BLACK = 0;
    public static final int SPVC_MSL_SAMPLER_BORDER_COLOR_OPAQUE_BLACK = 1;
    public static final int SPVC_MSL_SAMPLER_BORDER_COLOR_OPAQUE_WHITE = 2;
    public static final int SPVC_MSL_FORMAT_RESOLUTION_444 = 0;
    public static final int SPVC_MSL_FORMAT_RESOLUTION_422 = 1;
    public static final int SPVC_MSL_FORMAT_RESOLUTION_420 = 2;
    public static final int SPVC_MSL_CHROMA_LOCATION_COSITED_EVEN = 0;
    public static final int SPVC_MSL_CHROMA_LOCATION_MIDPOINT = 1;
    public static final int SPVC_MSL_COMPONENT_SWIZZLE_IDENTITY = 0;
    public static final int SPVC_MSL_COMPONENT_SWIZZLE_ZERO = 1;
    public static final int SPVC_MSL_COMPONENT_SWIZZLE_ONE = 2;
    public static final int SPVC_MSL_COMPONENT_SWIZZLE_R = 3;
    public static final int SPVC_MSL_COMPONENT_SWIZZLE_G = 4;
    public static final int SPVC_MSL_COMPONENT_SWIZZLE_B = 5;
    public static final int SPVC_MSL_COMPONENT_SWIZZLE_A = 6;
    public static final int SPVC_MSL_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY = 0;
    public static final int SPVC_MSL_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY = 1;
    public static final int SPVC_MSL_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_BT_709 = 2;
    public static final int SPVC_MSL_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_BT_601 = 3;
    public static final int SPVC_MSL_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_BT_2020 = 4;
    public static final int SPVC_MSL_SAMPLER_YCBCR_RANGE_ITU_FULL = 0;
    public static final int SPVC_MSL_SAMPLER_YCBCR_RANGE_ITU_NARROW = 1;
    public static final int SPVC_HLSL_BINDING_AUTO_NONE_BIT = 0;
    public static final int SPVC_HLSL_BINDING_AUTO_PUSH_CONSTANT_BIT = 1;
    public static final int SPVC_HLSL_BINDING_AUTO_CBV_BIT = 2;
    public static final int SPVC_HLSL_BINDING_AUTO_SRV_BIT = 4;
    public static final int SPVC_HLSL_BINDING_AUTO_UAV_BIT = 8;
    public static final int SPVC_HLSL_BINDING_AUTO_SAMPLER_BIT = 16;
    public static final int SPVC_HLSL_BINDING_AUTO_ALL = Integer.MAX_VALUE;
    public static final int SPVC_HLSL_PUSH_CONSTANT_DESC_SET = -1;
    public static final int SPVC_HLSL_PUSH_CONSTANT_BINDING = 0;
    public static final int SPVC_COMPILER_OPTION_UNKNOWN = 0;
    public static final int SPVC_COMPILER_OPTION_FORCE_TEMPORARY = 0x1000001;
    public static final int SPVC_COMPILER_OPTION_FLATTEN_MULTIDIMENSIONAL_ARRAYS = 0x1000002;
    public static final int SPVC_COMPILER_OPTION_FIXUP_DEPTH_CONVENTION = 0x1000003;
    public static final int SPVC_COMPILER_OPTION_FLIP_VERTEX_Y = 0x1000004;
    public static final int SPVC_COMPILER_OPTION_GLSL_SUPPORT_NONZERO_BASE_INSTANCE = 0x2000005;
    public static final int SPVC_COMPILER_OPTION_GLSL_SEPARATE_SHADER_OBJECTS = 0x2000006;
    public static final int SPVC_COMPILER_OPTION_GLSL_ENABLE_420PACK_EXTENSION = 0x2000007;
    public static final int SPVC_COMPILER_OPTION_GLSL_VERSION = 0x2000008;
    public static final int SPVC_COMPILER_OPTION_GLSL_ES = 0x2000009;
    public static final int SPVC_COMPILER_OPTION_GLSL_VULKAN_SEMANTICS = 0x200000A;
    public static final int SPVC_COMPILER_OPTION_GLSL_ES_DEFAULT_FLOAT_PRECISION_HIGHP = 0x200000B;
    public static final int SPVC_COMPILER_OPTION_GLSL_ES_DEFAULT_INT_PRECISION_HIGHP = 0x200000C;
    public static final int SPVC_COMPILER_OPTION_HLSL_SHADER_MODEL = 0x400000D;
    public static final int SPVC_COMPILER_OPTION_HLSL_POINT_SIZE_COMPAT = 0x400000E;
    public static final int SPVC_COMPILER_OPTION_HLSL_POINT_COORD_COMPAT = 0x400000F;
    public static final int SPVC_COMPILER_OPTION_HLSL_SUPPORT_NONZERO_BASE_VERTEX_BASE_INSTANCE = 0x4000010;
    public static final int SPVC_COMPILER_OPTION_MSL_VERSION = 0x8000011;
    public static final int SPVC_COMPILER_OPTION_MSL_TEXEL_BUFFER_TEXTURE_WIDTH = 134217746;
    public static final int SPVC_COMPILER_OPTION_MSL_AUX_BUFFER_INDEX = 134217747;
    public static final int SPVC_COMPILER_OPTION_MSL_SWIZZLE_BUFFER_INDEX = 134217747;
    public static final int SPVC_COMPILER_OPTION_MSL_INDIRECT_PARAMS_BUFFER_INDEX = 134217748;
    public static final int SPVC_COMPILER_OPTION_MSL_SHADER_OUTPUT_BUFFER_INDEX = 134217749;
    public static final int SPVC_COMPILER_OPTION_MSL_SHADER_PATCH_OUTPUT_BUFFER_INDEX = 134217750;
    public static final int SPVC_COMPILER_OPTION_MSL_SHADER_TESS_FACTOR_OUTPUT_BUFFER_INDEX = 134217751;
    public static final int SPVC_COMPILER_OPTION_MSL_SHADER_INPUT_WORKGROUP_INDEX = 0x8000018;
    public static final int SPVC_COMPILER_OPTION_MSL_ENABLE_POINT_SIZE_BUILTIN = 134217753;
    public static final int SPVC_COMPILER_OPTION_MSL_DISABLE_RASTERIZATION = 134217754;
    public static final int SPVC_COMPILER_OPTION_MSL_CAPTURE_OUTPUT_TO_BUFFER = 134217755;
    public static final int SPVC_COMPILER_OPTION_MSL_SWIZZLE_TEXTURE_SAMPLES = 134217756;
    public static final int SPVC_COMPILER_OPTION_MSL_PAD_FRAGMENT_OUTPUT_COMPONENTS = 134217757;
    public static final int SPVC_COMPILER_OPTION_MSL_TESS_DOMAIN_ORIGIN_LOWER_LEFT = 134217758;
    public static final int SPVC_COMPILER_OPTION_MSL_PLATFORM = 134217759;
    public static final int SPVC_COMPILER_OPTION_MSL_ARGUMENT_BUFFERS = 0x8000020;
    public static final int SPVC_COMPILER_OPTION_GLSL_EMIT_PUSH_CONSTANT_AS_UNIFORM_BUFFER = 0x2000021;
    public static final int SPVC_COMPILER_OPTION_MSL_TEXTURE_BUFFER_NATIVE = 0x8000022;
    public static final int SPVC_COMPILER_OPTION_GLSL_EMIT_UNIFORM_BUFFER_AS_PLAIN_UNIFORMS = 0x2000023;
    public static final int SPVC_COMPILER_OPTION_MSL_BUFFER_SIZE_BUFFER_INDEX = 134217764;
    public static final int SPVC_COMPILER_OPTION_EMIT_LINE_DIRECTIVES = 16777253;
    public static final int SPVC_COMPILER_OPTION_MSL_MULTIVIEW = 134217766;
    public static final int SPVC_COMPILER_OPTION_MSL_VIEW_MASK_BUFFER_INDEX = 134217767;
    public static final int SPVC_COMPILER_OPTION_MSL_DEVICE_INDEX = 0x8000028;
    public static final int SPVC_COMPILER_OPTION_MSL_VIEW_INDEX_FROM_DEVICE_INDEX = 134217769;
    public static final int SPVC_COMPILER_OPTION_MSL_DISPATCH_BASE = 134217770;
    public static final int SPVC_COMPILER_OPTION_MSL_DYNAMIC_OFFSETS_BUFFER_INDEX = 134217771;
    public static final int SPVC_COMPILER_OPTION_MSL_TEXTURE_1D_AS_2D = 134217772;
    public static final int SPVC_COMPILER_OPTION_MSL_ENABLE_BASE_INDEX_ZERO = 134217773;
    public static final int SPVC_COMPILER_OPTION_MSL_IOS_FRAMEBUFFER_FETCH_SUBPASS = 134217774;
    public static final int SPVC_COMPILER_OPTION_MSL_FRAMEBUFFER_FETCH_SUBPASS = 134217774;
    public static final int SPVC_COMPILER_OPTION_MSL_INVARIANT_FP_MATH = 134217775;
    public static final int SPVC_COMPILER_OPTION_MSL_EMULATE_CUBEMAP_ARRAY = 0x8000030;
    public static final int SPVC_COMPILER_OPTION_MSL_ENABLE_DECORATION_BINDING = 134217777;
    public static final int SPVC_COMPILER_OPTION_MSL_FORCE_ACTIVE_ARGUMENT_BUFFER_RESOURCES = 134217778;
    public static final int SPVC_COMPILER_OPTION_MSL_FORCE_NATIVE_ARRAYS = 0x8000033;
    public static final int SPVC_COMPILER_OPTION_ENABLE_STORAGE_IMAGE_QUALIFIER_DEDUCTION = 16777268;
    public static final int SPVC_COMPILER_OPTION_HLSL_FORCE_STORAGE_BUFFER_AS_UAV = 67108917;
    public static final int SPVC_COMPILER_OPTION_FORCE_ZERO_INITIALIZED_VARIABLES = 16777270;
    public static final int SPVC_COMPILER_OPTION_HLSL_NONWRITABLE_UAV_TEXTURE_AS_SRV = 67108919;
    public static final int SPVC_COMPILER_OPTION_MSL_ENABLE_FRAG_OUTPUT_MASK = 0x8000038;
    public static final int SPVC_COMPILER_OPTION_MSL_ENABLE_FRAG_DEPTH_BUILTIN = 134217785;
    public static final int SPVC_COMPILER_OPTION_MSL_ENABLE_FRAG_STENCIL_REF_BUILTIN = 134217786;
    public static final int SPVC_COMPILER_OPTION_MSL_ENABLE_CLIP_DISTANCE_USER_VARYING = 134217787;
    public static final int SPVC_COMPILER_OPTION_HLSL_ENABLE_16BIT_TYPES = 67108924;
    public static final int SPVC_COMPILER_OPTION_MSL_MULTI_PATCH_WORKGROUP = 134217789;
    public static final int SPVC_COMPILER_OPTION_MSL_SHADER_INPUT_BUFFER_INDEX = 134217790;
    public static final int SPVC_COMPILER_OPTION_MSL_SHADER_INDEX_BUFFER_INDEX = 134217791;
    public static final int SPVC_COMPILER_OPTION_MSL_VERTEX_FOR_TESSELLATION = 0x8000040;
    public static final int SPVC_COMPILER_OPTION_MSL_VERTEX_INDEX_TYPE = 134217793;
    public static final int SPVC_COMPILER_OPTION_GLSL_FORCE_FLATTENED_IO_BLOCKS = 0x2000042;
    public static final int SPVC_COMPILER_OPTION_MSL_MULTIVIEW_LAYERED_RENDERING = 134217795;
    public static final int SPVC_COMPILER_OPTION_MSL_ARRAYED_SUBPASS_INPUT = 0x8000044;
    public static final int SPVC_COMPILER_OPTION_MSL_R32UI_LINEAR_TEXTURE_ALIGNMENT = 134217797;
    public static final int SPVC_COMPILER_OPTION_MSL_R32UI_ALIGNMENT_CONSTANT_ID = 134217798;
    public static final int SPVC_COMPILER_OPTION_HLSL_FLATTEN_MATRIX_VERTEX_INPUT_SEMANTICS = 0x4000047;
    public static final int SPVC_COMPILER_OPTION_MSL_IOS_USE_SIMDGROUP_FUNCTIONS = 0x8000048;
    public static final int SPVC_COMPILER_OPTION_MSL_EMULATE_SUBGROUPS = 134217801;
    public static final int SPVC_COMPILER_OPTION_MSL_FIXED_SUBGROUP_SIZE = 134217802;
    public static final int SPVC_COMPILER_OPTION_MSL_FORCE_SAMPLE_RATE_SHADING = 134217803;
    public static final int SPVC_COMPILER_OPTION_MSL_IOS_SUPPORT_BASE_VERTEX_INSTANCE = 134217804;
    public static final int SPVC_COMPILER_OPTION_GLSL_OVR_MULTIVIEW_VIEW_COUNT = 33554509;

    public static SharedLibrary getLibrary() {
        return SPVC;
    }

    protected Spvc() {
        throw new UnsupportedOperationException();
    }

    public static void nspvc_get_version(long major, long minor, long patch) {
        long __functionAddress = Functions.get_version;
        JNI.invokePPPV((long)major, (long)minor, (long)patch, (long)__functionAddress);
    }

    public static void spvc_get_version(@NativeType(value="unsigned int *") IntBuffer major, @NativeType(value="unsigned int *") IntBuffer minor, @NativeType(value="unsigned int *") IntBuffer patch) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)major, (int)1);
            Checks.check((Buffer)minor, (int)1);
            Checks.check((Buffer)patch, (int)1);
        }
        Spvc.nspvc_get_version(MemoryUtil.memAddress((IntBuffer)major), MemoryUtil.memAddress((IntBuffer)minor), MemoryUtil.memAddress((IntBuffer)patch));
    }

    public static long nspvc_get_commit_revision_and_timestamp() {
        long __functionAddress = Functions.get_commit_revision_and_timestamp;
        return JNI.invokeP((long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String spvc_get_commit_revision_and_timestamp() {
        long __result = Spvc.nspvc_get_commit_revision_and_timestamp();
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static void nspvc_msl_vertex_attribute_init(long attr) {
        long __functionAddress = Functions.msl_vertex_attribute_init;
        JNI.invokePV((long)attr, (long)__functionAddress);
    }

    public static void spvc_msl_vertex_attribute_init(@NativeType(value="spvc_msl_vertex_attribute *") SpvcMslVertexAttribute attr) {
        Spvc.nspvc_msl_vertex_attribute_init(attr.address());
    }

    public static void nspvc_msl_shader_input_init(long input) {
        long __functionAddress = Functions.msl_shader_input_init;
        JNI.invokePV((long)input, (long)__functionAddress);
    }

    public static void spvc_msl_shader_input_init(@NativeType(value="spvc_msl_shader_input *") SpvcMslShaderInput input) {
        Spvc.nspvc_msl_shader_input_init(input.address());
    }

    public static void nspvc_msl_resource_binding_init(long binding) {
        long __functionAddress = Functions.msl_resource_binding_init;
        JNI.invokePV((long)binding, (long)__functionAddress);
    }

    public static void spvc_msl_resource_binding_init(@NativeType(value="spvc_msl_resource_binding *") SpvcMslResourceBinding binding) {
        Spvc.nspvc_msl_resource_binding_init(binding.address());
    }

    @NativeType(value="unsigned int")
    public static int spvc_msl_get_aux_buffer_struct_version() {
        long __functionAddress = Functions.msl_get_aux_buffer_struct_version;
        return JNI.invokeI((long)__functionAddress);
    }

    public static void nspvc_msl_constexpr_sampler_init(long sampler) {
        long __functionAddress = Functions.msl_constexpr_sampler_init;
        JNI.invokePV((long)sampler, (long)__functionAddress);
    }

    public static void spvc_msl_constexpr_sampler_init(@NativeType(value="spvc_msl_constexpr_sampler *") SpvcMslConstexprSampler sampler) {
        Spvc.nspvc_msl_constexpr_sampler_init(sampler.address());
    }

    public static void nspvc_msl_sampler_ycbcr_conversion_init(long conv) {
        long __functionAddress = Functions.msl_sampler_ycbcr_conversion_init;
        JNI.invokePV((long)conv, (long)__functionAddress);
    }

    public static void spvc_msl_sampler_ycbcr_conversion_init(@NativeType(value="spvc_msl_sampler_ycbcr_conversion *") SpvcMslSamplerYcbcrConversion conv) {
        Spvc.nspvc_msl_sampler_ycbcr_conversion_init(conv.address());
    }

    public static void nspvc_hlsl_resource_binding_init(long binding) {
        long __functionAddress = Functions.hlsl_resource_binding_init;
        JNI.invokePV((long)binding, (long)__functionAddress);
    }

    public static void spvc_hlsl_resource_binding_init(@NativeType(value="spvc_hlsl_resource_binding *") SpvcHLSLResourceBinding binding) {
        Spvc.nspvc_hlsl_resource_binding_init(binding.address());
    }

    public static int nspvc_context_create(long context) {
        long __functionAddress = Functions.context_create;
        return JNI.invokePI((long)context, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_context_create(@NativeType(value="spvc_context *") PointerBuffer context) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)context, (int)1);
        }
        return Spvc.nspvc_context_create(MemoryUtil.memAddress((CustomBuffer)context));
    }

    public static void spvc_context_destroy(@NativeType(value="spvc_context") long context) {
        long __functionAddress = Functions.context_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        JNI.invokePV((long)context, (long)__functionAddress);
    }

    public static void spvc_context_release_allocations(@NativeType(value="spvc_context") long context) {
        long __functionAddress = Functions.context_release_allocations;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        JNI.invokePV((long)context, (long)__functionAddress);
    }

    public static long nspvc_context_get_last_error_string(long context) {
        long __functionAddress = Functions.context_get_last_error_string;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePP((long)context, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String spvc_context_get_last_error_string(@NativeType(value="spvc_context") long context) {
        long __result = Spvc.nspvc_context_get_last_error_string(context);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static void nspvc_context_set_error_callback(long context, long cb, long userdata) {
        long __functionAddress = Functions.context_set_error_callback;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        JNI.invokePPPV((long)context, (long)cb, (long)userdata, (long)__functionAddress);
    }

    public static void spvc_context_set_error_callback(@NativeType(value="spvc_context") long context, @NativeType(value="spvc_error_callback") SpvcErrorCallbackI cb, @NativeType(value="void *") long userdata) {
        Spvc.nspvc_context_set_error_callback(context, cb.address(), userdata);
    }

    public static int nspvc_context_parse_spirv(long context, long spirv, long word_count, long parsed_ir) {
        long __functionAddress = Functions.context_parse_spirv;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePPPPI((long)context, (long)spirv, (long)word_count, (long)parsed_ir, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_context_parse_spirv(@NativeType(value="spvc_context") long context, @NativeType(value="SpvId const *") IntBuffer spirv, @NativeType(value="size_t") long word_count, @NativeType(value="spvc_parsed_ir *") PointerBuffer parsed_ir) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)spirv, (int)1);
            Checks.check((CustomBuffer)parsed_ir, (int)1);
        }
        return Spvc.nspvc_context_parse_spirv(context, MemoryUtil.memAddress((IntBuffer)spirv), word_count, MemoryUtil.memAddress((CustomBuffer)parsed_ir));
    }

    public static int nspvc_context_create_compiler(long context, int backend, long parsed_ir, int mode, long compiler) {
        long __functionAddress = Functions.context_create_compiler;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.check((long)parsed_ir);
        }
        return JNI.invokePPPI((long)context, (int)backend, (long)parsed_ir, (int)mode, (long)compiler, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_context_create_compiler(@NativeType(value="spvc_context") long context, @NativeType(value="spvc_backend") int backend, @NativeType(value="spvc_parsed_ir") long parsed_ir, @NativeType(value="spvc_capture_mode") int mode, @NativeType(value="spvc_compiler *") PointerBuffer compiler) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)compiler, (int)1);
        }
        return Spvc.nspvc_context_create_compiler(context, backend, parsed_ir, mode, MemoryUtil.memAddress((CustomBuffer)compiler));
    }

    @NativeType(value="unsigned int")
    public static int spvc_compiler_get_current_id_bound(@NativeType(value="spvc_compiler") long compiler) {
        long __functionAddress = Functions.compiler_get_current_id_bound;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (long)__functionAddress);
    }

    public static int nspvc_compiler_create_compiler_options(long compiler, long options) {
        long __functionAddress = Functions.compiler_create_compiler_options;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (long)options, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_create_compiler_options(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_compiler_options *") PointerBuffer options) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)options, (int)1);
        }
        return Spvc.nspvc_compiler_create_compiler_options(compiler, MemoryUtil.memAddress((CustomBuffer)options));
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_options_set_bool(@NativeType(value="spvc_compiler_options") long options, @NativeType(value="spvc_compiler_option") int option, @NativeType(value="spvc_bool") boolean value) {
        long __functionAddress = Functions.compiler_options_set_bool;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        return JNI.invokePI((long)options, (int)option, (boolean)value, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_options_set_uint(@NativeType(value="spvc_compiler_options") long options, @NativeType(value="spvc_compiler_option") int option, @NativeType(value="unsigned int") int value) {
        long __functionAddress = Functions.compiler_options_set_uint;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        return JNI.invokePI((long)options, (int)option, (int)value, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_install_compiler_options(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_compiler_options") long options) {
        long __functionAddress = Functions.compiler_install_compiler_options;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
            Checks.check((long)options);
        }
        return JNI.invokePPI((long)compiler, (long)options, (long)__functionAddress);
    }

    public static int nspvc_compiler_compile(long compiler, long source) {
        long __functionAddress = Functions.compiler_compile;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (long)source, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_compile(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const **") PointerBuffer source) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)source, (int)1);
        }
        return Spvc.nspvc_compiler_compile(compiler, MemoryUtil.memAddress((CustomBuffer)source));
    }

    public static int nspvc_compiler_add_header_line(long compiler, long line) {
        long __functionAddress = Functions.compiler_add_header_line;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (long)line, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_add_header_line(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const *") ByteBuffer line) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)line);
        }
        return Spvc.nspvc_compiler_add_header_line(compiler, MemoryUtil.memAddress((ByteBuffer)line));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="spvc_result")
    public static int spvc_compiler_add_header_line(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const *") CharSequence line) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(line, true);
            long lineEncoded = stack.getPointerAddress();
            int n = Spvc.nspvc_compiler_add_header_line(compiler, lineEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nspvc_compiler_require_extension(long compiler, long ext) {
        long __functionAddress = Functions.compiler_require_extension;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (long)ext, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_require_extension(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const *") ByteBuffer ext) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)ext);
        }
        return Spvc.nspvc_compiler_require_extension(compiler, MemoryUtil.memAddress((ByteBuffer)ext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="spvc_result")
    public static int spvc_compiler_require_extension(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const *") CharSequence ext) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(ext, true);
            long extEncoded = stack.getPointerAddress();
            int n = Spvc.nspvc_compiler_require_extension(compiler, extEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_flatten_buffer_block(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_variable_id") int id) {
        long __functionAddress = Functions.compiler_flatten_buffer_block;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)id, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_variable_is_depth_or_compare(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_variable_id") int id) {
        long __functionAddress = Functions.compiler_variable_is_depth_or_compare;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (int)id, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_mask_stage_output_by_location(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="unsigned") int location, @NativeType(value="unsigned") int component) {
        long __functionAddress = Functions.compiler_mask_stage_output_by_location;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)location, (int)component, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_mask_stage_output_by_builtin(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvBuiltIn") int builtin) {
        long __functionAddress = Functions.compiler_mask_stage_output_by_builtin;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)builtin, (long)__functionAddress);
    }

    public static int nspvc_compiler_hlsl_set_root_constants_layout(long compiler, long constant_info, long count) {
        long __functionAddress = Functions.compiler_hlsl_set_root_constants_layout;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPI((long)compiler, (long)constant_info, (long)count, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_hlsl_set_root_constants_layout(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_hlsl_root_constants const *") SpvcHlslRootConstants constant_info, @NativeType(value="size_t") long count) {
        return Spvc.nspvc_compiler_hlsl_set_root_constants_layout(compiler, constant_info.address(), count);
    }

    public static int nspvc_compiler_hlsl_add_vertex_attribute_remap(long compiler, long remap, long remaps) {
        long __functionAddress = Functions.compiler_hlsl_add_vertex_attribute_remap;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
            SpvcHlslVertexAttributeRemap.validate(remap);
        }
        return JNI.invokePPPI((long)compiler, (long)remap, (long)remaps, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_hlsl_add_vertex_attribute_remap(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_hlsl_vertex_attribute_remap const *") SpvcHlslVertexAttributeRemap remap, @NativeType(value="size_t") long remaps) {
        return Spvc.nspvc_compiler_hlsl_add_vertex_attribute_remap(compiler, remap.address(), remaps);
    }

    @NativeType(value="spvc_variable_id")
    public static int spvc_compiler_hlsl_remap_num_workgroups_builtin(@NativeType(value="spvc_compiler") long compiler) {
        long __functionAddress = Functions.compiler_hlsl_remap_num_workgroups_builtin;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_hlsl_set_resource_binding_flags(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_hlsl_binding_flags") int flags) {
        long __functionAddress = Functions.compiler_hlsl_set_resource_binding_flags;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)flags, (long)__functionAddress);
    }

    public static int nspvc_compiler_hlsl_add_resource_binding(long compiler, long binding) {
        long __functionAddress = Functions.compiler_hlsl_add_resource_binding;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (long)binding, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_hlsl_add_resource_binding(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_hlsl_resource_binding const *") SpvcHLSLResourceBinding binding) {
        return Spvc.nspvc_compiler_hlsl_add_resource_binding(compiler, binding.address());
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_hlsl_is_resource_used(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvExecutionModel") int model, @NativeType(value="unsigned") int set, @NativeType(value="unsigned") int binding) {
        long __functionAddress = Functions.compiler_hlsl_is_resource_used;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (int)model, (int)set, (int)binding, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_msl_is_rasterization_disabled(@NativeType(value="spvc_compiler") long compiler) {
        long __functionAddress = Functions.compiler_msl_is_rasterization_disabled;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_msl_needs_swizzle_buffer(@NativeType(value="spvc_compiler") long compiler) {
        long __functionAddress = Functions.compiler_msl_needs_swizzle_buffer;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_msl_needs_buffer_size_buffer(@NativeType(value="spvc_compiler") long compiler) {
        long __functionAddress = Functions.compiler_msl_needs_buffer_size_buffer;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_msl_needs_output_buffer(@NativeType(value="spvc_compiler") long compiler) {
        long __functionAddress = Functions.compiler_msl_needs_output_buffer;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_msl_needs_patch_output_buffer(@NativeType(value="spvc_compiler") long compiler) {
        long __functionAddress = Functions.compiler_msl_needs_patch_output_buffer;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_msl_needs_input_threadgroup_mem(@NativeType(value="spvc_compiler") long compiler) {
        long __functionAddress = Functions.compiler_msl_needs_input_threadgroup_mem;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (long)__functionAddress);
    }

    public static int nspvc_compiler_msl_add_vertex_attribute(long compiler, long attrs) {
        long __functionAddress = Functions.compiler_msl_add_vertex_attribute;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (long)attrs, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_add_vertex_attribute(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_msl_vertex_attribute const *") SpvcMslVertexAttribute attrs) {
        return Spvc.nspvc_compiler_msl_add_vertex_attribute(compiler, attrs.address());
    }

    public static int nspvc_compiler_msl_add_resource_binding(long compiler, long binding) {
        long __functionAddress = Functions.compiler_msl_add_resource_binding;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (long)binding, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_add_resource_binding(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_msl_resource_binding const *") SpvcMslResourceBinding binding) {
        return Spvc.nspvc_compiler_msl_add_resource_binding(compiler, binding.address());
    }

    public static int nspvc_compiler_msl_add_shader_input(long compiler, long input) {
        long __functionAddress = Functions.compiler_msl_add_shader_input;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (long)input, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_add_shader_input(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_msl_shader_input const *") SpvcMslShaderInput input) {
        return Spvc.nspvc_compiler_msl_add_shader_input(compiler, input.address());
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_add_discrete_descriptor_set(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="unsigned int") int desc_set) {
        long __functionAddress = Functions.compiler_msl_add_discrete_descriptor_set;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)desc_set, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_set_argument_buffer_device_address_space(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="unsigned") int desc_set, @NativeType(value="spvc_bool") boolean device_address) {
        long __functionAddress = Functions.compiler_msl_set_argument_buffer_device_address_space;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)desc_set, (boolean)device_address, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_msl_is_vertex_attribute_used(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="unsigned int") int location) {
        long __functionAddress = Functions.compiler_msl_is_vertex_attribute_used;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (int)location, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_msl_is_shader_input_used(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="unsigned") int location) {
        long __functionAddress = Functions.compiler_msl_is_shader_input_used;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (int)location, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_msl_is_resource_used(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvExecutionModel") int model, @NativeType(value="unsigned int") int set, @NativeType(value="unsigned int") int binding) {
        long __functionAddress = Functions.compiler_msl_is_resource_used;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (int)model, (int)set, (int)binding, (long)__functionAddress);
    }

    public static int nspvc_compiler_msl_remap_constexpr_sampler(long compiler, int id, long sampler) {
        long __functionAddress = Functions.compiler_msl_remap_constexpr_sampler;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (int)id, (long)sampler, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_remap_constexpr_sampler(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_variable_id") int id, @NativeType(value="spvc_msl_constexpr_sampler const *") SpvcMslConstexprSampler sampler) {
        return Spvc.nspvc_compiler_msl_remap_constexpr_sampler(compiler, id, sampler.address());
    }

    public static int nspvc_compiler_msl_remap_constexpr_sampler_by_binding(long compiler, int desc_set, int binding, long sampler) {
        long __functionAddress = Functions.compiler_msl_remap_constexpr_sampler_by_binding;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (int)desc_set, (int)binding, (long)sampler, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_remap_constexpr_sampler_by_binding(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="unsigned int") int desc_set, @NativeType(value="unsigned int") int binding, @NativeType(value="spvc_msl_constexpr_sampler const *") SpvcMslConstexprSampler sampler) {
        return Spvc.nspvc_compiler_msl_remap_constexpr_sampler_by_binding(compiler, desc_set, binding, sampler.address());
    }

    public static int nspvc_compiler_msl_remap_constexpr_sampler_ycbcr(long compiler, int id, long sampler, long conv) {
        long __functionAddress = Functions.compiler_msl_remap_constexpr_sampler_ycbcr;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPI((long)compiler, (int)id, (long)sampler, (long)conv, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_remap_constexpr_sampler_ycbcr(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_variable_id") int id, @NativeType(value="spvc_msl_constexpr_sampler const *") SpvcMslConstexprSampler sampler, @NativeType(value="spvc_msl_sampler_ycbcr_conversion const *") SpvcMslSamplerYcbcrConversion conv) {
        return Spvc.nspvc_compiler_msl_remap_constexpr_sampler_ycbcr(compiler, id, sampler.address(), conv.address());
    }

    public static int nspvc_compiler_msl_remap_constexpr_sampler_by_binding_ycbcr(long compiler, int desc_set, int binding, long sampler, long conv) {
        long __functionAddress = Functions.compiler_msl_remap_constexpr_sampler_by_binding_ycbcr;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPI((long)compiler, (int)desc_set, (int)binding, (long)sampler, (long)conv, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_remap_constexpr_sampler_by_binding_ycbcr(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="unsigned int") int desc_set, @NativeType(value="unsigned int") int binding, @NativeType(value="spvc_msl_constexpr_sampler const *") SpvcMslConstexprSampler sampler, @NativeType(value="spvc_msl_sampler_ycbcr_conversion const *") SpvcMslSamplerYcbcrConversion conv) {
        return Spvc.nspvc_compiler_msl_remap_constexpr_sampler_by_binding_ycbcr(compiler, desc_set, binding, sampler.address(), conv.address());
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_set_fragment_output_components(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="unsigned int") int location, @NativeType(value="unsigned int") int components) {
        long __functionAddress = Functions.compiler_msl_set_fragment_output_components;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)location, (int)components, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int spvc_compiler_msl_get_automatic_resource_binding(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_variable_id") int id) {
        long __functionAddress = Functions.compiler_msl_get_automatic_resource_binding;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)id, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int spvc_compiler_msl_get_automatic_resource_binding_secondary(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_variable_id") int id) {
        long __functionAddress = Functions.compiler_msl_get_automatic_resource_binding_secondary;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)id, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_add_dynamic_buffer(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="unsigned int") int desc_set, @NativeType(value="unsigned int") int binding, @NativeType(value="unsigned int") int index) {
        long __functionAddress = Functions.compiler_msl_add_dynamic_buffer;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)desc_set, (int)binding, (int)index, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_add_inline_uniform_block(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="unsigned int") int desc_set, @NativeType(value="unsigned int") int binding) {
        long __functionAddress = Functions.compiler_msl_add_inline_uniform_block;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)desc_set, (int)binding, (long)__functionAddress);
    }

    public static int nspvc_compiler_msl_set_combined_sampler_suffix(long compiler, long suffix) {
        long __functionAddress = Functions.compiler_msl_set_combined_sampler_suffix;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (long)suffix, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_set_combined_sampler_suffix(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const *") ByteBuffer suffix) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)suffix);
        }
        return Spvc.nspvc_compiler_msl_set_combined_sampler_suffix(compiler, MemoryUtil.memAddress((ByteBuffer)suffix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="spvc_result")
    public static int spvc_compiler_msl_set_combined_sampler_suffix(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const *") CharSequence suffix) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(suffix, true);
            long suffixEncoded = stack.getPointerAddress();
            int n = Spvc.nspvc_compiler_msl_set_combined_sampler_suffix(compiler, suffixEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nspvc_compiler_msl_get_combined_sampler_suffix(long compiler) {
        long __functionAddress = Functions.compiler_msl_get_combined_sampler_suffix;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePP((long)compiler, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String spvc_compiler_msl_get_combined_sampler_suffix(@NativeType(value="spvc_compiler") long compiler) {
        long __result = Spvc.nspvc_compiler_msl_get_combined_sampler_suffix(compiler);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static int nspvc_compiler_get_active_interface_variables(long compiler, long set) {
        long __functionAddress = Functions.compiler_get_active_interface_variables;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (long)set, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_get_active_interface_variables(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_set *") PointerBuffer set) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)set, (int)1);
        }
        return Spvc.nspvc_compiler_get_active_interface_variables(compiler, MemoryUtil.memAddress((CustomBuffer)set));
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_set_enabled_interface_variables(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_set") long set) {
        long __functionAddress = Functions.compiler_set_enabled_interface_variables;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
            Checks.check((long)set);
        }
        return JNI.invokePPI((long)compiler, (long)set, (long)__functionAddress);
    }

    public static int nspvc_compiler_create_shader_resources(long compiler, long resources) {
        long __functionAddress = Functions.compiler_create_shader_resources;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (long)resources, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_create_shader_resources(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_resources *") PointerBuffer resources) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)resources, (int)1);
        }
        return Spvc.nspvc_compiler_create_shader_resources(compiler, MemoryUtil.memAddress((CustomBuffer)resources));
    }

    public static int nspvc_compiler_create_shader_resources_for_active_variables(long compiler, long resources, long active) {
        long __functionAddress = Functions.compiler_create_shader_resources_for_active_variables;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
            Checks.check((long)active);
        }
        return JNI.invokePPPI((long)compiler, (long)resources, (long)active, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_create_shader_resources_for_active_variables(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_resources *") PointerBuffer resources, @NativeType(value="spvc_set") long active) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)resources, (int)1);
        }
        return Spvc.nspvc_compiler_create_shader_resources_for_active_variables(compiler, MemoryUtil.memAddress((CustomBuffer)resources), active);
    }

    public static int nspvc_resources_get_resource_list_for_type(long resources, int type, long resource_list, long resource_size) {
        long __functionAddress = Functions.resources_get_resource_list_for_type;
        if (Checks.CHECKS) {
            Checks.check((long)resources);
        }
        return JNI.invokePPPI((long)resources, (int)type, (long)resource_list, (long)resource_size, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_resources_get_resource_list_for_type(@NativeType(value="spvc_resources") long resources, @NativeType(value="spvc_resource_type") int type, @NativeType(value="spvc_reflected_resource const **") PointerBuffer resource_list, @NativeType(value="size_t *") PointerBuffer resource_size) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)resource_list, (int)1);
            Checks.check((CustomBuffer)resource_size, (int)1);
        }
        return Spvc.nspvc_resources_get_resource_list_for_type(resources, type, MemoryUtil.memAddress((CustomBuffer)resource_list), MemoryUtil.memAddress((CustomBuffer)resource_size));
    }

    public static int nspvc_resources_get_builtin_resource_list_for_type(long resources, int type, long resource_list, long resource_size) {
        long __functionAddress = Functions.resources_get_builtin_resource_list_for_type;
        if (Checks.CHECKS) {
            Checks.check((long)resources);
        }
        return JNI.invokePPPI((long)resources, (int)type, (long)resource_list, (long)resource_size, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_resources_get_builtin_resource_list_for_type(@NativeType(value="spvc_resources") long resources, @NativeType(value="spvc_builtin_resource_type") int type, @NativeType(value="spvc_reflected_builtin_resource const **") PointerBuffer resource_list, @NativeType(value="size_t *") PointerBuffer resource_size) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)resource_list, (int)1);
            Checks.check((CustomBuffer)resource_size, (int)1);
        }
        return Spvc.nspvc_resources_get_builtin_resource_list_for_type(resources, type, MemoryUtil.memAddress((CustomBuffer)resource_list), MemoryUtil.memAddress((CustomBuffer)resource_size));
    }

    public static void spvc_compiler_set_decoration(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvId") int id, @NativeType(value="SpvDecoration") int decoration, @NativeType(value="unsigned int") int argument) {
        long __functionAddress = Functions.compiler_set_decoration;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        JNI.invokePV((long)compiler, (int)id, (int)decoration, (int)argument, (long)__functionAddress);
    }

    public static void nspvc_compiler_set_decoration_string(long compiler, int id, int decoration, long argument) {
        long __functionAddress = Functions.compiler_set_decoration_string;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        JNI.invokePPV((long)compiler, (int)id, (int)decoration, (long)argument, (long)__functionAddress);
    }

    public static void spvc_compiler_set_decoration_string(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvId") int id, @NativeType(value="SpvDecoration") int decoration, @NativeType(value="char const *") ByteBuffer argument) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)argument);
        }
        Spvc.nspvc_compiler_set_decoration_string(compiler, id, decoration, MemoryUtil.memAddress((ByteBuffer)argument));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spvc_compiler_set_decoration_string(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvId") int id, @NativeType(value="SpvDecoration") int decoration, @NativeType(value="char const *") CharSequence argument) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(argument, true);
            long argumentEncoded = stack.getPointerAddress();
            Spvc.nspvc_compiler_set_decoration_string(compiler, id, decoration, argumentEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nspvc_compiler_set_name(long compiler, int id, long argument) {
        long __functionAddress = Functions.compiler_set_name;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        JNI.invokePPV((long)compiler, (int)id, (long)argument, (long)__functionAddress);
    }

    public static void spvc_compiler_set_name(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvId") int id, @NativeType(value="char const *") ByteBuffer argument) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)argument);
        }
        Spvc.nspvc_compiler_set_name(compiler, id, MemoryUtil.memAddress((ByteBuffer)argument));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spvc_compiler_set_name(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvId") int id, @NativeType(value="char const *") CharSequence argument) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(argument, true);
            long argumentEncoded = stack.getPointerAddress();
            Spvc.nspvc_compiler_set_name(compiler, id, argumentEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void spvc_compiler_set_member_decoration(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type_id") int id, @NativeType(value="unsigned int") int member_index, @NativeType(value="SpvDecoration") int decoration, @NativeType(value="unsigned int") int argument) {
        long __functionAddress = Functions.compiler_set_member_decoration;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        JNI.invokePV((long)compiler, (int)id, (int)member_index, (int)decoration, (int)argument, (long)__functionAddress);
    }

    public static void nspvc_compiler_set_member_decoration_string(long compiler, int id, int member_index, int decoration, long argument) {
        long __functionAddress = Functions.compiler_set_member_decoration_string;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        JNI.invokePPV((long)compiler, (int)id, (int)member_index, (int)decoration, (long)argument, (long)__functionAddress);
    }

    public static void spvc_compiler_set_member_decoration_string(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type_id") int id, @NativeType(value="unsigned int") int member_index, @NativeType(value="SpvDecoration") int decoration, @NativeType(value="char const *") ByteBuffer argument) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)argument);
        }
        Spvc.nspvc_compiler_set_member_decoration_string(compiler, id, member_index, decoration, MemoryUtil.memAddress((ByteBuffer)argument));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spvc_compiler_set_member_decoration_string(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type_id") int id, @NativeType(value="unsigned int") int member_index, @NativeType(value="SpvDecoration") int decoration, @NativeType(value="char const *") CharSequence argument) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(argument, true);
            long argumentEncoded = stack.getPointerAddress();
            Spvc.nspvc_compiler_set_member_decoration_string(compiler, id, member_index, decoration, argumentEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nspvc_compiler_set_member_name(long compiler, int id, int member_index, long argument) {
        long __functionAddress = Functions.compiler_set_member_name;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        JNI.invokePPV((long)compiler, (int)id, (int)member_index, (long)argument, (long)__functionAddress);
    }

    public static void spvc_compiler_set_member_name(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type_id") int id, @NativeType(value="unsigned int") int member_index, @NativeType(value="char const *") ByteBuffer argument) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)argument);
        }
        Spvc.nspvc_compiler_set_member_name(compiler, id, member_index, MemoryUtil.memAddress((ByteBuffer)argument));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spvc_compiler_set_member_name(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type_id") int id, @NativeType(value="unsigned int") int member_index, @NativeType(value="char const *") CharSequence argument) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(argument, true);
            long argumentEncoded = stack.getPointerAddress();
            Spvc.nspvc_compiler_set_member_name(compiler, id, member_index, argumentEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void spvc_compiler_unset_decoration(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvId") int id, @NativeType(value="SpvDecoration") int decoration) {
        long __functionAddress = Functions.compiler_unset_decoration;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        JNI.invokePV((long)compiler, (int)id, (int)decoration, (long)__functionAddress);
    }

    public static void spvc_compiler_unset_member_decoration(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type_id") int id, @NativeType(value="unsigned int") int member_index, @NativeType(value="SpvDecoration") int decoration) {
        long __functionAddress = Functions.compiler_unset_member_decoration;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        JNI.invokePV((long)compiler, (int)id, (int)member_index, (int)decoration, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_has_decoration(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvId") int id, @NativeType(value="SpvDecoration") int decoration) {
        long __functionAddress = Functions.compiler_has_decoration;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (int)id, (int)decoration, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_has_member_decoration(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type_id") int id, @NativeType(value="unsigned int") int member_index, @NativeType(value="SpvDecoration") int decoration) {
        long __functionAddress = Functions.compiler_has_member_decoration;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (int)id, (int)member_index, (int)decoration, (long)__functionAddress);
    }

    public static long nspvc_compiler_get_name(long compiler, int id) {
        long __functionAddress = Functions.compiler_get_name;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePP((long)compiler, (int)id, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String spvc_compiler_get_name(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvId") int id) {
        long __result = Spvc.nspvc_compiler_get_name(compiler, id);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="unsigned int")
    public static int spvc_compiler_get_decoration(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvId") int id, @NativeType(value="SpvDecoration") int decoration) {
        long __functionAddress = Functions.compiler_get_decoration;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)id, (int)decoration, (long)__functionAddress);
    }

    public static long nspvc_compiler_get_decoration_string(long compiler, int id, int decoration) {
        long __functionAddress = Functions.compiler_get_decoration_string;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePP((long)compiler, (int)id, (int)decoration, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String spvc_compiler_get_decoration_string(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvId") int id, @NativeType(value="SpvDecoration") int decoration) {
        long __result = Spvc.nspvc_compiler_get_decoration_string(compiler, id, decoration);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="unsigned int")
    public static int spvc_compiler_get_member_decoration(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type_id") int id, @NativeType(value="unsigned int") int member_index, @NativeType(value="SpvDecoration") int decoration) {
        long __functionAddress = Functions.compiler_get_member_decoration;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)id, (int)member_index, (int)decoration, (long)__functionAddress);
    }

    public static long nspvc_compiler_get_member_decoration_string(long compiler, int id, int member_index, int decoration) {
        long __functionAddress = Functions.compiler_get_member_decoration_string;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePP((long)compiler, (int)id, (int)member_index, (int)decoration, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String spvc_compiler_get_member_decoration_string(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type_id") int id, @NativeType(value="unsigned int") int member_index, @NativeType(value="SpvDecoration") int decoration) {
        long __result = Spvc.nspvc_compiler_get_member_decoration_string(compiler, id, member_index, decoration);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nspvc_compiler_get_member_name(long compiler, int id, int member_index) {
        long __functionAddress = Functions.compiler_get_member_name;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePP((long)compiler, (int)id, (int)member_index, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String spvc_compiler_get_member_name(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type_id") int id, @NativeType(value="unsigned int") int member_index) {
        long __result = Spvc.nspvc_compiler_get_member_name(compiler, id, member_index);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static int nspvc_compiler_get_entry_points(long compiler, long entry_points, long num_entry_points) {
        long __functionAddress = Functions.compiler_get_entry_points;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPI((long)compiler, (long)entry_points, (long)num_entry_points, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_get_entry_points(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_entry_point const **") PointerBuffer entry_points, @NativeType(value="size_t *") PointerBuffer num_entry_points) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)entry_points, (int)1);
            Checks.check((CustomBuffer)num_entry_points, (int)1);
        }
        return Spvc.nspvc_compiler_get_entry_points(compiler, MemoryUtil.memAddress((CustomBuffer)entry_points), MemoryUtil.memAddress((CustomBuffer)num_entry_points));
    }

    public static int nspvc_compiler_set_entry_point(long compiler, long name, int model) {
        long __functionAddress = Functions.compiler_set_entry_point;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (long)name, (int)model, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_set_entry_point(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="SpvExecutionModel") int model) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return Spvc.nspvc_compiler_set_entry_point(compiler, MemoryUtil.memAddress((ByteBuffer)name), model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="spvc_result")
    public static int spvc_compiler_set_entry_point(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const *") CharSequence name, @NativeType(value="SpvExecutionModel") int model) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = Spvc.nspvc_compiler_set_entry_point(compiler, nameEncoded, model);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nspvc_compiler_rename_entry_point(long compiler, long old_name, long new_name, int model) {
        long __functionAddress = Functions.compiler_rename_entry_point;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPI((long)compiler, (long)old_name, (long)new_name, (int)model, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_rename_entry_point(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const *") ByteBuffer old_name, @NativeType(value="char const *") ByteBuffer new_name, @NativeType(value="SpvExecutionModel") int model) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)old_name);
            Checks.checkNT1((ByteBuffer)new_name);
        }
        return Spvc.nspvc_compiler_rename_entry_point(compiler, MemoryUtil.memAddress((ByteBuffer)old_name), MemoryUtil.memAddress((ByteBuffer)new_name), model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="spvc_result")
    public static int spvc_compiler_rename_entry_point(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const *") CharSequence old_name, @NativeType(value="char const *") CharSequence new_name, @NativeType(value="SpvExecutionModel") int model) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(old_name, true);
            long old_nameEncoded = stack.getPointerAddress();
            stack.nUTF8(new_name, true);
            long new_nameEncoded = stack.getPointerAddress();
            int n = Spvc.nspvc_compiler_rename_entry_point(compiler, old_nameEncoded, new_nameEncoded, model);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nspvc_compiler_get_cleansed_entry_point_name(long compiler, long name, int model) {
        long __functionAddress = Functions.compiler_get_cleansed_entry_point_name;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPP((long)compiler, (long)name, (int)model, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String spvc_compiler_get_cleansed_entry_point_name(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="SpvExecutionModel") int model) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        long __result = Spvc.nspvc_compiler_get_cleansed_entry_point_name(compiler, MemoryUtil.memAddress((ByteBuffer)name), model);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String spvc_compiler_get_cleansed_entry_point_name(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const *") CharSequence name, @NativeType(value="SpvExecutionModel") int model) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            long __result = Spvc.nspvc_compiler_get_cleansed_entry_point_name(compiler, nameEncoded, model);
            String string = MemoryUtil.memUTF8Safe((long)__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void spvc_compiler_set_execution_mode(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvExecutionMode") int mode) {
        long __functionAddress = Functions.compiler_set_execution_mode;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        JNI.invokePV((long)compiler, (int)mode, (long)__functionAddress);
    }

    public static void spvc_compiler_unset_execution_mode(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvExecutionMode") int mode) {
        long __functionAddress = Functions.compiler_unset_execution_mode;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        JNI.invokePV((long)compiler, (int)mode, (long)__functionAddress);
    }

    public static void spvc_compiler_set_execution_mode_with_arguments(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvExecutionMode") int mode, @NativeType(value="unsigned int") int arg0, @NativeType(value="unsigned int") int arg1, @NativeType(value="unsigned int") int arg2) {
        long __functionAddress = Functions.compiler_set_execution_mode_with_arguments;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        JNI.invokePV((long)compiler, (int)mode, (int)arg0, (int)arg1, (int)arg2, (long)__functionAddress);
    }

    public static int nspvc_compiler_get_execution_modes(long compiler, long modes, long num_modes) {
        long __functionAddress = Functions.compiler_get_execution_modes;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPI((long)compiler, (long)modes, (long)num_modes, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_get_execution_modes(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvExecutionMode const **") PointerBuffer modes, @NativeType(value="size_t *") PointerBuffer num_modes) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)modes, (int)1);
            Checks.check((CustomBuffer)num_modes, (int)1);
        }
        return Spvc.nspvc_compiler_get_execution_modes(compiler, MemoryUtil.memAddress((CustomBuffer)modes), MemoryUtil.memAddress((CustomBuffer)num_modes));
    }

    @NativeType(value="unsigned int")
    public static int spvc_compiler_get_execution_mode_argument(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvExecutionMode") int mode) {
        long __functionAddress = Functions.compiler_get_execution_mode_argument;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)mode, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int spvc_compiler_get_execution_mode_argument_by_index(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvExecutionMode") int mode, @NativeType(value="unsigned int") int index) {
        long __functionAddress = Functions.compiler_get_execution_mode_argument_by_index;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (int)mode, (int)index, (long)__functionAddress);
    }

    @NativeType(value="SpvExecutionModel")
    public static int spvc_compiler_get_execution_model(@NativeType(value="spvc_compiler") long compiler) {
        long __functionAddress = Functions.compiler_get_execution_model;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (long)__functionAddress);
    }

    public static void spvc_compiler_update_active_builtins(@NativeType(value="spvc_compiler") long compiler) {
        long __functionAddress = Functions.compiler_update_active_builtins;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        JNI.invokePV((long)compiler, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_has_active_builtin(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvBuiltIn") int builtin, @NativeType(value="SpvStorageClass") int storage) {
        long __functionAddress = Functions.compiler_has_active_builtin;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (int)builtin, (int)storage, (long)__functionAddress);
    }

    @NativeType(value="spvc_type")
    public static long spvc_compiler_get_type_handle(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type_id") int id) {
        long __functionAddress = Functions.compiler_get_type_handle;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePP((long)compiler, (int)id, (long)__functionAddress);
    }

    @NativeType(value="spvc_type_id")
    public static int spvc_type_get_base_type_id(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_base_type_id;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (long)__functionAddress);
    }

    @NativeType(value="spvc_basetype")
    public static int spvc_type_get_basetype(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_basetype;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int spvc_type_get_bit_width(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_bit_width;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int spvc_type_get_vector_size(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_vector_size;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int spvc_type_get_columns(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_columns;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int spvc_type_get_num_array_dimensions(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_num_array_dimensions;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_type_array_dimension_is_literal(@NativeType(value="spvc_type") long type, @NativeType(value="unsigned int") int dimension) {
        long __functionAddress = Functions.type_array_dimension_is_literal;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePZ((long)type, (int)dimension, (long)__functionAddress);
    }

    @NativeType(value="SpvId")
    public static int spvc_type_get_array_dimension(@NativeType(value="spvc_type") long type, @NativeType(value="unsigned int") int dimension) {
        long __functionAddress = Functions.type_get_array_dimension;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (int)dimension, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int spvc_type_get_num_member_types(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_num_member_types;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (long)__functionAddress);
    }

    @NativeType(value="spvc_type_id")
    public static int spvc_type_get_member_type(@NativeType(value="spvc_type") long type, @NativeType(value="unsigned int") int index) {
        long __functionAddress = Functions.type_get_member_type;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (int)index, (long)__functionAddress);
    }

    @NativeType(value="SpvStorageClass")
    public static int spvc_type_get_storage_class(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_storage_class;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (long)__functionAddress);
    }

    @NativeType(value="spvc_type_id")
    public static int spvc_type_get_image_sampled_type(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_image_sampled_type;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (long)__functionAddress);
    }

    @NativeType(value="SpvDim")
    public static int spvc_type_get_image_dimension(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_image_dimension;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_type_get_image_is_depth(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_image_is_depth;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePZ((long)type, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_type_get_image_arrayed(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_image_arrayed;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePZ((long)type, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_type_get_image_multisampled(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_image_multisampled;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePZ((long)type, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_type_get_image_is_storage(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_image_is_storage;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePZ((long)type, (long)__functionAddress);
    }

    @NativeType(value="SpvImageFormat")
    public static int spvc_type_get_image_storage_format(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_image_storage_format;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (long)__functionAddress);
    }

    @NativeType(value="SpvAccessQualifier")
    public static int spvc_type_get_image_access_qualifier(@NativeType(value="spvc_type") long type) {
        long __functionAddress = Functions.type_get_image_access_qualifier;
        if (Checks.CHECKS) {
            Checks.check((long)type);
        }
        return JNI.invokePI((long)type, (long)__functionAddress);
    }

    public static int nspvc_compiler_get_declared_struct_size(long compiler, long struct_type, long size) {
        long __functionAddress = Functions.compiler_get_declared_struct_size;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
            Checks.check((long)struct_type);
        }
        return JNI.invokePPPI((long)compiler, (long)struct_type, (long)size, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_get_declared_struct_size(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type") long struct_type, @NativeType(value="size_t *") PointerBuffer size) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)size, (int)1);
        }
        return Spvc.nspvc_compiler_get_declared_struct_size(compiler, struct_type, MemoryUtil.memAddress((CustomBuffer)size));
    }

    public static int nspvc_compiler_get_declared_struct_size_runtime_array(long compiler, long struct_type, long array_size, long size) {
        long __functionAddress = Functions.compiler_get_declared_struct_size_runtime_array;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
            Checks.check((long)struct_type);
        }
        return JNI.invokePPPPI((long)compiler, (long)struct_type, (long)array_size, (long)size, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_get_declared_struct_size_runtime_array(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type") long struct_type, @NativeType(value="size_t") long array_size, @NativeType(value="size_t *") PointerBuffer size) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)size, (int)1);
        }
        return Spvc.nspvc_compiler_get_declared_struct_size_runtime_array(compiler, struct_type, array_size, MemoryUtil.memAddress((CustomBuffer)size));
    }

    public static int nspvc_compiler_get_declared_struct_member_size(long compiler, long type, int index, long size) {
        long __functionAddress = Functions.compiler_get_declared_struct_member_size;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
            Checks.check((long)type);
        }
        return JNI.invokePPPI((long)compiler, (long)type, (int)index, (long)size, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_get_declared_struct_member_size(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type") long type, @NativeType(value="unsigned int") int index, @NativeType(value="size_t *") PointerBuffer size) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)size, (int)1);
        }
        return Spvc.nspvc_compiler_get_declared_struct_member_size(compiler, type, index, MemoryUtil.memAddress((CustomBuffer)size));
    }

    public static int nspvc_compiler_type_struct_member_offset(long compiler, long type, int index, long offset) {
        long __functionAddress = Functions.compiler_type_struct_member_offset;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
            Checks.check((long)type);
        }
        return JNI.invokePPPI((long)compiler, (long)type, (int)index, (long)offset, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_type_struct_member_offset(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type") long type, @NativeType(value="unsigned int") int index, @NativeType(value="unsigned int *") IntBuffer offset) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)offset, (int)1);
        }
        return Spvc.nspvc_compiler_type_struct_member_offset(compiler, type, index, MemoryUtil.memAddress((IntBuffer)offset));
    }

    public static int nspvc_compiler_type_struct_member_array_stride(long compiler, long type, int index, long stride) {
        long __functionAddress = Functions.compiler_type_struct_member_array_stride;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
            Checks.check((long)type);
        }
        return JNI.invokePPPI((long)compiler, (long)type, (int)index, (long)stride, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_type_struct_member_array_stride(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type") long type, @NativeType(value="unsigned int") int index, @NativeType(value="unsigned int *") IntBuffer stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)stride, (int)1);
        }
        return Spvc.nspvc_compiler_type_struct_member_array_stride(compiler, type, index, MemoryUtil.memAddress((IntBuffer)stride));
    }

    public static int nspvc_compiler_type_struct_member_matrix_stride(long compiler, long type, int index, long stride) {
        long __functionAddress = Functions.compiler_type_struct_member_matrix_stride;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
            Checks.check((long)type);
        }
        return JNI.invokePPPI((long)compiler, (long)type, (int)index, (long)stride, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_type_struct_member_matrix_stride(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_type") long type, @NativeType(value="unsigned int") int index, @NativeType(value="unsigned int *") IntBuffer stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)stride, (int)1);
        }
        return Spvc.nspvc_compiler_type_struct_member_matrix_stride(compiler, type, index, MemoryUtil.memAddress((IntBuffer)stride));
    }

    public static int nspvc_compiler_build_dummy_sampler_for_combined_images(long compiler, long id) {
        long __functionAddress = Functions.compiler_build_dummy_sampler_for_combined_images;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPI((long)compiler, (long)id, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_build_dummy_sampler_for_combined_images(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_variable_id *") IntBuffer id) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)id, (int)1);
        }
        return Spvc.nspvc_compiler_build_dummy_sampler_for_combined_images(compiler, MemoryUtil.memAddress((IntBuffer)id));
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_build_combined_image_samplers(@NativeType(value="spvc_compiler") long compiler) {
        long __functionAddress = Functions.compiler_build_combined_image_samplers;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePI((long)compiler, (long)__functionAddress);
    }

    public static int nspvc_compiler_get_combined_image_samplers(long compiler, long samplers, long num_samplers) {
        long __functionAddress = Functions.compiler_get_combined_image_samplers;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPI((long)compiler, (long)samplers, (long)num_samplers, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_get_combined_image_samplers(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_combined_image_sampler const **") PointerBuffer samplers, @NativeType(value="size_t *") PointerBuffer num_samplers) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)samplers, (int)1);
            Checks.check((CustomBuffer)num_samplers, (int)1);
        }
        return Spvc.nspvc_compiler_get_combined_image_samplers(compiler, MemoryUtil.memAddress((CustomBuffer)samplers), MemoryUtil.memAddress((CustomBuffer)num_samplers));
    }

    public static int nspvc_compiler_get_specialization_constants(long compiler, long constants, long num_constants) {
        long __functionAddress = Functions.compiler_get_specialization_constants;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPI((long)compiler, (long)constants, (long)num_constants, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_get_specialization_constants(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_specialization_constant const **") PointerBuffer constants, @NativeType(value="size_t *") PointerBuffer num_constants) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)constants, (int)1);
            Checks.check((CustomBuffer)num_constants, (int)1);
        }
        return Spvc.nspvc_compiler_get_specialization_constants(compiler, MemoryUtil.memAddress((CustomBuffer)constants), MemoryUtil.memAddress((CustomBuffer)num_constants));
    }

    @NativeType(value="spvc_constant")
    public static long spvc_compiler_get_constant_handle(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_constant_id") int id) {
        long __functionAddress = Functions.compiler_get_constant_handle;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePP((long)compiler, (int)id, (long)__functionAddress);
    }

    public static int nspvc_compiler_get_work_group_size_specialization_constants(long compiler, long x, long y, long z) {
        long __functionAddress = Functions.compiler_get_work_group_size_specialization_constants;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPPI((long)compiler, (long)x, (long)y, (long)z, (long)__functionAddress);
    }

    @NativeType(value="spvc_constant_id")
    public static int spvc_compiler_get_work_group_size_specialization_constants(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_specialization_constant *") SpvcSpecializationConstant x, @NativeType(value="spvc_specialization_constant *") SpvcSpecializationConstant y, @NativeType(value="spvc_specialization_constant *") SpvcSpecializationConstant z) {
        return Spvc.nspvc_compiler_get_work_group_size_specialization_constants(compiler, x.address(), y.address(), z.address());
    }

    public static int nspvc_compiler_get_active_buffer_ranges(long compiler, int id, long ranges, long num_ranges) {
        long __functionAddress = Functions.compiler_get_active_buffer_ranges;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPI((long)compiler, (int)id, (long)ranges, (long)num_ranges, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_get_active_buffer_ranges(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_variable_id") int id, @NativeType(value="spvc_buffer_range const **") PointerBuffer ranges, @NativeType(value="size_t *") PointerBuffer num_ranges) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ranges, (int)1);
            Checks.check((CustomBuffer)num_ranges, (int)1);
        }
        return Spvc.nspvc_compiler_get_active_buffer_ranges(compiler, id, MemoryUtil.memAddress((CustomBuffer)ranges), MemoryUtil.memAddress((CustomBuffer)num_ranges));
    }

    public static float spvc_constant_get_scalar_fp16(@NativeType(value="spvc_constant") long constant, @NativeType(value="unsigned int") int column, @NativeType(value="unsigned int") int row) {
        long __functionAddress = Functions.constant_get_scalar_fp16;
        if (Checks.CHECKS) {
            Checks.check((long)constant);
        }
        return JNI.invokePF((long)constant, (int)column, (int)row, (long)__functionAddress);
    }

    public static float spvc_constant_get_scalar_fp32(@NativeType(value="spvc_constant") long constant, @NativeType(value="unsigned int") int column, @NativeType(value="unsigned int") int row) {
        long __functionAddress = Functions.constant_get_scalar_fp32;
        if (Checks.CHECKS) {
            Checks.check((long)constant);
        }
        return JNI.invokePF((long)constant, (int)column, (int)row, (long)__functionAddress);
    }

    public static double spvc_constant_get_scalar_fp64(@NativeType(value="spvc_constant") long constant, @NativeType(value="unsigned int") int column, @NativeType(value="unsigned int") int row) {
        long __functionAddress = Functions.constant_get_scalar_fp64;
        if (Checks.CHECKS) {
            Checks.check((long)constant);
        }
        return JNI.invokePD((long)constant, (int)column, (int)row, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int spvc_constant_get_scalar_u32(@NativeType(value="spvc_constant") long constant, @NativeType(value="unsigned int") int column, @NativeType(value="unsigned int") int row) {
        long __functionAddress = Functions.constant_get_scalar_u32;
        if (Checks.CHECKS) {
            Checks.check((long)constant);
        }
        return JNI.invokePI((long)constant, (int)column, (int)row, (long)__functionAddress);
    }

    public static int spvc_constant_get_scalar_i32(@NativeType(value="spvc_constant") long constant, @NativeType(value="unsigned int") int column, @NativeType(value="unsigned int") int row) {
        long __functionAddress = Functions.constant_get_scalar_i32;
        if (Checks.CHECKS) {
            Checks.check((long)constant);
        }
        return JNI.invokePI((long)constant, (int)column, (int)row, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int spvc_constant_get_scalar_u16(@NativeType(value="spvc_constant") long constant, @NativeType(value="unsigned int") int column, @NativeType(value="unsigned int") int row) {
        long __functionAddress = Functions.constant_get_scalar_u16;
        if (Checks.CHECKS) {
            Checks.check((long)constant);
        }
        return JNI.invokePI((long)constant, (int)column, (int)row, (long)__functionAddress);
    }

    public static int spvc_constant_get_scalar_i16(@NativeType(value="spvc_constant") long constant, @NativeType(value="unsigned int") int column, @NativeType(value="unsigned int") int row) {
        long __functionAddress = Functions.constant_get_scalar_i16;
        if (Checks.CHECKS) {
            Checks.check((long)constant);
        }
        return JNI.invokePI((long)constant, (int)column, (int)row, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int spvc_constant_get_scalar_u8(@NativeType(value="spvc_constant") long constant, @NativeType(value="unsigned int") int column, @NativeType(value="unsigned int") int row) {
        long __functionAddress = Functions.constant_get_scalar_u8;
        if (Checks.CHECKS) {
            Checks.check((long)constant);
        }
        return JNI.invokePI((long)constant, (int)column, (int)row, (long)__functionAddress);
    }

    public static int spvc_constant_get_scalar_i8(@NativeType(value="spvc_constant") long constant, @NativeType(value="unsigned int") int column, @NativeType(value="unsigned int") int row) {
        long __functionAddress = Functions.constant_get_scalar_i8;
        if (Checks.CHECKS) {
            Checks.check((long)constant);
        }
        return JNI.invokePI((long)constant, (int)column, (int)row, (long)__functionAddress);
    }

    public static void nspvc_constant_get_subconstants(long constant, long constituents, long count) {
        long __functionAddress = Functions.constant_get_subconstants;
        if (Checks.CHECKS) {
            Checks.check((long)constant);
        }
        JNI.invokePPPV((long)constant, (long)constituents, (long)count, (long)__functionAddress);
    }

    public static void spvc_constant_get_subconstants(@NativeType(value="spvc_constant") long constant, @NativeType(value="spvc_constant_id const **") PointerBuffer constituents, @NativeType(value="size_t *") PointerBuffer count) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)constituents, (int)1);
            Checks.check((CustomBuffer)count, (int)1);
        }
        Spvc.nspvc_constant_get_subconstants(constant, MemoryUtil.memAddress((CustomBuffer)constituents), MemoryUtil.memAddress((CustomBuffer)count));
    }

    @NativeType(value="spvc_type_id")
    public static int spvc_constant_get_type(@NativeType(value="spvc_constant") long constant) {
        long __functionAddress = Functions.constant_get_type;
        if (Checks.CHECKS) {
            Checks.check((long)constant);
        }
        return JNI.invokePI((long)constant, (long)__functionAddress);
    }

    public static boolean nspvc_compiler_get_binary_offset_for_decoration(long compiler, int id, int decoration, long word_offset) {
        long __functionAddress = Functions.compiler_get_binary_offset_for_decoration;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPZ((long)compiler, (int)id, (int)decoration, (long)word_offset, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_get_binary_offset_for_decoration(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_variable_id") int id, @NativeType(value="SpvDecoration") int decoration, @NativeType(value="unsigned int *") IntBuffer word_offset) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)word_offset, (int)1);
        }
        return Spvc.nspvc_compiler_get_binary_offset_for_decoration(compiler, id, decoration, MemoryUtil.memAddress((IntBuffer)word_offset));
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_buffer_is_hlsl_counter_buffer(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_variable_id") int id) {
        long __functionAddress = Functions.compiler_buffer_is_hlsl_counter_buffer;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePZ((long)compiler, (int)id, (long)__functionAddress);
    }

    public static boolean nspvc_compiler_buffer_get_hlsl_counter_buffer(long compiler, int id, long counter_id) {
        long __functionAddress = Functions.compiler_buffer_get_hlsl_counter_buffer;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPZ((long)compiler, (int)id, (long)counter_id, (long)__functionAddress);
    }

    @NativeType(value="spvc_bool")
    public static boolean spvc_compiler_buffer_get_hlsl_counter_buffer(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_variable_id") int id, @NativeType(value="spvc_variable_id *") IntBuffer counter_id) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)counter_id, (int)1);
        }
        return Spvc.nspvc_compiler_buffer_get_hlsl_counter_buffer(compiler, id, MemoryUtil.memAddress((IntBuffer)counter_id));
    }

    public static int nspvc_compiler_get_declared_capabilities(long compiler, long capabilities, long num_capabilities) {
        long __functionAddress = Functions.compiler_get_declared_capabilities;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPI((long)compiler, (long)capabilities, (long)num_capabilities, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_get_declared_capabilities(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="SpvCapability const **") PointerBuffer capabilities, @NativeType(value="size_t *") PointerBuffer num_capabilities) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)capabilities, (int)1);
            Checks.check((CustomBuffer)num_capabilities, (int)1);
        }
        return Spvc.nspvc_compiler_get_declared_capabilities(compiler, MemoryUtil.memAddress((CustomBuffer)capabilities), MemoryUtil.memAddress((CustomBuffer)num_capabilities));
    }

    public static int nspvc_compiler_get_declared_extensions(long compiler, long extensions, long num_extensions) {
        long __functionAddress = Functions.compiler_get_declared_extensions;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPI((long)compiler, (long)extensions, (long)num_extensions, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_get_declared_extensions(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="char const ***") PointerBuffer extensions, @NativeType(value="size_t *") PointerBuffer num_extensions) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)extensions, (int)1);
            Checks.check((CustomBuffer)num_extensions, (int)1);
        }
        return Spvc.nspvc_compiler_get_declared_extensions(compiler, MemoryUtil.memAddress((CustomBuffer)extensions), MemoryUtil.memAddress((CustomBuffer)num_extensions));
    }

    public static long nspvc_compiler_get_remapped_declared_block_name(long compiler, int id) {
        long __functionAddress = Functions.compiler_get_remapped_declared_block_name;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePP((long)compiler, (int)id, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String spvc_compiler_get_remapped_declared_block_name(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_variable_id") int id) {
        long __result = Spvc.nspvc_compiler_get_remapped_declared_block_name(compiler, id);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static int nspvc_compiler_get_buffer_block_decorations(long compiler, int id, long decorations, long num_decorations) {
        long __functionAddress = Functions.compiler_get_buffer_block_decorations;
        if (Checks.CHECKS) {
            Checks.check((long)compiler);
        }
        return JNI.invokePPPI((long)compiler, (int)id, (long)decorations, (long)num_decorations, (long)__functionAddress);
    }

    @NativeType(value="spvc_result")
    public static int spvc_compiler_get_buffer_block_decorations(@NativeType(value="spvc_compiler") long compiler, @NativeType(value="spvc_variable_id") int id, @NativeType(value="SpvDecoration const **") PointerBuffer decorations, @NativeType(value="size_t *") PointerBuffer num_decorations) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)decorations, (int)1);
            Checks.check((CustomBuffer)num_decorations, (int)1);
        }
        return Spvc.nspvc_compiler_get_buffer_block_decorations(compiler, id, MemoryUtil.memAddress((CustomBuffer)decorations), MemoryUtil.memAddress((CustomBuffer)num_decorations));
    }

    static /* synthetic */ SharedLibrary access$000() {
        return SPVC;
    }

    public static final class Functions {
        public static final long get_version = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_get_version");
        public static final long get_commit_revision_and_timestamp = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_get_commit_revision_and_timestamp");
        public static final long msl_vertex_attribute_init = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_msl_vertex_attribute_init");
        public static final long msl_shader_input_init = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_msl_shader_input_init");
        public static final long msl_resource_binding_init = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_msl_resource_binding_init");
        public static final long msl_get_aux_buffer_struct_version = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_msl_get_aux_buffer_struct_version");
        public static final long msl_constexpr_sampler_init = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_msl_constexpr_sampler_init");
        public static final long msl_sampler_ycbcr_conversion_init = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_msl_sampler_ycbcr_conversion_init");
        public static final long hlsl_resource_binding_init = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_hlsl_resource_binding_init");
        public static final long context_create = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_context_create");
        public static final long context_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_context_destroy");
        public static final long context_release_allocations = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_context_release_allocations");
        public static final long context_get_last_error_string = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_context_get_last_error_string");
        public static final long context_set_error_callback = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_context_set_error_callback");
        public static final long context_parse_spirv = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_context_parse_spirv");
        public static final long context_create_compiler = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_context_create_compiler");
        public static final long compiler_get_current_id_bound = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_current_id_bound");
        public static final long compiler_create_compiler_options = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_create_compiler_options");
        public static final long compiler_options_set_bool = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_options_set_bool");
        public static final long compiler_options_set_uint = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_options_set_uint");
        public static final long compiler_install_compiler_options = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_install_compiler_options");
        public static final long compiler_compile = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_compile");
        public static final long compiler_add_header_line = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_add_header_line");
        public static final long compiler_require_extension = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_require_extension");
        public static final long compiler_flatten_buffer_block = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_flatten_buffer_block");
        public static final long compiler_variable_is_depth_or_compare = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_variable_is_depth_or_compare");
        public static final long compiler_mask_stage_output_by_location = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_mask_stage_output_by_location");
        public static final long compiler_mask_stage_output_by_builtin = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_mask_stage_output_by_builtin");
        public static final long compiler_hlsl_set_root_constants_layout = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_hlsl_set_root_constants_layout");
        public static final long compiler_hlsl_add_vertex_attribute_remap = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_hlsl_add_vertex_attribute_remap");
        public static final long compiler_hlsl_remap_num_workgroups_builtin = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_hlsl_remap_num_workgroups_builtin");
        public static final long compiler_hlsl_set_resource_binding_flags = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_hlsl_set_resource_binding_flags");
        public static final long compiler_hlsl_add_resource_binding = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_hlsl_add_resource_binding");
        public static final long compiler_hlsl_is_resource_used = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_hlsl_is_resource_used");
        public static final long compiler_msl_is_rasterization_disabled = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_is_rasterization_disabled");
        public static final long compiler_msl_needs_swizzle_buffer = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_needs_swizzle_buffer");
        public static final long compiler_msl_needs_buffer_size_buffer = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_needs_buffer_size_buffer");
        public static final long compiler_msl_needs_output_buffer = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_needs_output_buffer");
        public static final long compiler_msl_needs_patch_output_buffer = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_needs_patch_output_buffer");
        public static final long compiler_msl_needs_input_threadgroup_mem = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_needs_input_threadgroup_mem");
        public static final long compiler_msl_add_vertex_attribute = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_add_vertex_attribute");
        public static final long compiler_msl_add_resource_binding = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_add_resource_binding");
        public static final long compiler_msl_add_shader_input = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_add_shader_input");
        public static final long compiler_msl_add_discrete_descriptor_set = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_add_discrete_descriptor_set");
        public static final long compiler_msl_set_argument_buffer_device_address_space = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_set_argument_buffer_device_address_space");
        public static final long compiler_msl_is_vertex_attribute_used = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_is_vertex_attribute_used");
        public static final long compiler_msl_is_shader_input_used = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_is_shader_input_used");
        public static final long compiler_msl_is_resource_used = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_is_resource_used");
        public static final long compiler_msl_remap_constexpr_sampler = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_remap_constexpr_sampler");
        public static final long compiler_msl_remap_constexpr_sampler_by_binding = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_remap_constexpr_sampler_by_binding");
        public static final long compiler_msl_remap_constexpr_sampler_ycbcr = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_remap_constexpr_sampler_ycbcr");
        public static final long compiler_msl_remap_constexpr_sampler_by_binding_ycbcr = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_remap_constexpr_sampler_by_binding_ycbcr");
        public static final long compiler_msl_set_fragment_output_components = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_set_fragment_output_components");
        public static final long compiler_msl_get_automatic_resource_binding = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_get_automatic_resource_binding");
        public static final long compiler_msl_get_automatic_resource_binding_secondary = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_get_automatic_resource_binding_secondary");
        public static final long compiler_msl_add_dynamic_buffer = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_add_dynamic_buffer");
        public static final long compiler_msl_add_inline_uniform_block = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_add_inline_uniform_block");
        public static final long compiler_msl_set_combined_sampler_suffix = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_set_combined_sampler_suffix");
        public static final long compiler_msl_get_combined_sampler_suffix = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_msl_get_combined_sampler_suffix");
        public static final long compiler_get_active_interface_variables = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_active_interface_variables");
        public static final long compiler_set_enabled_interface_variables = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_set_enabled_interface_variables");
        public static final long compiler_create_shader_resources = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_create_shader_resources");
        public static final long compiler_create_shader_resources_for_active_variables = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_create_shader_resources_for_active_variables");
        public static final long resources_get_resource_list_for_type = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_resources_get_resource_list_for_type");
        public static final long resources_get_builtin_resource_list_for_type = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_resources_get_builtin_resource_list_for_type");
        public static final long compiler_set_decoration = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_set_decoration");
        public static final long compiler_set_decoration_string = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_set_decoration_string");
        public static final long compiler_set_name = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_set_name");
        public static final long compiler_set_member_decoration = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_set_member_decoration");
        public static final long compiler_set_member_decoration_string = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_set_member_decoration_string");
        public static final long compiler_set_member_name = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_set_member_name");
        public static final long compiler_unset_decoration = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_unset_decoration");
        public static final long compiler_unset_member_decoration = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_unset_member_decoration");
        public static final long compiler_has_decoration = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_has_decoration");
        public static final long compiler_has_member_decoration = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_has_member_decoration");
        public static final long compiler_get_name = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_name");
        public static final long compiler_get_decoration = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_decoration");
        public static final long compiler_get_decoration_string = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_decoration_string");
        public static final long compiler_get_member_decoration = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_member_decoration");
        public static final long compiler_get_member_decoration_string = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_member_decoration_string");
        public static final long compiler_get_member_name = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_member_name");
        public static final long compiler_get_entry_points = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_entry_points");
        public static final long compiler_set_entry_point = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_set_entry_point");
        public static final long compiler_rename_entry_point = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_rename_entry_point");
        public static final long compiler_get_cleansed_entry_point_name = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_cleansed_entry_point_name");
        public static final long compiler_set_execution_mode = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_set_execution_mode");
        public static final long compiler_unset_execution_mode = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_unset_execution_mode");
        public static final long compiler_set_execution_mode_with_arguments = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_set_execution_mode_with_arguments");
        public static final long compiler_get_execution_modes = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_execution_modes");
        public static final long compiler_get_execution_mode_argument = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_execution_mode_argument");
        public static final long compiler_get_execution_mode_argument_by_index = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_execution_mode_argument_by_index");
        public static final long compiler_get_execution_model = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_execution_model");
        public static final long compiler_update_active_builtins = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_update_active_builtins");
        public static final long compiler_has_active_builtin = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_has_active_builtin");
        public static final long compiler_get_type_handle = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_type_handle");
        public static final long type_get_base_type_id = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_base_type_id");
        public static final long type_get_basetype = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_basetype");
        public static final long type_get_bit_width = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_bit_width");
        public static final long type_get_vector_size = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_vector_size");
        public static final long type_get_columns = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_columns");
        public static final long type_get_num_array_dimensions = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_num_array_dimensions");
        public static final long type_array_dimension_is_literal = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_array_dimension_is_literal");
        public static final long type_get_array_dimension = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_array_dimension");
        public static final long type_get_num_member_types = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_num_member_types");
        public static final long type_get_member_type = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_member_type");
        public static final long type_get_storage_class = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_storage_class");
        public static final long type_get_image_sampled_type = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_image_sampled_type");
        public static final long type_get_image_dimension = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_image_dimension");
        public static final long type_get_image_is_depth = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_image_is_depth");
        public static final long type_get_image_arrayed = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_image_arrayed");
        public static final long type_get_image_multisampled = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_image_multisampled");
        public static final long type_get_image_is_storage = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_image_is_storage");
        public static final long type_get_image_storage_format = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_image_storage_format");
        public static final long type_get_image_access_qualifier = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_type_get_image_access_qualifier");
        public static final long compiler_get_declared_struct_size = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_declared_struct_size");
        public static final long compiler_get_declared_struct_size_runtime_array = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_declared_struct_size_runtime_array");
        public static final long compiler_get_declared_struct_member_size = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_declared_struct_member_size");
        public static final long compiler_type_struct_member_offset = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_type_struct_member_offset");
        public static final long compiler_type_struct_member_array_stride = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_type_struct_member_array_stride");
        public static final long compiler_type_struct_member_matrix_stride = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_type_struct_member_matrix_stride");
        public static final long compiler_build_dummy_sampler_for_combined_images = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_build_dummy_sampler_for_combined_images");
        public static final long compiler_build_combined_image_samplers = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_build_combined_image_samplers");
        public static final long compiler_get_combined_image_samplers = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_combined_image_samplers");
        public static final long compiler_get_specialization_constants = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_specialization_constants");
        public static final long compiler_get_constant_handle = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_constant_handle");
        public static final long compiler_get_work_group_size_specialization_constants = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_work_group_size_specialization_constants");
        public static final long compiler_get_active_buffer_ranges = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_active_buffer_ranges");
        public static final long constant_get_scalar_fp16 = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_constant_get_scalar_fp16");
        public static final long constant_get_scalar_fp32 = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_constant_get_scalar_fp32");
        public static final long constant_get_scalar_fp64 = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_constant_get_scalar_fp64");
        public static final long constant_get_scalar_u32 = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_constant_get_scalar_u32");
        public static final long constant_get_scalar_i32 = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_constant_get_scalar_i32");
        public static final long constant_get_scalar_u16 = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_constant_get_scalar_u16");
        public static final long constant_get_scalar_i16 = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_constant_get_scalar_i16");
        public static final long constant_get_scalar_u8 = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_constant_get_scalar_u8");
        public static final long constant_get_scalar_i8 = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_constant_get_scalar_i8");
        public static final long constant_get_subconstants = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_constant_get_subconstants");
        public static final long constant_get_type = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_constant_get_type");
        public static final long compiler_get_binary_offset_for_decoration = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_binary_offset_for_decoration");
        public static final long compiler_buffer_is_hlsl_counter_buffer = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_buffer_is_hlsl_counter_buffer");
        public static final long compiler_buffer_get_hlsl_counter_buffer = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_buffer_get_hlsl_counter_buffer");
        public static final long compiler_get_declared_capabilities = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_declared_capabilities");
        public static final long compiler_get_declared_extensions = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_declared_extensions");
        public static final long compiler_get_remapped_declared_block_name = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_remapped_declared_block_name");
        public static final long compiler_get_buffer_block_decorations = APIUtil.apiGetFunctionAddress((FunctionProvider)Spvc.access$000(), (String)"spvc_compiler_get_buffer_block_decorations");

        private Functions() {
        }
    }
}

