/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.security.openid.OpenIdCredentials;
import org.eclipse.jetty.security.openid.OpenIdUserIdentity;
import org.eclipse.jetty.security.openid.OpenIdUserPrincipal;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class OpenIdLoginService
extends ContainerLifeCycle
implements LoginService {
    private static final Logger LOG = Log.getLogger(OpenIdLoginService.class);
    private final OpenIdConfiguration configuration;
    private final LoginService loginService;
    private IdentityService identityService;
    private boolean authenticateNewUsers;

    public OpenIdLoginService(OpenIdConfiguration configuration) {
        this(configuration, null);
    }

    public OpenIdLoginService(OpenIdConfiguration configuration, LoginService loginService) {
        this.configuration = configuration;
        this.loginService = loginService;
        this.addBean((Object)this.configuration);
        this.addBean(this.loginService);
    }

    public String getName() {
        return this.configuration.getIssuer();
    }

    public OpenIdConfiguration getConfiguration() {
        return this.configuration;
    }

    public UserIdentity login(String identifier, Object credentials, ServletRequest req) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("login({}, {}, {})", new Object[]{identifier, credentials, req});
        }
        OpenIdCredentials openIdCredentials = (OpenIdCredentials)credentials;
        try {
            openIdCredentials.redeemAuthCode(this.configuration);
        }
        catch (Throwable e) {
            LOG.warn(e);
            return null;
        }
        OpenIdUserPrincipal userPrincipal = new OpenIdUserPrincipal(openIdCredentials);
        Subject subject = new Subject();
        subject.getPrincipals().add(userPrincipal);
        subject.getPrivateCredentials().add(credentials);
        subject.setReadOnly();
        if (this.loginService != null) {
            UserIdentity userIdentity = this.loginService.login(openIdCredentials.getUserId(), (Object)"", req);
            if (userIdentity == null) {
                if (this.isAuthenticateNewUsers()) {
                    return this.getIdentityService().newUserIdentity(subject, (Principal)userPrincipal, new String[0]);
                }
                return null;
            }
            return new OpenIdUserIdentity(subject, userPrincipal, userIdentity);
        }
        return this.identityService.newUserIdentity(subject, (Principal)userPrincipal, new String[0]);
    }

    public boolean isAuthenticateNewUsers() {
        return this.authenticateNewUsers;
    }

    public void setAuthenticateNewUsers(boolean authenticateNewUsers) {
        this.authenticateNewUsers = authenticateNewUsers;
    }

    public boolean validate(UserIdentity user) {
        if (!(user.getUserPrincipal() instanceof OpenIdUserPrincipal)) {
            return false;
        }
        return this.loginService == null || this.loginService.validate(user);
    }

    public IdentityService getIdentityService() {
        return this.loginService == null ? this.identityService : this.loginService.getIdentityService();
    }

    public void setIdentityService(IdentityService service) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        if (this.loginService != null) {
            this.loginService.setIdentityService(service);
        } else {
            this.identityService = service;
        }
    }

    public void logout(UserIdentity user) {
        if (this.loginService != null) {
            this.loginService.logout(user);
        }
    }
}

