/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.whiteboard.Preprocessor;

public class PreprocessorFilterConfig
implements FilterConfig {
    private final FilterModel model;
    private final OsgiServletContext context;
    private boolean initCalled = false;
    private Preprocessor instance;
    private ServiceObjects<Filter> serviceObjects;

    public PreprocessorFilterConfig(FilterModel model, OsgiServletContext context) {
        this.model = model;
        this.context = context;
    }

    public Preprocessor getInstance() {
        BundleContext context;
        if (this.instance != null) {
            return this.instance;
        }
        ServiceReference ref = this.model.getElementReference();
        if (ref != null && (context = this.model.getRegisteringBundle().getBundleContext()) != null) {
            if (!this.model.isPrototype()) {
                this.instance = (Preprocessor)context.getService(ref);
            } else {
                this.serviceObjects = context.getServiceObjects(ref);
                if (this.serviceObjects != null) {
                    this.instance = (Preprocessor)this.serviceObjects.getService();
                }
            }
        }
        if (this.instance == null && this.model.getFilterClass() != null) {
            try {
                this.instance = (Preprocessor)this.model.getFilterClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't instantiate Preprocessor with class " + this.model.getFilterClass(), e);
            }
        }
        if (this.instance == null && this.model.getElementSupplier() != null) {
            this.instance = (Preprocessor)this.model.getElementSupplier().get();
        }
        if (this.instance == null) {
            this.model.setDtoFailureCode(5);
        }
        return this.instance;
    }

    public void destroy() {
        if (this.instance != null) {
            this.instance.destroy();
            this.instance = null;
            if (this.model.getElementReference() != null) {
                if (!this.model.isPrototype()) {
                    BundleContext context = this.model.getRegisteringBundle().getBundleContext();
                    if (context != null) {
                        context.ungetService(this.model.getElementReference());
                    }
                } else if (this.serviceObjects != null && this.getInstance() != null) {
                    this.serviceObjects.ungetService((Object)this.getInstance());
                    this.serviceObjects = null;
                }
            }
        }
    }

    public FilterModel getModel() {
        return this.model;
    }

    public String getFilterName() {
        return this.model.getName();
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String getInitParameter(String name) {
        return this.model.getInitParams().get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.model.getInitParams().keySet());
    }

    public void setInitCalled(boolean initCalled) {
        this.initCalled = initCalled;
    }

    public boolean isInitCalled() {
        return this.initCalled;
    }

    public void copyFrom(PreprocessorFilterConfig pfc) {
        this.instance = pfc.instance;
        this.serviceObjects = pfc.serviceObjects;
    }
}

