/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.NodeConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.cipher.RandomManager;

public class MultiNodeConnectionIdGenerator
implements NodeConnectionIdGenerator {
    private final int nodeId;
    private final int connectionIdLength;

    public MultiNodeConnectionIdGenerator(int nodeId, int connectionIdLength) {
        if (connectionIdLength < 2) {
            throw new IllegalArgumentException("cid length must be at least 2 bytes!");
        }
        this.nodeId = nodeId;
        this.connectionIdLength = connectionIdLength;
    }

    @Override
    public boolean useConnectionId() {
        return true;
    }

    @Override
    public ConnectionId createConnectionId() {
        byte[] cidBytes = new byte[this.connectionIdLength];
        RandomManager.currentRandom().nextBytes(cidBytes);
        cidBytes[0] = (byte)this.nodeId;
        return new ConnectionId(cidBytes);
    }

    @Override
    public ConnectionId read(DatagramReader reader) {
        byte[] cidBytes = reader.readBytes(this.connectionIdLength);
        return new ConnectionId(cidBytes);
    }

    @Override
    public int getNodeId() {
        return this.nodeId;
    }

    @Override
    public int getNodeId(ConnectionId cid) {
        return cid.getBytes()[0] & 0xFF;
    }
}

