/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mod(dvec3(-1.9lf, -1.9lf, -1.9lf), dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)) => dvec3(-1.9lf, -0.5666666666666664lf, 0.09999999999999964lf)
 * mod(dvec3(-1.9lf, -0.6333333333333333lf, -0.6333333333333333lf), dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)) => dvec3(0.10000000000000009lf, -0.6333333333333333lf, -0.6333333333333333lf)
 * mod(dvec3(-0.6333333333333333lf, -0.6333333333333333lf, 0.6333333333333333lf), dvec3(0.6666666666666665lf, 2.0lf, -2.0lf)) => dvec3(0.033333333333333215lf, 1.3666666666666667lf, -1.3666666666666667lf)
 * mod(dvec3(0.6333333333333333lf, 0.6333333333333333lf, 0.6333333333333333lf), dvec3(-0.6666666666666667lf, 0.6666666666666665lf, 2.0lf)) => dvec3(-0.03333333333333344lf, 0.6333333333333333lf, 0.6333333333333333lf)
 * mod(dvec3(1.9lf, 1.9lf, 1.9lf), dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)) => dvec3(-0.10000000000000009lf, -0.10000000000000009lf, 0.5666666666666669lf)
 * mod(dvec3(1.9lf, -1.9lf, -1.9lf), dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)) => dvec3(1.9lf, -1.9lf, -0.5666666666666664lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(mod(dvec3(-1.9lf, -1.9lf, -1.9lf), dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)), dvec3(-1.9lf, -0.5666666666666664lf, 0.09999999999999964lf)) <= 1.985223189243746e-05lf ? 1 : -1] array0;
  double[distance(mod(dvec3(-1.9lf, -0.6333333333333333lf, -0.6333333333333333lf), dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)), dvec3(0.10000000000000009lf, -0.6333333333333333lf, -0.6333333333333333lf)) <= 9.012337223063851e-06lf ? 1 : -1] array1;
  double[distance(mod(dvec3(-0.6333333333333333lf, -0.6333333333333333lf, 0.6333333333333333lf), dvec3(0.6666666666666665lf, 2.0lf, -2.0lf)), dvec3(0.033333333333333215lf, 1.3666666666666667lf, -1.3666666666666667lf)) <= 1.933045955653064e-05lf ? 1 : -1] array2;
  double[distance(mod(dvec3(0.6333333333333333lf, 0.6333333333333333lf, 0.6333333333333333lf), dvec3(-0.6666666666666667lf, 0.6666666666666665lf, 2.0lf)), dvec3(-0.03333333333333344lf, 0.6333333333333333lf, 0.6333333333333333lf)) <= 8.962886439832502e-06lf ? 1 : -1] array3;
  double[distance(mod(dvec3(1.9lf, 1.9lf, 1.9lf), dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)), dvec3(-0.10000000000000009lf, -0.10000000000000009lf, 0.5666666666666669lf)) <= 5.840471822645081e-06lf ? 1 : -1] array4;
  double[distance(mod(dvec3(1.9lf, -1.9lf, -1.9lf), dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)), dvec3(1.9lf, -1.9lf, -0.5666666666666664lf)) <= 2.7461083574963156e-05lf ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
