/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * normalize(dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => dvec4(-0.5564077658364623lf, 0.44849838094696665lf, 0.6508284776147711lf, 0.25628478911255237lf)
 * normalize(dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)) => dvec4(0.8328815886623452lf, -0.1561652978741897lf, -0.530962012772245lf, 0.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(normalize(dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), dvec4(-0.5564077658364623lf, 0.44849838094696665lf, 0.6508284776147711lf, 0.25628478911255237lf)) <= 1e-05lf ? 1 : -1] array0;
  double[distance(normalize(dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)), dvec4(0.8328815886623452lf, -0.1561652978741897lf, -0.530962012772245lf, 0.0lf)) <= 1e-05lf ? 1 : -1] array1;
  gl_FragColor = vec4(array0.length() + array1.length());
}
