/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0ul - u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(18446744073709551451ul, 18446744073709551483ul, 18446744073709551423ul, 18446744073709551540ul)
 * (0ul - u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(18446744073709551536ul, 18446744073709551601ul, 18446744073709551565ul, 0ul)
 * (3ul - u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(18446744073709551454ul, 18446744073709551486ul, 18446744073709551426ul, 18446744073709551543ul)
 * (3ul - u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(18446744073709551539ul, 18446744073709551604ul, 18446744073709551568ul, 3ul)
 * (1192ul - u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(1027ul, 1059ul, 999ul, 1116ul)
 * (1192ul - u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(1112ul, 1177ul, 1141ul, 1192ul)
 * (1048576ul - u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(1048411ul, 1048443ul, 1048383ul, 1048500ul)
 * (1048576ul - u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(1048496ul, 1048561ul, 1048525ul, 1048576ul)
 * (4251475ul - u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(4251310ul, 4251342ul, 4251282ul, 4251399ul)
 * (4251475ul - u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(4251395ul, 4251460ul, 4251424ul, 4251475ul)
 * (29852643761ul - u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(29852643596ul, 29852643628ul, 29852643568ul, 29852643685ul)
 * (29852643761ul - u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(29852643681ul, 29852643746ul, 29852643710ul, 29852643761ul)
 * (4398046511104ul - u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(4398046510939ul, 4398046510971ul, 4398046510911ul, 4398046511028ul)
 * (4398046511104ul - u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(4398046511024ul, 4398046511089ul, 4398046511053ul, 4398046511104ul)
 * (3948976685146ul - u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(3948976684981ul, 3948976685013ul, 3948976684953ul, 3948976685070ul)
 * (3948976685146ul - u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(3948976685066ul, 3948976685131ul, 3948976685095ul, 3948976685146ul)
 * (135763469567146206ul - u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(135763469567146041ul, 135763469567146073ul, 135763469567146013ul, 135763469567146130ul)
 * (135763469567146206ul - u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(135763469567146126ul, 135763469567146191ul, 135763469567146155ul, 135763469567146206ul)
 * (11654173250180970009ul - u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(11654173250180969844ul, 11654173250180969876ul, 11654173250180969816ul, 11654173250180969933ul)
 * (11654173250180970009ul - u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(11654173250180969929ul, 11654173250180969994ul, 11654173250180969958ul, 11654173250180970009ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0ul - u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(18446744073709551451ul, 18446744073709551483ul, 18446744073709551423ul, 18446744073709551540ul))) ? 1 : -1] array0;
  float[all(equal((0ul - u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(18446744073709551536ul, 18446744073709551601ul, 18446744073709551565ul, 0ul))) ? 1 : -1] array1;
  float[all(equal((3ul - u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(18446744073709551454ul, 18446744073709551486ul, 18446744073709551426ul, 18446744073709551543ul))) ? 1 : -1] array2;
  float[all(equal((3ul - u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(18446744073709551539ul, 18446744073709551604ul, 18446744073709551568ul, 3ul))) ? 1 : -1] array3;
  float[all(equal((1192ul - u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(1027ul, 1059ul, 999ul, 1116ul))) ? 1 : -1] array4;
  float[all(equal((1192ul - u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(1112ul, 1177ul, 1141ul, 1192ul))) ? 1 : -1] array5;
  float[all(equal((1048576ul - u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(1048411ul, 1048443ul, 1048383ul, 1048500ul))) ? 1 : -1] array6;
  float[all(equal((1048576ul - u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(1048496ul, 1048561ul, 1048525ul, 1048576ul))) ? 1 : -1] array7;
  float[all(equal((4251475ul - u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(4251310ul, 4251342ul, 4251282ul, 4251399ul))) ? 1 : -1] array8;
  float[all(equal((4251475ul - u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(4251395ul, 4251460ul, 4251424ul, 4251475ul))) ? 1 : -1] array9;
  float[all(equal((29852643761ul - u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(29852643596ul, 29852643628ul, 29852643568ul, 29852643685ul))) ? 1 : -1] array10;
  float[all(equal((29852643761ul - u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(29852643681ul, 29852643746ul, 29852643710ul, 29852643761ul))) ? 1 : -1] array11;
  float[all(equal((4398046511104ul - u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(4398046510939ul, 4398046510971ul, 4398046510911ul, 4398046511028ul))) ? 1 : -1] array12;
  float[all(equal((4398046511104ul - u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(4398046511024ul, 4398046511089ul, 4398046511053ul, 4398046511104ul))) ? 1 : -1] array13;
  float[all(equal((3948976685146ul - u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(3948976684981ul, 3948976685013ul, 3948976684953ul, 3948976685070ul))) ? 1 : -1] array14;
  float[all(equal((3948976685146ul - u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(3948976685066ul, 3948976685131ul, 3948976685095ul, 3948976685146ul))) ? 1 : -1] array15;
  float[all(equal((135763469567146206ul - u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(135763469567146041ul, 135763469567146073ul, 135763469567146013ul, 135763469567146130ul))) ? 1 : -1] array16;
  float[all(equal((135763469567146206ul - u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(135763469567146126ul, 135763469567146191ul, 135763469567146155ul, 135763469567146206ul))) ? 1 : -1] array17;
  float[all(equal((11654173250180970009ul - u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(11654173250180969844ul, 11654173250180969876ul, 11654173250180969816ul, 11654173250180969933ul))) ? 1 : -1] array18;
  float[all(equal((11654173250180970009ul - u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(11654173250180969929ul, 11654173250180969994ul, 11654173250180969958ul, 11654173250180970009ul))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
