/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec2(13, 26) << ivec2(13, 26)) => ivec2(106496, 1744830464)
 * (ivec2(13, 26) << ivec2(2, 26)) => ivec2(52, 1744830464)
 * (ivec2(-2, 26) << ivec2(13, 26)) => ivec2(-16384, 1744830464)
 * (ivec2(-2, 26) << ivec2(2, 26)) => ivec2(-8, 1744830464)
 * (ivec2(2, 26) << ivec2(13, 26)) => ivec2(16384, 1744830464)
 * (ivec2(2, 26) << ivec2(2, 26)) => ivec2(8, 1744830464)
 */
#version 130

void main()
{
  float[all(equal((ivec2(13, 26) << ivec2(13, 26)), ivec2(106496, 1744830464))) ? 1 : -1] array0;
  float[all(equal((ivec2(13, 26) << ivec2(2, 26)), ivec2(52, 1744830464))) ? 1 : -1] array1;
  float[all(equal((ivec2(-2, 26) << ivec2(13, 26)), ivec2(-16384, 1744830464))) ? 1 : -1] array2;
  float[all(equal((ivec2(-2, 26) << ivec2(2, 26)), ivec2(-8, 1744830464))) ? 1 : -1] array3;
  float[all(equal((ivec2(2, 26) << ivec2(13, 26)), ivec2(16384, 1744830464))) ? 1 : -1] array4;
  float[all(equal((ivec2(2, 26) << ivec2(2, 26)), ivec2(8, 1744830464))) ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
