/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(66u, 72u, 87u, 75u) % 6u) => uvec4(0u, 0u, 3u, 3u)
 * (uvec4(66u, 72u, 87u, 75u) % 12u) => uvec4(6u, 0u, 3u, 3u)
 * (uvec4(66u, 72u, 87u, 75u) % 32u) => uvec4(2u, 8u, 23u, 11u)
 * (uvec4(66u, 72u, 87u, 75u) % 74u) => uvec4(66u, 72u, 13u, 1u)
 * (uvec4(24u, 40u, 23u, 74u) % 6u) => uvec4(0u, 4u, 5u, 2u)
 * (uvec4(24u, 40u, 23u, 74u) % 12u) => uvec4(0u, 4u, 11u, 2u)
 * (uvec4(24u, 40u, 23u, 74u) % 32u) => uvec4(24u, 8u, 23u, 10u)
 * (uvec4(24u, 40u, 23u, 74u) % 74u) => uvec4(24u, 40u, 23u, 0u)
 */
#version 130

void main()
{
  float[all(equal((uvec4(66u, 72u, 87u, 75u) % 6u), uvec4(0u, 0u, 3u, 3u))) ? 1 : -1] array0;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) % 12u), uvec4(6u, 0u, 3u, 3u))) ? 1 : -1] array1;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) % 32u), uvec4(2u, 8u, 23u, 11u))) ? 1 : -1] array2;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) % 74u), uvec4(66u, 72u, 13u, 1u))) ? 1 : -1] array3;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) % 6u), uvec4(0u, 4u, 5u, 2u))) ? 1 : -1] array4;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) % 12u), uvec4(0u, 4u, 11u, 2u))) ? 1 : -1] array5;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) % 32u), uvec4(24u, 8u, 23u, 10u))) ? 1 : -1] array6;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) % 74u), uvec4(24u, 40u, 23u, 0u))) ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
