/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec2(38, 35) & abs(- 12)) => ivec2(4, 0)
 * (ivec2(38, 35) & abs(- -6)) => ivec2(6, 2)
 * (ivec2(38, 35) & abs(- 76)) => ivec2(4, 0)
 * (ivec2(38, 35) & abs(- -32)) => ivec2(32, 32)
 * (ivec2(38, 35) & abs(- 0)) => ivec2(0, 0)
 * (ivec2(64, -9) & abs(- 12)) => ivec2(0, 4)
 * (ivec2(64, -9) & abs(- -6)) => ivec2(0, 6)
 * (ivec2(64, -9) & abs(- 76)) => ivec2(64, 68)
 * (ivec2(64, -9) & abs(- -32)) => ivec2(0, 32)
 * (ivec2(64, -9) & abs(- 0)) => ivec2(0, 0)
 * (ivec2(64, 9) & abs(- 12)) => ivec2(0, 8)
 * (ivec2(64, 9) & abs(- -6)) => ivec2(0, 0)
 * (ivec2(64, 9) & abs(- 76)) => ivec2(64, 8)
 * (ivec2(64, 9) & abs(- -32)) => ivec2(0, 0)
 * (ivec2(64, 9) & abs(- 0)) => ivec2(0, 0)
 */
#version 150

void main()
{
  float[all(equal((ivec2(38, 35) & abs(- 12)), ivec2(4, 0))) ? 1 : -1] array0;
  float[all(equal((ivec2(38, 35) & abs(- -6)), ivec2(6, 2))) ? 1 : -1] array1;
  float[all(equal((ivec2(38, 35) & abs(- 76)), ivec2(4, 0))) ? 1 : -1] array2;
  float[all(equal((ivec2(38, 35) & abs(- -32)), ivec2(32, 32))) ? 1 : -1] array3;
  float[all(equal((ivec2(38, 35) & abs(- 0)), ivec2(0, 0))) ? 1 : -1] array4;
  float[all(equal((ivec2(64, -9) & abs(- 12)), ivec2(0, 4))) ? 1 : -1] array5;
  float[all(equal((ivec2(64, -9) & abs(- -6)), ivec2(0, 6))) ? 1 : -1] array6;
  float[all(equal((ivec2(64, -9) & abs(- 76)), ivec2(64, 68))) ? 1 : -1] array7;
  float[all(equal((ivec2(64, -9) & abs(- -32)), ivec2(0, 32))) ? 1 : -1] array8;
  float[all(equal((ivec2(64, -9) & abs(- 0)), ivec2(0, 0))) ? 1 : -1] array9;
  float[all(equal((ivec2(64, 9) & abs(- 12)), ivec2(0, 8))) ? 1 : -1] array10;
  float[all(equal((ivec2(64, 9) & abs(- -6)), ivec2(0, 0))) ? 1 : -1] array11;
  float[all(equal((ivec2(64, 9) & abs(- 76)), ivec2(64, 8))) ? 1 : -1] array12;
  float[all(equal((ivec2(64, 9) & abs(- -32)), ivec2(0, 0))) ? 1 : -1] array13;
  float[all(equal((ivec2(64, 9) & abs(- 0)), ivec2(0, 0))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
