/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.svg.colorprofile;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssSrc
extends org.w3c.css.properties.css.colorprofile.CssSrc {
    public static CssIdent sRGB = CssIdent.getIdent("sRGB");

    public CssSrc() {
        this.value = initial;
    }

    public CssSrc(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        if (check && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean gotIRI = false;
        boolean gotLocal = false;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 2: {
                    if (gotIRI) {
                        throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                    }
                    gotIRI = true;
                    values.add(val);
                    break;
                }
                case 11: {
                    if (gotLocal || gotIRI) {
                        throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                    }
                    this.parseLocal((CssFunction)val, ac);
                    values.add(val);
                    break;
                }
                case 0: {
                    if (sRGB.equals(val) && values.isEmpty()) {
                        this.value = sRGB;
                        gotIRI = true;
                        gotLocal = true;
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (!values.isEmpty()) {
            this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
        }
    }

    private void parseLocal(CssFunction f, ApplContext ac) throws InvalidParamException {
        if (!"local".equals(f.getName())) {
            throw new InvalidParamException("value", f, this.getPropertyName(), ac);
        }
        CssExpression exp = f.getParameters();
        if (exp.getCount() == 1 && exp.getValue().getType() == 1) {
            return;
        }
        throw new InvalidParamException("value", f, this.getPropertyName(), ac);
    }

    public CssSrc(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }
}

