/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.File;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.log4j.Logger;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ftp.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryFTP
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Logger log4j = Logger.getLogger(JobEntryFTP.class);
    private String serverName = null;
    private String userName;
    private String password;
    private String ftpDirectory;
    private String targetDirectory;
    private String wildcard;
    private boolean binaryMode;
    private int timeout;
    private boolean remove;
    private boolean onlyGettingNewFiles;
    private boolean activeConnection;
    private String controlEncoding;
    private static String LEGACY_CONTROL_ENCODING = "US-ASCII";
    private static String DEFAULT_CONTROL_ENCODING = "ISO-8859-1";
    private boolean movefiles = false;
    private String movetodirectory = null;
    private boolean adddate = false;
    private boolean addtime = false;
    private boolean SpecifyFormat = false;
    private String date_time_format;
    private boolean AddDateBeforeExtension = false;
    private boolean isaddresult = true;
    private boolean createmovefolder = false;
    private String port = "21";
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    public int ifFileExistsSkip = 0;
    public String SifFileExistsSkip = "ifFileExistsSkip";
    public int ifFileExistsCreateUniq = 1;
    public String SifFileExistsCreateUniq = "ifFileExistsCreateUniq";
    public int ifFileExistsFail = 2;
    public String SifFileExistsFail = "ifFileExistsFail";
    public int ifFileExists;
    public String SifFileExists;
    public String SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private String nr_limit = "10";
    private String success_condition = this.SUCCESS_IF_NO_ERRORS;
    long NrErrors = 0L;
    long NrfilesRetrieved = 0L;
    boolean successConditionBroken = false;
    int limitFiles = 0;
    String targetFilename = null;
    static String FILE_SEPARATOR = "/";

    public JobEntryFTP(String n) {
        super(n, "");
        this.ifFileExists = this.ifFileExistsSkip;
        this.SifFileExists = this.SifFileExistsSkip;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.FTP);
        this.setControlEncoding(DEFAULT_CONTROL_ENCODING);
    }

    public JobEntryFTP() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryFTP je = (JobEntryFTP)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(128);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ftpdirectory", (String)this.ftpDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targetdirectory", (String)this.targetDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"binary", (boolean)this.binaryMode));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (int)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remove", (boolean)this.remove));
        retval.append("      ").append(XMLHandler.addTagValue((String)"only_new", (boolean)this.onlyGettingNewFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"active", (boolean)this.activeConnection));
        retval.append("      ").append(XMLHandler.addTagValue((String)"control_encoding", (String)this.controlEncoding));
        retval.append("      ").append(XMLHandler.addTagValue((String)"movefiles", (boolean)this.movefiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"movetodirectory", (String)this.movetodirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"adddate", (boolean)this.adddate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addtime", (boolean)this.addtime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"AddDateBeforeExtension", (boolean)this.AddDateBeforeExtension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createmovefolder", (boolean)this.createmovefolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_host", (String)this.proxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_username", (String)this.proxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ifFileExists", (String)this.SifFileExists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_limit", (String)this.nr_limit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.port = XMLHandler.getTagValue((Node)entrynode, (String)"port");
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.ftpDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"ftpdirectory");
            this.targetDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"targetdirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.binaryMode = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"binary"));
            this.timeout = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"timeout"), (int)10000);
            this.remove = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"remove"));
            this.onlyGettingNewFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"only_new"));
            this.activeConnection = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"active"));
            this.controlEncoding = XMLHandler.getTagValue((Node)entrynode, (String)"control_encoding");
            if (this.controlEncoding == null) {
                this.controlEncoding = LEGACY_CONTROL_ENCODING;
            }
            this.movefiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"movefiles"));
            this.movetodirectory = XMLHandler.getTagValue((Node)entrynode, (String)"movetodirectory");
            this.adddate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"adddate"));
            this.addtime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addtime"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.AddDateBeforeExtension = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"AddDateBeforeExtension"));
            String addresult = XMLHandler.getTagValue((Node)entrynode, (String)"isaddresult");
            this.isaddresult = Const.isEmpty((String)addresult) ? true : "Y".equalsIgnoreCase(addresult);
            this.createmovefolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createmovefolder"));
            this.proxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_host");
            this.proxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_port");
            this.proxyUsername = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"proxy_password"));
            this.SifFileExists = XMLHandler.getTagValue((Node)entrynode, (String)"ifFileExists");
            this.ifFileExists = Const.isEmpty((String)this.SifFileExists) ? this.ifFileExistsSkip : (this.SifFileExists.equals(this.SifFileExistsCreateUniq) ? this.ifFileExistsCreateUniq : (this.SifFileExists.equals(this.SifFileExistsFail) ? this.ifFileExistsFail : this.ifFileExistsSkip));
            this.nr_limit = XMLHandler.getTagValue((Node)entrynode, (String)"nr_limit");
            this.success_condition = Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"success_condition"), (String)this.SUCCESS_IF_NO_ERRORS);
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'ftp' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.port = rep.getJobEntryAttributeString(id_jobentry, "port");
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.ftpDirectory = rep.getJobEntryAttributeString(id_jobentry, "ftpdirectory");
            this.targetDirectory = rep.getJobEntryAttributeString(id_jobentry, "targetdirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.binaryMode = rep.getJobEntryAttributeBoolean(id_jobentry, "binary");
            this.timeout = (int)rep.getJobEntryAttributeInteger(id_jobentry, "timeout");
            this.remove = rep.getJobEntryAttributeBoolean(id_jobentry, "remove");
            this.onlyGettingNewFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "only_new");
            this.activeConnection = rep.getJobEntryAttributeBoolean(id_jobentry, "active");
            this.controlEncoding = rep.getJobEntryAttributeString(id_jobentry, "control_encoding");
            if (this.controlEncoding == null) {
                this.controlEncoding = LEGACY_CONTROL_ENCODING;
            }
            this.movefiles = rep.getJobEntryAttributeBoolean(id_jobentry, "movefiles");
            this.movetodirectory = rep.getJobEntryAttributeString(id_jobentry, "movetodirectory");
            this.adddate = rep.getJobEntryAttributeBoolean(id_jobentry, "adddate");
            this.addtime = rep.getJobEntryAttributeBoolean(id_jobentry, "adddate");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.AddDateBeforeExtension = rep.getJobEntryAttributeBoolean(id_jobentry, "AddDateBeforeExtension");
            String addToResult = rep.getStepAttributeString(id_jobentry, "add_to_result_filenames");
            this.isaddresult = Const.isEmpty((String)addToResult) ? true : rep.getStepAttributeBoolean(id_jobentry, "add_to_result_filenames");
            this.createmovefolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createmovefolder");
            this.proxyHost = rep.getJobEntryAttributeString(id_jobentry, "proxy_host");
            this.proxyPort = rep.getJobEntryAttributeString(id_jobentry, "proxy_port");
            this.proxyUsername = rep.getJobEntryAttributeString(id_jobentry, "proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "proxy_password"));
            this.SifFileExists = rep.getJobEntryAttributeString(id_jobentry, "ifFileExists");
            this.ifFileExists = Const.isEmpty((String)this.SifFileExists) ? this.ifFileExistsSkip : (this.SifFileExists.equals(this.SifFileExistsCreateUniq) ? this.ifFileExistsCreateUniq : (this.SifFileExists.equals(this.SifFileExistsFail) ? this.ifFileExistsFail : this.ifFileExistsSkip));
            this.nr_limit = rep.getJobEntryAttributeString(id_jobentry, "nr_limit");
            this.success_condition = Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "success_condition"), (String)this.SUCCESS_IF_NO_ERRORS);
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'ftp' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getID(), "port", this.port);
            rep.saveJobEntryAttribute(id_job, this.getID(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getID(), "ftpdirectory", this.ftpDirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "targetdirectory", this.targetDirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getID(), "binary", this.binaryMode);
            rep.saveJobEntryAttribute(id_job, this.getID(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getID(), "remove", this.remove);
            rep.saveJobEntryAttribute(id_job, this.getID(), "only_new", this.onlyGettingNewFiles);
            rep.saveJobEntryAttribute(id_job, this.getID(), "active", this.activeConnection);
            rep.saveJobEntryAttribute(id_job, this.getID(), "control_encoding", this.controlEncoding);
            rep.saveJobEntryAttribute(id_job, this.getID(), "movefiles", this.movefiles);
            rep.saveJobEntryAttribute(id_job, this.getID(), "movetodirectory", this.movetodirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "addtime", this.addtime);
            rep.saveJobEntryAttribute(id_job, this.getID(), "adddate", this.adddate);
            rep.saveJobEntryAttribute(id_job, this.getID(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getID(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getID(), "AddDateBeforeExtension", this.AddDateBeforeExtension);
            rep.saveJobEntryAttribute(id_job, this.getID(), "isaddresult", this.isaddresult);
            rep.saveJobEntryAttribute(id_job, this.getID(), "createmovefolder", this.createmovefolder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_host", this.proxyHost);
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_port", this.proxyPort);
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_username", this.proxyUsername);
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_password", Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword));
            rep.saveJobEntryAttribute(id_job, this.getID(), "ifFileExists", this.SifFileExists);
            rep.saveJobEntryAttribute(id_job, this.getID(), "nr_limit", this.nr_limit);
            rep.saveJobEntryAttribute(id_job, this.getID(), "success_condition", this.success_condition);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'ftp' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setLimit(String nr_limitin) {
        this.nr_limit = nr_limitin;
    }

    public String getLimit() {
        return this.nr_limit;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public void setCreateMoveFolder(boolean createmovefolderin) {
        this.createmovefolder = createmovefolderin;
    }

    public boolean isCreateMoveFolder() {
        return this.createmovefolder;
    }

    public void setAddDateBeforeExtension(boolean AddDateBeforeExtension) {
        this.AddDateBeforeExtension = AddDateBeforeExtension;
    }

    public boolean isAddDateBeforeExtension() {
        return this.AddDateBeforeExtension;
    }

    public void setAddToResult(boolean isaddresultin) {
        this.isaddresult = isaddresultin;
    }

    public boolean isAddToResult() {
        return this.isaddresult;
    }

    public void setDateInFilename(boolean adddate) {
        this.adddate = adddate;
    }

    public boolean isDateInFilename() {
        return this.adddate;
    }

    public void setTimeInFilename(boolean addtime) {
        this.addtime = addtime;
    }

    public boolean isTimeInFilename() {
        return this.addtime;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public boolean isMoveFiles() {
        return this.movefiles;
    }

    public void setMoveFiles(boolean movefilesin) {
        this.movefiles = movefilesin;
    }

    public String getMoveToDirectory() {
        return this.movetodirectory;
    }

    public void setMoveToDirectory(String movetoin) {
        this.movetodirectory = movetoin;
    }

    public boolean isBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(boolean binaryMode) {
        this.binaryMode = binaryMode;
    }

    public String getFtpDirectory() {
        return this.ftpDirectory;
    }

    public void setFtpDirectory(String directory) {
        this.ftpDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public boolean isOnlyGettingNewFiles() {
        return this.onlyGettingNewFiles;
    }

    public void setOnlyGettingNewFiles(boolean onlyGettingNewFilesin) {
        this.onlyGettingNewFiles = onlyGettingNewFilesin;
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String encoding) {
        this.controlEncoding = encoding;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        block56: {
            log = LogWriter.getInstance();
            JobEntryFTP.log4j.info((Object)Messages.getString("JobEntryFTP.Started", this.serverName));
            result = previousResult;
            result.setNrErrors(1L);
            result.setResult(false);
            this.NrErrors = 0L;
            this.NrfilesRetrieved = 0L;
            this.successConditionBroken = false;
            exitjobentry = false;
            this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getLimit()), (int)10);
            if (this.movefiles && Const.isEmpty((String)this.movetodirectory)) {
                log.logError(this.toString(), Messages.getString("JobEntryFTP.MoveToFolderEmpty"), new Object[0]);
                return result;
            }
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.Start"), new Object[0]);
            }
            ftpclient = null;
            realMoveToFolder = null;
            try {
                ftpclient = new FTPClient();
                realServername = this.environmentSubstitute(this.serverName);
                realServerPort = this.environmentSubstitute(this.port);
                ftpclient.setRemoteAddr(InetAddress.getByName(realServername));
                if (!Const.isEmpty((String)realServerPort)) {
                    ftpclient.setRemotePort(Const.toInt((String)realServerPort, (int)21));
                }
                if (!Const.isEmpty((String)this.proxyHost)) {
                    realProxy_host = this.environmentSubstitute(this.proxyHost);
                    ftpclient.setRemoteAddr(InetAddress.getByName(realProxy_host));
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.OpenedProxyConnectionOn", realProxy_host), new Object[0]);
                    }
                    if ((port = Const.toInt((String)this.environmentSubstitute(this.proxyPort), (int)21)) != 0) {
                        ftpclient.setRemotePort(port);
                    }
                } else {
                    ftpclient.setRemoteAddr(InetAddress.getByName(realServername));
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.OpenedConnectionTo", realServername), new Object[0]);
                    }
                }
                if (this.activeConnection) {
                    ftpclient.setConnectMode(FTPConnectMode.ACTIVE);
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.SetActive"), new Object[0]);
                    }
                } else {
                    ftpclient.setConnectMode(FTPConnectMode.PASV);
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.SetPassive"), new Object[0]);
                    }
                }
                ftpclient.setTimeout(this.timeout);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.SetTimeout", String.valueOf(this.timeout)), new Object[0]);
                }
                ftpclient.setControlEncoding(this.controlEncoding);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.SetEncoding", this.controlEncoding), new Object[0]);
                }
                ftpclient.connect();
                realUsername = this.environmentSubstitute(this.userName) + (Const.isEmpty((String)this.proxyHost) == false ? "@" + realServername : "") + (Const.isEmpty((String)this.proxyUsername) == false ? " " + this.environmentSubstitute(this.proxyUsername) : "");
                realPassword = this.environmentSubstitute(this.password) + (Const.isEmpty((String)this.proxyPassword) == false ? " " + this.environmentSubstitute(this.proxyPassword) : "");
                ftpclient.login(realUsername, realPassword);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.LoggedIn", realUsername), new Object[0]);
                }
                if (!Const.isEmpty((String)this.ftpDirectory)) {
                    realFtpDirectory = this.environmentSubstitute(this.ftpDirectory);
                    realFtpDirectory = this.normalizePath(realFtpDirectory);
                    ftpclient.chdir(realFtpDirectory);
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.ChangedDir", realFtpDirectory), new Object[0]);
                    }
                }
                if (this.movefiles && !Const.isEmpty((String)this.movetodirectory)) {
                    realMoveToFolder = this.environmentSubstitute(this.movetodirectory);
                    realMoveToFolder = this.normalizePath(realMoveToFolder);
                    folderExist = true;
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.CheckMoveToFolder", realMoveToFolder), new Object[0]);
                    }
                    originalLocation = ftpclient.pwd();
                    try {
                        ftpclient.chdir(realMoveToFolder);
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.CheckMoveToFolderSwitchBack", originalLocation), new Object[0]);
                        }
                        ftpclient.chdir(originalLocation);
                    }
                    catch (Exception e) {
                        folderExist = false;
                    }
                    if (!folderExist) {
                        if (this.createmovefolder) {
                            ftpclient.mkdir(realMoveToFolder);
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.MoveToFolderCreated", realMoveToFolder), new Object[0]);
                            }
                        } else {
                            log.logError(this.toString(), Messages.getString("JobEntryFTP.MoveToFolderNotExist"), new Object[0]);
                            exitjobentry = true;
                            ++this.NrErrors;
                        }
                    }
                }
                if (!exitjobentry) {
                    ftpFiles = ftpclient.dirDetails(".");
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.FoundNFiles", String.valueOf(ftpFiles.length)), new Object[0]);
                    }
                    if (this.binaryMode) {
                        ftpclient.setType(FTPTransferType.BINARY);
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.SetBinary"), new Object[0]);
                        }
                    } else {
                        ftpclient.setType(FTPTransferType.ASCII);
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.SetAscii"), new Object[0]);
                        }
                    }
                    if (ftpFiles.length == 1 && !Const.isEmpty((String)(translatedWildcard = this.environmentSubstitute(this.wildcard))) && ftpFiles[0].getName().startsWith(translatedWildcard)) {
                        throw new FTPException(ftpFiles[0].getName());
                    }
                    pattern = null;
                    if (!Const.isEmpty((String)this.wildcard)) {
                        realWildcard = this.environmentSubstitute(this.wildcard);
                        pattern = Pattern.compile(realWildcard);
                    }
                    if (!this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS)) {
                        this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getLimit()), (int)10);
                    }
                    for (FTPFile ftpFile : ftpFiles) {
                        if (parentJob.isStopped()) {
                            exitjobentry = true;
                            throw new Exception(Messages.getString("JobEntryFTP.JobStopped"));
                        }
                        if (this.successConditionBroken) {
                            throw new Exception(Messages.getString("JobEntryFTP.SuccesConditionBroken", "" + this.NrErrors));
                        }
                        getIt = true;
                        filename = ftpFile.getName();
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobEntryFTP.AnalysingFile", filename), new Object[0]);
                        }
                        if (ftpFile.isDir() || ftpFile.isLink()) {
                            getIt = false;
                            if (log.isDebug()) {
                                log.logDebug(this.toString(), Messages.getString("JobEntryFTP.SkippingNotAFile", filename), new Object[0]);
                            }
                        }
                        if (!getIt) continue;
                        try {
                            if (pattern != null) {
                                matcher = pattern.matcher(filename);
                                getIt = matcher.matches();
                            }
                            if (!getIt) continue;
                            this.downloadFile(ftpclient, filename, realMoveToFolder, log, parentJob, result);
                        }
                        catch (Exception e) {
                            this.updateErrors();
                            log.logError(this.toString(), Messages.getString("JobFTP.UnexpectedError", e.toString()), new Object[0]);
                        }
                    }
                }
                var24_29 = null;
                if (ftpclient == null) break block56;
                ** GOTO lbl159
            }
            catch (Exception e) {
                if (!this.successConditionBroken && !exitjobentry) {
                    this.updateErrors();
                }
                log.logError(this.toString(), Messages.getString("JobEntryFTP.ErrorGetting", e.getMessage()), new Object[0]);
                var24_30 = null;
                if (ftpclient != null) {
                    try {
                        ftpclient.quit();
                    }
                    catch (Exception e) {
                        log.logError(this.toString(), Messages.getString("JobEntryFTP.ErrorQuitting", e.getMessage()), new Object[0]);
                    }
                }
                break block56;
            }
            {
                catch (Throwable var23_35) {
                    var24_31 = null;
                    if (ftpclient == null) throw var23_35;
                    ** try [egrp 4[TRYBLOCK] [6 : 1535->1543)] { 
lbl154:
                    // 1 sources

                    ftpclient.quit();
                    throw var23_35;
lbl156:
                    // 1 sources

                    catch (Exception e) {
                        log.logError(this.toString(), Messages.getString("JobEntryFTP.ErrorQuitting", e.getMessage()), new Object[0]);
                    }
                    throw var23_35;
                }
lbl159:
                // 1 sources

                ** try [egrp 4[TRYBLOCK] [6 : 1535->1543)] { 
lbl160:
                // 1 sources

                ftpclient.quit();
lbl162:
                // 1 sources

                catch (Exception e) {}
                log.logError(this.toString(), Messages.getString("JobEntryFTP.ErrorQuitting", e.getMessage()), new Object[0]);
            }
        }
        result.setNrErrors(this.NrErrors);
        result.setNrFilesRetrieved(this.NrfilesRetrieved);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        if (exitjobentry) {
            result.setResult(false);
        }
        this.displayResults(log);
        return result;
    }

    private void downloadFile(FTPClient ftpclient, String filename, String realMoveToFolder, LogWriter log, Job parentJob, Result result) throws Exception {
        String localFilename = filename;
        this.targetFilename = this.returnTargetFilename(localFilename);
        if (!this.onlyGettingNewFiles || this.onlyGettingNewFiles && this.needsDownload(this.targetFilename, log)) {
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.GettingFile", filename, this.environmentSubstitute(this.targetDirectory)), new Object[0]);
            }
            ftpclient.get(this.targetFilename, filename);
            this.updateRetrievedFiles();
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.GotFile", filename), new Object[0]);
            }
            this.addFilenameToResultFilenames(log, result, parentJob, this.targetFilename);
            if (this.remove) {
                ftpclient.delete(filename);
                if (log.isDetailed() && log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.DeletedFile", filename), new Object[0]);
                }
            } else if (this.movefiles) {
                ftpclient.rename(filename, realMoveToFolder + FILE_SEPARATOR + filename);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.MovedFile", filename, realMoveToFolder), new Object[0]);
                }
            }
        }
    }

    public String normalizePath(String path) throws Exception {
        String normalizedPath = path.replaceAll("\\\\", FILE_SEPARATOR);
        while (normalizedPath.endsWith("\\") || normalizedPath.endsWith(FILE_SEPARATOR)) {
            normalizedPath = normalizedPath.substring(0, normalizedPath.length() - 1);
        }
        return normalizedPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addFilenameToResultFilenames(LogWriter log, Result result, Job parentJob, String filename) throws KettleException {
        if (!this.isaddresult) return;
        FileObject targetFile = null;
        try {
            try {
                targetFile = KettleVFS.getFileObject((String)filename);
                ResultFile resultFile = new ResultFile(0, targetFile, parentJob.getJobname(), this.toString());
                resultFile.setComment(Messages.getString("JobEntryFTP.Downloaded", this.serverName));
                result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.FileAddedToResult", filename), new Object[0]);
                }
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                targetFile.close();
                targetFile = null;
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        targetFile.close();
        return;
    }

    private void displayResults(LogWriter log) {
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), "=======================================", new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.Log.Info.FilesInError", "" + this.NrErrors), new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobEntryFTP.Log.Info.FilesRetrieved", "" + this.NrfilesRetrieved), new Object[0]);
            log.logDetailed(this.toString(), "=======================================", new Object[0]);
        }
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0L && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrfilesRetrieved >= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED) || this.NrErrors <= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0L && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateRetrievedFiles() {
        ++this.NrfilesRetrieved;
    }

    private String returnTargetFilename(String filename) {
        String retval = null;
        if (filename == null) {
            return null;
        }
        retval = filename;
        int lenstring = retval.length();
        int lastindexOfDot = retval.lastIndexOf(".");
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        if (this.isAddDateBeforeExtension()) {
            retval = retval.substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (this.SpecifyFormat && !Const.isEmpty((String)this.date_time_format)) {
            daf.applyPattern(this.date_time_format);
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (this.adddate) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (this.addtime) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        if (this.isAddDateBeforeExtension()) {
            retval = retval + retval.substring(lastindexOfDot, lenstring);
        }
        retval = this.environmentSubstitute(this.targetDirectory) + Const.FILE_SEPARATOR + retval;
        return retval;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    protected boolean needsDownload(String filename, LogWriter log) {
        boolean retval = false;
        File file = new File(filename);
        if (!file.exists()) {
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("JobEntryFTP.LocalFileNotExists"), new Object[]{filename});
            }
            return true;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("JobEntryFTP.LocalFileExists"), new Object[]{filename});
        }
        if (this.ifFileExists == this.ifFileExistsCreateUniq) {
            int lenstring = this.targetFilename.length();
            int lastindexOfDot = this.targetFilename.lastIndexOf(46);
            if (lastindexOfDot == -1) {
                lastindexOfDot = lenstring;
            }
            this.targetFilename = this.targetFilename.substring(0, lastindexOfDot) + StringUtil.getFormattedDateTimeNow((boolean)true) + this.targetFilename.substring(lastindexOfDot, lenstring);
            return true;
        }
        if (this.ifFileExists == this.ifFileExistsFail) {
            this.updateErrors();
        }
        return retval;
    }

    public boolean isActiveConnection() {
        return this.activeConnection;
    }

    public void setActiveConnection(boolean passive) {
        this.activeConnection = passive;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "targetDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServername = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }
}

