/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepLoaderException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.job.JobEntryLoader;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.JobPlugin;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryCopy
implements Cloneable,
XMLInterface,
GUIPositionInterface,
ChangedFlagInterface {
    private JobEntryInterface entry;
    private int nr;
    private boolean selected;
    private Point location;
    private boolean launchingInParallel;
    private boolean draw;
    private long id;

    public JobEntryCopy() {
        this.clear();
    }

    public JobEntryCopy(LogWriter log) {
        this.clear();
    }

    public JobEntryCopy(LogWriter log, JobEntryInterface entry) {
        this.setEntry(entry);
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    <entry>").append(Const.CR);
        retval.append(this.entry.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"parallel", (boolean)this.launchingInParallel));
        retval.append("      ").append(XMLHandler.addTagValue((String)"draw", (boolean)this.draw));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr", (int)this.nr));
        retval.append("      ").append(XMLHandler.addTagValue((String)"xloc", (int)this.location.x));
        retval.append("      ").append(XMLHandler.addTagValue((String)"yloc", (int)this.location.y));
        retval.append("      </entry>").append(Const.CR);
        return retval.toString();
    }

    public JobEntryCopy(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            String stype = XMLHandler.getTagValue((Node)entrynode, (String)"type");
            JobPlugin jobPlugin = JobEntryLoader.getInstance().findJobEntriesWithID(stype);
            if (jobPlugin == null) {
                throw new KettleStepLoaderException("No valid step/plugin specified (jobPlugin=null) for " + stype);
            }
            this.entry = JobEntryLoader.getInstance().getJobEntryClass(jobPlugin);
            if (this.entry != null) {
                this.entry.loadXML(entrynode, databases, slaveServers, rep);
                this.setNr(Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"nr"), (int)0));
                this.setLaunchingInParallel("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"parallel")));
                this.setDrawn("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"draw")));
                int x = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"xloc"), (int)0);
                int y = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"yloc"), (int)0);
                this.setLocation(x, y);
            }
        }
        catch (Throwable e) {
            String message = "Unable to read Job Entry copy info from XML node : " + e.toString();
            LogWriter log = LogWriter.getInstance();
            log.logError(this.toString(), message, new Object[0]);
            log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
            throw new KettleXMLException(message, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JobEntryCopy(LogWriter log, Repository rep, long id_job, long id_jobentry_copy, List<JobEntryInterface> jobentries, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.setID(id_jobentry_copy);
            RowMetaAndData r = rep.getJobEntryCopy(id_jobentry_copy);
            if (r == null) return;
            long id_jobentry = r.getInteger("ID_JOBENTRY", 0L);
            long id_jobentry_type = r.getInteger("ID_JOBENTRY_TYPE", 0L);
            this.setNr((int)r.getInteger("NR", 0L));
            int locx = (int)r.getInteger("GUI_LOCATION_X", 0L);
            int locy = (int)r.getInteger("GUI_LOCATION_Y", 0L);
            boolean isdrawn = r.getBoolean("GUI_DRAW", false);
            boolean isparallel = r.getBoolean("PARALLEL", false);
            this.entry = JobMeta.findJobEntry(jobentries, id_jobentry);
            if (this.entry == null) {
                RowMetaAndData rt = rep.getJobEntryType(id_jobentry_type);
                if (rt == null) throw new KettleException("Unable to find Job Entry Type with id=" + id_jobentry_type + " in the repository");
                String jet_code = rt.getString("CODE", null);
                JobEntryLoader jobLoader = JobEntryLoader.getInstance();
                JobPlugin jobPlugin = jobLoader.findJobEntriesWithID(jet_code);
                if (jobPlugin == null) throw new KettleException("JobEntryLoader was unable to find Job Entry Plugin with description [" + jet_code + "].");
                this.entry = jobLoader.getJobEntryClass(jobPlugin);
                this.entry.loadRep(rep, id_jobentry, databases, slaveServers);
                this.entry.setID(id_jobentry);
                jobentries.add(this.entry);
            }
            this.setLocation(locx, locy);
            this.setDrawn(isdrawn);
            this.setLaunchingInParallel(isparallel);
            return;
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry copy from repository with id_jobentry_copy=" + id_jobentry_copy, (Throwable)dbe);
        }
    }

    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            long id_jobentry_type;
            long id_jobentry = rep.getJobEntryID(this.getName(), id_job);
            if (id_jobentry <= 0L) {
                this.entry.saveRep(rep, id_job);
                id_jobentry = this.entry.getID();
            }
            if ((id_jobentry_type = rep.getJobEntryTypeID(this.entry.getTypeCode())) < 0L) {
                rep.updateJobEntryTypes();
                id_jobentry_type = rep.getJobEntryTypeID(this.entry.getTypeCode());
            }
            this.setID(rep.insertJobEntryCopy(id_job, id_jobentry, id_jobentry_type, this.getNr(), this.getLocation().x, this.getLocation().y, this.isDrawn(), this.isLaunchingInParallel()));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry copy to the repository, id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void clear() {
        this.location = null;
        this.entry = null;
        this.nr = 0;
        this.launchingInParallel = false;
        this.setID(-1L);
    }

    public Object clone() {
        JobEntryCopy ge = new JobEntryCopy();
        ge.replaceMeta(this);
        ge.setID(-1L);
        return ge;
    }

    public void replaceMeta(JobEntryCopy jobEntryCopy) {
        this.entry = jobEntryCopy.entry;
        this.nr = jobEntryCopy.nr;
        this.selected = jobEntryCopy.selected;
        if (jobEntryCopy.location != null) {
            this.location = new Point(jobEntryCopy.location.x, jobEntryCopy.location.y);
        }
        this.launchingInParallel = jobEntryCopy.launchingInParallel;
        this.draw = jobEntryCopy.draw;
        this.id = jobEntryCopy.id;
    }

    public Object clone_deep() {
        JobEntryCopy ge = (JobEntryCopy)this.clone();
        ge.entry = (JobEntryInterface)this.entry.clone();
        return ge;
    }

    public void setID(long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        JobEntryCopy je = (JobEntryCopy)o;
        return je.entry.getName().equalsIgnoreCase(this.entry.getName()) && je.getNr() == this.getNr();
    }

    public long getID() {
        return this.id;
    }

    public void setEntry(JobEntryInterface je) {
        this.entry = je;
        if (this.entry != null && this.entry.getConfigId() == null) {
            this.entry.setConfigId(JobEntryLoader.getInstance().getJobEntryID(this.entry));
        }
    }

    public JobEntryInterface getEntry() {
        return this.entry;
    }

    public JobEntryType getJobEntryType() {
        return this.entry.getJobEntryType();
    }

    public String getTypeDesc() {
        if (this.getJobEntryType() == JobEntryType.NONE) {
            return this.entry.getTypeCode();
        }
        return JobEntryCopy.getTypeDesc(this.entry);
    }

    public void setLocation(int x, int y) {
        int ny;
        int nx = x >= 0 ? x : 0;
        Point loc = new Point(nx, ny = y >= 0 ? y : 0);
        if (!loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public void setLocation(Point loc) {
        if (loc != null && !loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public Point getLocation() {
        return this.location;
    }

    @Override
    public void setChanged() {
        this.setChanged(true);
    }

    @Override
    public void setChanged(boolean ch) {
        this.entry.setChanged(ch);
    }

    @Override
    public boolean hasChanged() {
        return this.entry.hasChanged();
    }

    public int getNr() {
        return this.nr;
    }

    public void setNr(int n) {
        this.nr = n;
    }

    public void setLaunchingInParallel(boolean p) {
        this.launchingInParallel = p;
    }

    public boolean isDrawn() {
        return this.draw;
    }

    public void setDrawn() {
        this.setDrawn(true);
    }

    public void setDrawn(boolean d) {
        this.draw = d;
    }

    public boolean isLaunchingInParallel() {
        return this.launchingInParallel;
    }

    public static final JobEntryType getType(String dsc) {
        if (dsc != null) {
            JobEntryType[] types;
            for (JobEntryType type : types = JobEntryType.values()) {
                if (!type.getTypeCode().equalsIgnoreCase(dsc)) continue;
                return type;
            }
            for (JobEntryType type : types) {
                if (!type.getDescription().equalsIgnoreCase(dsc)) continue;
                return type;
            }
        }
        return JobEntryType.NONE;
    }

    public static final String getTypeDesc(int ty) {
        if (ty > 0 && ty < JobEntryType.values().length) {
            return JobEntryType.values()[ty].toString();
        }
        return JobEntryType.NONE.toString();
    }

    public static final String getTypeDesc(JobEntryInterface ty) {
        return ty.getJobEntryType().toString();
    }

    public void setSelected(boolean sel) {
        this.selected = sel;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setDescription(String description) {
        this.entry.setDescription(description);
    }

    public String getDescription() {
        return this.entry.getDescription();
    }

    public boolean isStart() {
        return this.entry.isStart();
    }

    public boolean isDummy() {
        return this.entry.isDummy();
    }

    public boolean isTransformation() {
        return this.getJobEntryType() == JobEntryType.TRANS;
    }

    public boolean isJob() {
        return this.getJobEntryType() == JobEntryType.JOB;
    }

    public boolean evaluates() {
        if (this.entry != null) {
            return this.entry.evaluates();
        }
        return false;
    }

    public boolean isUnconditional() {
        if (this.entry != null) {
            return this.entry.isUnconditional();
        }
        return true;
    }

    public boolean isEvaluation() {
        return this.getJobEntryType() == JobEntryType.EVAL;
    }

    public boolean isMail() {
        return this.getJobEntryType() == JobEntryType.MAIL;
    }

    public boolean isSQL() {
        return this.getJobEntryType() == JobEntryType.MAIL;
    }

    public boolean isSpecial() {
        return this.getJobEntryType() == JobEntryType.SPECIAL;
    }

    public String toString() {
        if (this.entry != null) {
            return this.entry.getName() + "." + this.getNr();
        }
        return "null." + this.getNr();
    }

    public String getName() {
        if (this.entry != null) {
            return this.entry.getName();
        }
        return "null";
    }

    public void setName(String name) {
        this.entry.setName(name);
    }

    public boolean resetErrorsBeforeExecution() {
        return this.entry.resetErrorsBeforeExecution();
    }
}

