/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao;

import ca.sqlpower.dao.SPPersistenceException;
import java.io.InputStream;

public interface SPPersister {
    public void persistProperty(String var1, String var2, DataType var3, Object var4, Object var5) throws SPPersistenceException;

    public void persistProperty(String var1, String var2, DataType var3, Object var4) throws SPPersistenceException;

    public void persistObject(String var1, String var2, String var3, int var4) throws SPPersistenceException;

    public void removeObject(String var1, String var2) throws SPPersistenceException;

    public void begin() throws SPPersistenceException;

    public void commit() throws SPPersistenceException;

    public void rollback();

    public static enum SPPersistMethod {
        begin,
        commit,
        persistObject,
        persistProperty,
        changeProperty,
        removeObject,
        rollback;

    }

    public static enum DataType {
        STRING("String", String.class),
        INTEGER("Integer", Integer.class),
        DOUBLE("Double", Double.class),
        BOOLEAN("Boolean", Boolean.class),
        SHORT("Short", Short.class),
        LONG("Long", Long.class),
        FLOAT("Float", Float.class),
        REFERENCE("Reference", String.class),
        PNG_IMG("PNG_IMG", InputStream.class),
        NULL("Null", null);

        private final String name;
        private final Class<?> representation;

        private DataType(String name, Class<?> representation) {
            this.name = name;
            this.representation = representation;
        }

        public String getTypeName() {
            return this.name;
        }

        public Class<?> getRepresentation() {
            return this.representation;
        }

        public static DataType getTypeByClass(Class<?> lookupValue) {
            for (DataType type : DataType.values()) {
                if ((type.getRepresentation() != null || lookupValue != null) && (lookupValue == null || type.getRepresentation() == null || !type.representation.isAssignableFrom(lookupValue))) continue;
                return type;
            }
            throw new IllegalArgumentException("The class type " + lookupValue.getName() + " does not exist as a type in this DataType enum");
        }
    }
}

