/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public abstract class User
implements Serializable {
    protected String dburl = null;
    protected String ID = null;
    protected String pass;
    protected int accessLevel = 0;
    protected static String[] accessLevelNames = new String[]{"Not Logged In", "Super User", "Read Only"};
    protected Connection con = null;

    protected User(String dburl, String userid, String password) throws SQLException {
        this();
        this.dburl = dburl;
        this.ID = userid;
        this.pass = password;
        this.connectToDB();
        this.accessLevel = 1;
    }

    private User() {
    }

    private void connectToDB() throws SQLException {
        this.con = DriverManager.getConnection(this.dburl, this.ID, this.pass);
    }

    public String getID() {
        return this.ID;
    }

    public int getAccessLevel() {
        return this.accessLevel;
    }

    public void setAccessLevel(int level) throws PropertyVetoException {
        if (level >= accessLevelNames.length) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, "accessLevel", new Integer(this.accessLevel), new Integer(level));
            throw new PropertyVetoException("Invalid User Access Level", evt);
        }
        this.accessLevel = level;
    }

    public String getAccessLevelName(int level) {
        return accessLevelNames[level];
    }

    public String toHtml() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("<table border=\"1\">").append("<tr><td colspan=\"2\">User Fields</td>").append("<tr><td>ID</td><td>").append(this.getID()).append("</td></tr><tr><td>AccessLevel</td><td>").append(this.getAccessLevel()).append("</td></tr><tr><td>AccessLevelName</td><td>").append(this.getAccessLevelName(this.getAccessLevel())).append("</td></tr></table>");
        return sb.toString();
    }
}

