/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.sctp;

import com.sun.nio.sctp.SctpSocketOption;
import com.sun.nio.sctp.SctpStandardSocketOptions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.AlreadyBoundException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Net;
import sun.nio.ch.sctp.SctpStdSocketOption;
import sun.security.action.GetPropertyAction;

public class SctpNet {
    static final String osName = AccessController.doPrivileged(new GetPropertyAction("os.name"));

    private static boolean IPv4MappedAddresses() {
        return "SunOS".equals(osName);
    }

    static boolean throwAlreadyBoundException() throws IOException {
        throw new AlreadyBoundException();
    }

    static void listen(int n, int n2) throws IOException {
        SctpNet.listen0(n, n2);
    }

    static int connect(int n, InetAddress inetAddress, int n2) throws IOException {
        return SctpNet.connect0(n, inetAddress, n2);
    }

    static void close(int n) throws IOException {
        SctpNet.close0(n);
    }

    static void preClose(int n) throws IOException {
        SctpNet.preClose0(n);
    }

    static FileDescriptor socket(boolean bl) throws IOException {
        int n = SctpNet.socket0(bl);
        return IOUtil.newFD(n);
    }

    static void bindx(int n, InetAddress[] inetAddressArray, int n2, boolean bl) throws IOException {
        SctpNet.bindx(n, inetAddressArray, n2, inetAddressArray.length, bl, SctpNet.IPv4MappedAddresses());
    }

    static Set<SocketAddress> getLocalAddresses(int n) throws IOException {
        Set<SocketAddress> set = null;
        SocketAddress[] socketAddressArray = SctpNet.getLocalAddresses0(n);
        if (socketAddressArray != null) {
            set = SctpNet.getRevealedLocalAddressSet(socketAddressArray);
        }
        return set;
    }

    private static Set<SocketAddress> getRevealedLocalAddressSet(SocketAddress[] socketAddressArray) {
        SecurityManager securityManager = System.getSecurityManager();
        HashSet<SocketAddress> hashSet = new HashSet<SocketAddress>(socketAddressArray.length);
        for (SocketAddress socketAddress : socketAddressArray) {
            hashSet.add(SctpNet.getRevealedLocalAddress(socketAddress, securityManager));
        }
        return hashSet;
    }

    private static SocketAddress getRevealedLocalAddress(SocketAddress socketAddress, SecurityManager securityManager) {
        if (securityManager == null || socketAddress == null) {
            return socketAddress;
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        try {
            securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), -1);
        }
        catch (SecurityException securityException) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), inetSocketAddress.getPort());
        }
        return socketAddress;
    }

    static Set<SocketAddress> getRemoteAddresses(int n, int n2) throws IOException {
        HashSet<SocketAddress> hashSet = null;
        SocketAddress[] socketAddressArray = SctpNet.getRemoteAddresses0(n, n2);
        if (socketAddressArray != null) {
            hashSet = new HashSet<SocketAddress>(socketAddressArray.length);
            for (SocketAddress socketAddress : socketAddressArray) {
                hashSet.add(socketAddress);
            }
        }
        return hashSet;
    }

    static <T> void setSocketOption(int n, SctpSocketOption<T> sctpSocketOption, T t, int n2) throws IOException {
        if (t == null) {
            throw new IllegalArgumentException("Invalid option value");
        }
        if (sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS)) {
            SctpStandardSocketOptions.InitMaxStreams initMaxStreams = (SctpStandardSocketOptions.InitMaxStreams)t;
            SctpNet.setInitMsgOption0(n, initMaxStreams.maxInStreams(), initMaxStreams.maxOutStreams());
        } else if (sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR) || sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_SET_PEER_PRIMARY_ADDR)) {
            SocketAddress socketAddress = (SocketAddress)t;
            if (socketAddress == null) {
                throw new IllegalArgumentException("Invalid option value");
            }
            Net.checkAddress(socketAddress);
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            if (sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR)) {
                SctpNet.setPrimAddrOption0(n, n2, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            } else {
                SctpNet.setPeerPrimAddrOption0(n, n2, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), SctpNet.IPv4MappedAddresses());
            }
        } else if (sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_DISABLE_FRAGMENTS) || sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_EXPLICIT_COMPLETE) || sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_FRAGMENT_INTERLEAVE) || sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_NODELAY) || sctpSocketOption.equals(SctpStandardSocketOptions.SO_SNDBUF) || sctpSocketOption.equals(SctpStandardSocketOptions.SO_RCVBUF) || sctpSocketOption.equals(SctpStandardSocketOptions.SO_LINGER)) {
            SctpNet.setIntOption(n, sctpSocketOption, t);
        } else {
            throw new AssertionError((Object)"Unknown socket option");
        }
    }

    static Object getSocketOption(int n, SctpSocketOption<?> sctpSocketOption, int n2) throws IOException {
        if (sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_SET_PEER_PRIMARY_ADDR)) {
            throw new IllegalArgumentException("SCTP_SET_PEER_PRIMARY_ADDR cannot be retrieved");
        }
        if (sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS)) {
            int[] nArray = new int[2];
            SctpNet.getInitMsgOption0(n, nArray);
            return SctpStandardSocketOptions.InitMaxStreams.create(nArray[0], nArray[1]);
        }
        if (sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR)) {
            return SctpNet.getPrimAddrOption0(n, n2);
        }
        if (sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_DISABLE_FRAGMENTS) || sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_EXPLICIT_COMPLETE) || sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_FRAGMENT_INTERLEAVE) || sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_NODELAY) || sctpSocketOption.equals(SctpStandardSocketOptions.SO_SNDBUF) || sctpSocketOption.equals(SctpStandardSocketOptions.SO_RCVBUF) || sctpSocketOption.equals(SctpStandardSocketOptions.SO_LINGER)) {
            return SctpNet.getIntOption(n, sctpSocketOption);
        }
        throw new AssertionError((Object)"Unknown socket option");
    }

    static void setIntOption(int n, SctpSocketOption<?> sctpSocketOption, Object object) throws IOException {
        boolean bl;
        int n2;
        if (object == null) {
            throw new IllegalArgumentException("Invalid option value");
        }
        Class clazz = sctpSocketOption.type();
        if (clazz != Integer.class && clazz != Boolean.class) {
            throw new AssertionError((Object)"Should not reach here");
        }
        if (sctpSocketOption == SctpStandardSocketOptions.SO_RCVBUF || sctpSocketOption == SctpStandardSocketOptions.SO_SNDBUF) {
            n2 = (Integer)object;
            if (n2 < 0) {
                throw new IllegalArgumentException("Invalid send/receive buffer size");
            }
        } else if (sctpSocketOption == SctpStandardSocketOptions.SO_LINGER) {
            n2 = (Integer)object;
            if (n2 < 0) {
                object = -1;
            }
            if (n2 > 65535) {
                object = 65535;
            }
        } else if (sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_FRAGMENT_INTERLEAVE) && ((n2 = ((Integer)object).intValue()) < 0 || n2 > 2)) {
            throw new IllegalArgumentException("Invalid value for SCTP_FRAGMENT_INTERLEAVE");
        }
        n2 = clazz == Integer.class ? (Integer)object : ((bl = ((Boolean)object).booleanValue()) ? 1 : 0);
        SctpNet.setIntOption0(n, ((SctpStdSocketOption)sctpSocketOption).constValue(), n2);
    }

    static Object getIntOption(int n, SctpSocketOption<?> sctpSocketOption) throws IOException {
        Class clazz = sctpSocketOption.type();
        if (clazz != Integer.class && clazz != Boolean.class) {
            throw new AssertionError((Object)"Should not reach here");
        }
        if (!(sctpSocketOption instanceof SctpStdSocketOption)) {
            throw new AssertionError((Object)"Should not reach here");
        }
        int n2 = SctpNet.getIntOption0(n, ((SctpStdSocketOption)sctpSocketOption).constValue());
        if (clazz == Integer.class) {
            return n2;
        }
        return n2 == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    static void shutdown(int n, int n2) throws IOException {
        SctpNet.shutdown0(n, n2);
    }

    static FileDescriptor branch(int n, int n2) throws IOException {
        int n3 = SctpNet.branch0(n, n2);
        return IOUtil.newFD(n3);
    }

    static native int socket0(boolean var0) throws IOException;

    static native void listen0(int var0, int var1) throws IOException;

    static native int connect0(int var0, InetAddress var1, int var2) throws IOException;

    static native void close0(int var0) throws IOException;

    static native void preClose0(int var0) throws IOException;

    static native void bindx(int var0, InetAddress[] var1, int var2, int var3, boolean var4, boolean var5) throws IOException;

    static native int getIntOption0(int var0, int var1) throws IOException;

    static native void setIntOption0(int var0, int var1, int var2) throws IOException;

    static native SocketAddress[] getLocalAddresses0(int var0) throws IOException;

    static native SocketAddress[] getRemoteAddresses0(int var0, int var1) throws IOException;

    static native int branch0(int var0, int var1) throws IOException;

    static native void setPrimAddrOption0(int var0, int var1, InetAddress var2, int var3) throws IOException;

    static native void setPeerPrimAddrOption0(int var0, int var1, InetAddress var2, int var3, boolean var4) throws IOException;

    static native SocketAddress getPrimAddrOption0(int var0, int var1) throws IOException;

    static native void getInitMsgOption0(int var0, int[] var1) throws IOException;

    static native void setInitMsgOption0(int var0, int var1, int var2) throws IOException;

    static native void shutdown0(int var0, int var1);

    static native void init();

    static {
        SctpNet.init();
    }
}

