/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.LiquibaseJpaUpdaterProvider;
import org.keycloak.models.utils.KeycloakModelUtils;

public class AddRealmCodeSecret
implements CustomSqlChange {
    private String confirmationMessage;

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Generated codeSecret for realms: ");
            Connection connection = ((JdbcConnection)database.getConnection()).getWrappedConnection();
            ArrayList<UpdateStatement> statements = new ArrayList<UpdateStatement>();
            String correctedTableName = database.correctObjectName("REALM", Table.class);
            String correctedSchemaName = database.escapeObjectName(database.getDefaultSchemaName(), Schema.class);
            if (SnapshotGeneratorFactory.getInstance().has((DatabaseObject)new Table().setName(correctedTableName), database)) {
                try (Statement st = connection.createStatement();
                     ResultSet resultSet = st.executeQuery("SELECT ID FROM " + LiquibaseJpaUpdaterProvider.getTable(correctedTableName, correctedSchemaName) + " WHERE CODE_SECRET IS NULL");){
                    while (resultSet.next()) {
                        String id = resultSet.getString(1);
                        UpdateStatement statement = new UpdateStatement(null, null, correctedTableName).addNewColumnValue("CODE_SECRET", (Object)KeycloakModelUtils.generateCodeSecret()).setWhereClause("ID=?").addWhereParameters(new Object[]{id});
                        statements.add(statement);
                        if (!resultSet.isFirst()) {
                            sb.append(", ");
                        }
                        sb.append(id);
                    }
                    if (!statements.isEmpty()) {
                        this.confirmationMessage = sb.toString();
                    }
                }
            }
            return statements.toArray(new SqlStatement[statements.size()]);
        }
        catch (Exception e) {
            throw new CustomChangeException("Failed to add realm code secret", (Throwable)e);
        }
    }

    public String getConfirmationMessage() {
        return this.confirmationMessage;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

