/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import org.eclipse.lsp4j.jsonrpc.json.adapters.JsonElementTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.TypeUtils;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.lsp4j.jsonrpc.messages.Tuple;

public class EitherTypeAdapter<L, R>
extends TypeAdapter<Either<L, R>> {
    protected final TypeToken<? extends Either<L, R>> typeToken;
    protected final EitherTypeArgument<L> left;
    protected final EitherTypeArgument<R> right;
    protected final Predicate<JsonElement> leftChecker;
    protected final Predicate<JsonElement> rightChecker;

    public EitherTypeAdapter(Gson gson, TypeToken<? extends Either<L, R>> typeToken) {
        this(gson, typeToken, null, null);
    }

    public EitherTypeAdapter(Gson gson, TypeToken<? extends Either<L, R>> typeToken, Predicate<JsonElement> leftChecker, Predicate<JsonElement> rightChecker) {
        this(gson, typeToken, leftChecker, rightChecker, null, null);
    }

    public EitherTypeAdapter(Gson gson, TypeToken<? extends Either<L, R>> typeToken, Predicate<JsonElement> leftChecker, Predicate<JsonElement> rightChecker, TypeAdapter<L> leftAdapter, TypeAdapter<R> rightAdapter) {
        this.typeToken = typeToken;
        Type[] elementTypes = TypeUtils.getElementTypes(typeToken, Either.class);
        this.left = new EitherTypeArgument<L>(gson, elementTypes[0], leftAdapter);
        this.right = new EitherTypeArgument<R>(gson, elementTypes[1], rightAdapter);
        this.leftChecker = leftChecker;
        this.rightChecker = rightChecker;
    }

    public void write(JsonWriter out, Either<L, R> value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else if (value.isLeft()) {
            this.left.write(out, value.getLeft());
        } else {
            this.right.write(out, value.getRight());
        }
    }

    public Either<L, R> read(JsonReader in) throws IOException {
        JsonToken next = in.peek();
        if (next == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return this.create(next, in);
    }

    protected Either<L, R> create(JsonToken nextToken, JsonReader in) throws IOException {
        boolean matchesLeft = this.left.isAssignable(nextToken);
        boolean matchesRight = this.right.isAssignable(nextToken);
        if (matchesLeft && matchesRight) {
            if (this.leftChecker != null || this.rightChecker != null) {
                JsonElement element = JsonParser.parseReader((JsonReader)in);
                if (this.leftChecker != null && this.leftChecker.test(element)) {
                    return this.createLeft(this.left.read(element));
                }
                if (this.rightChecker != null && this.rightChecker.test(element)) {
                    return this.createRight(this.right.read(element));
                }
            }
            throw new JsonParseException("Ambiguous Either type: token " + nextToken + " matches both alternatives.");
        }
        if (matchesLeft) {
            return this.createLeft(this.left.read(in));
        }
        if (matchesRight) {
            return this.createRight(this.right.read(in));
        }
        if (this.leftChecker != null || this.rightChecker != null) {
            JsonElement element = JsonParser.parseReader((JsonReader)in);
            if (this.leftChecker != null && this.leftChecker.test(element)) {
                return this.createLeft(this.left.read(element));
            }
            if (this.rightChecker != null && this.rightChecker.test(element)) {
                return this.createRight(this.right.read(element));
            }
        }
        throw new JsonParseException("Unexpected token " + nextToken + ": expected " + this.left + " | " + this.right + " tokens.");
    }

    protected Either<L, R> createLeft(L obj) throws IOException {
        if (Either3.class.isAssignableFrom(this.typeToken.getRawType())) {
            return Either3.forLeft3(obj);
        }
        return Either.forLeft(obj);
    }

    protected Either<L, R> createRight(R obj) throws IOException {
        if (Either3.class.isAssignableFrom(this.typeToken.getRawType())) {
            return Either3.forRight3((Either)obj);
        }
        return Either.forRight(obj);
    }

    protected static class EitherTypeArgument<T> {
        protected final TypeToken<T> typeToken;
        protected final TypeAdapter<T> adapter;
        protected final Collection<JsonToken> expectedTokens;

        public EitherTypeArgument(Gson gson, Type type) {
            this(gson, type, null);
        }

        public EitherTypeArgument(Gson gson, Type type, TypeAdapter<T> adapter) {
            this.typeToken = TypeToken.get((Type)type);
            this.adapter = adapter != null ? adapter : (type == Object.class ? new JsonElementTypeAdapter(gson) : gson.getAdapter(this.typeToken));
            this.expectedTokens = new HashSet<JsonToken>();
            for (Type expectedType : TypeUtils.getExpectedTypes(type)) {
                Class rawType = TypeToken.get((Type)expectedType).getRawType();
                JsonToken expectedToken = this.getExpectedToken(rawType);
                this.expectedTokens.add(expectedToken);
            }
        }

        protected JsonToken getExpectedToken(Class<?> rawType) {
            if (rawType.isArray() || Collection.class.isAssignableFrom(rawType) || Tuple.class.isAssignableFrom(rawType)) {
                return JsonToken.BEGIN_ARRAY;
            }
            if (Boolean.class.isAssignableFrom(rawType)) {
                return JsonToken.BOOLEAN;
            }
            if (Number.class.isAssignableFrom(rawType) || Enum.class.isAssignableFrom(rawType)) {
                return JsonToken.NUMBER;
            }
            if (Character.class.isAssignableFrom(rawType) || String.class.isAssignableFrom(rawType)) {
                return JsonToken.STRING;
            }
            return JsonToken.BEGIN_OBJECT;
        }

        public boolean isAssignable(JsonToken jsonToken) {
            return this.expectedTokens.contains(jsonToken);
        }

        public void write(JsonWriter out, T value) throws IOException {
            this.adapter.write(out, value);
        }

        public T read(JsonReader in) throws IOException {
            return (T)this.adapter.read(in);
        }

        public T read(JsonElement element) throws IOException {
            return (T)this.adapter.fromJsonTree(element);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (JsonToken expectedToken : this.expectedTokens) {
                if (builder.length() != 0) {
                    builder.append(" | ");
                }
                builder.append(expectedToken);
            }
            return builder.toString();
        }
    }

    public static class ListChecker
    implements Predicate<JsonElement> {
        private final Predicate<JsonElement> elementChecker;
        private final boolean resultIfEmpty;

        public ListChecker(Predicate<JsonElement> elementChecker) {
            this(elementChecker, false);
        }

        public ListChecker(Predicate<JsonElement> elementChecker, boolean resultIfEmpty) {
            this.elementChecker = elementChecker;
            this.resultIfEmpty = resultIfEmpty;
        }

        @Override
        public boolean test(JsonElement t) {
            if (this.elementChecker.test(t)) {
                return true;
            }
            if (t.isJsonArray()) {
                JsonArray array = t.getAsJsonArray();
                if (array.size() == 0) {
                    return this.resultIfEmpty;
                }
                for (JsonElement e : array) {
                    if (!this.elementChecker.test(e)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class PropertyChecker
    implements Predicate<JsonElement> {
        private final String propertyName;
        private final String expectedValue;
        private final Class<? extends JsonElement> expectedType;

        public PropertyChecker(String propertyName) {
            this.propertyName = propertyName;
            this.expectedValue = null;
            this.expectedType = null;
        }

        public PropertyChecker(String propertyName, String expectedValue) {
            this.propertyName = propertyName;
            this.expectedValue = expectedValue;
            this.expectedType = null;
        }

        public PropertyChecker(String propertyName, Class<? extends JsonElement> expectedType) {
            this.propertyName = propertyName;
            this.expectedType = expectedType;
            this.expectedValue = null;
        }

        @Override
        public boolean test(JsonElement element) {
            if (element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                JsonElement value = object.get(this.propertyName);
                if (this.expectedValue != null) {
                    return value != null && value.isJsonPrimitive() && this.expectedValue.equals(value.getAsString());
                }
                if (this.expectedType != null) {
                    return this.expectedType.isInstance(value);
                }
                return value != null;
            }
            return false;
        }
    }

    public static class Factory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!TypeUtils.isEither(typeToken.getType())) {
                return null;
            }
            return new EitherTypeAdapter(gson, typeToken);
        }
    }
}

