/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class JvmThreadDeadlockMetrics
implements MeterBinder {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(JvmThreadDeadlockMetrics.class);
    private final Iterable<Tag> tags;

    public JvmThreadDeadlockMetrics() {
        this(Collections.emptyList());
    }

    public JvmThreadDeadlockMetrics(Iterable<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        if (threadBean.isSynchronizerUsageSupported()) {
            Gauge.builder("jvm.threads.deadlocked", threadBean, JvmThreadDeadlockMetrics::getDeadlockedThreadCount).tags(this.tags).description("The current number of threads that are deadlocked").baseUnit("threads").register(registry);
        } else {
            log.warn("jvm.threads.deadlocked is not available on this JVM");
        }
        Gauge.builder("jvm.threads.deadlocked.monitor", threadBean, JvmThreadDeadlockMetrics::getDeadlockedMonitorThreadCount).tags(this.tags).description("The current number of threads that are deadlocked on object monitors").baseUnit("threads").register(registry);
    }

    static long getDeadlockedThreadCount(ThreadMXBean threadBean) {
        long[] deadlockedThreads = threadBean.findDeadlockedThreads();
        return deadlockedThreads == null ? 0L : (long)deadlockedThreads.length;
    }

    static long getDeadlockedMonitorThreadCount(ThreadMXBean threadBean) {
        long[] monitorDeadlockedThreads = threadBean.findMonitorDeadlockedThreads();
        return monitorDeadlockedThreads == null ? 0L : (long)monitorDeadlockedThreads.length;
    }
}

