/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import java.math.BigInteger;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range$BigInt$;
import scala.math.BigDecimal;
import scala.math.BigInt$;
import scala.math.Ordered;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericAnyConversions;
import scala.math.ScalaNumericConversions;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;
import scala.util.Random;

public final class BigInt
extends ScalaNumber
implements ScalaNumericConversions,
Ordered<BigInt> {
    private BigInteger _bigInteger;
    private final long _long;

    public static BigInt apply(BigInteger bigInteger) {
        return BigInt$.MODULE$.apply(bigInteger);
    }

    public static BigInt apply(byte[] byArray) {
        return BigInt$.MODULE$.apply(byArray);
    }

    public static BigInt apply(int n) {
        return BigInt$.MODULE$.apply(n);
    }

    public static BigInt apply(int n, byte[] byArray) {
        return BigInt$.MODULE$.apply(n, byArray);
    }

    public static BigInt apply(int n, int n2, Random random) {
        return BigInt$.MODULE$.apply(n, n2, random);
    }

    public static BigInt apply(int n, Random random) {
        return BigInt$.MODULE$.apply(n, random);
    }

    public static BigInt apply(long l) {
        return BigInt$.MODULE$.apply(l);
    }

    public static BigInt apply(String string2) {
        return BigInt$.MODULE$.apply(string2);
    }

    public static BigInt apply(String string2, int n) {
        return BigInt$.MODULE$.apply(string2, n);
    }

    public static BigInt int2bigInt(int n) {
        return BigInt$.MODULE$.int2bigInt(n);
    }

    public static BigInt javaBigInteger2bigInt(BigInteger bigInteger) {
        return BigInt$.MODULE$.javaBigInteger2bigInt(bigInteger);
    }

    public static BigInt long2bigInt(long l) {
        return BigInt$.MODULE$.long2bigInt(l);
    }

    public static BigInt probablePrime(int n, Random random) {
        return BigInt$.MODULE$.probablePrime(n, random);
    }

    public BigInt(BigInteger _bigInteger, long _long) {
        this._bigInteger = _bigInteger;
        this._long = _long;
        ScalaNumericAnyConversions.$init$(this);
        Ordered.$init$(this);
    }

    @Override
    public char toChar() {
        return ScalaNumericAnyConversions.toChar$(this);
    }

    @Override
    public byte toByte() {
        return ScalaNumericAnyConversions.toByte$(this);
    }

    @Override
    public short toShort() {
        return ScalaNumericAnyConversions.toShort$(this);
    }

    @Override
    public int toInt() {
        return ScalaNumericAnyConversions.toInt$(this);
    }

    @Override
    public long toLong() {
        return ScalaNumericAnyConversions.toLong$(this);
    }

    @Override
    public float toFloat() {
        return ScalaNumericAnyConversions.toFloat$(this);
    }

    @Override
    public double toDouble() {
        return ScalaNumericAnyConversions.toDouble$(this);
    }

    @Override
    public int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
    }

    @Override
    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, x);
    }

    @Override
    public boolean $less(Object that) {
        return Ordered.$less$(this, that);
    }

    @Override
    public boolean $greater(Object that) {
        return Ordered.$greater$(this, that);
    }

    @Override
    public boolean $less$eq(Object that) {
        return Ordered.$less$eq$(this, that);
    }

    @Override
    public boolean $greater$eq(Object that) {
        return Ordered.$greater$eq$(this, that);
    }

    @Override
    public int compareTo(Object that) {
        return Ordered.compareTo$(this, that);
    }

    private BigInteger _bigInteger() {
        return this._bigInteger;
    }

    private void _bigInteger_$eq(BigInteger x$0) {
        this._bigInteger = x$0;
    }

    private long _long() {
        return this._long;
    }

    public BigInt(BigInteger bigInteger) {
        this(bigInteger, bigInteger.bitLength() <= 63 ? bigInteger.longValue() : Long.MIN_VALUE);
    }

    private boolean longEncoding() {
        return this._long() != Long.MIN_VALUE;
    }

    public BigInteger bigInteger() {
        BigInteger read = this._bigInteger();
        if (!(read == null)) {
            return read;
        }
        BigInteger write = BigInteger.valueOf(this._long());
        this._bigInteger_$eq(write);
        return write;
    }

    public int hashCode() {
        if (this.isValidLong()) {
            return this.unifiedPrimitiveHashcode();
        }
        return Statics.anyHash(this.bigInteger());
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof BigInt) {
            BigInt bigInt;
            BigInt that2 = bigInt = (BigInt)object;
            return this.equals(that2);
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal;
            BigDecimal that3 = bigDecimal = (BigDecimal)object;
            return that3.equals(this);
        }
        if (object instanceof Double) {
            double d;
            double that4 = d = BoxesRunTime.unboxToDouble(object);
            return this.isValidDouble() && this.toDouble() == that4;
        }
        if (object instanceof Float) {
            float f;
            float that5 = f = BoxesRunTime.unboxToFloat(object);
            return this.isValidFloat() && this.toFloat() == that5;
        }
        Object x = object;
        return this.isValidLong() && this.unifiedPrimitiveEquals(x);
    }

    @Override
    public boolean isValidByte() {
        return this._long() >= (long)-128 && this._long() <= (long)127;
    }

    @Override
    public boolean isValidShort() {
        return this._long() >= (long)Short.MIN_VALUE && this._long() <= (long)Short.MAX_VALUE;
    }

    @Override
    public boolean isValidChar() {
        return this._long() >= (long)0 && this._long() <= (long)65535;
    }

    @Override
    public boolean isValidInt() {
        return this._long() >= Integer.MIN_VALUE && this._long() <= Integer.MAX_VALUE;
    }

    public boolean isValidLong() {
        return this.longEncoding() || BoxesRunTime.equals(this._bigInteger(), BigInt$.scala$math$BigInt$$$longMinValueBigInteger);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidFloat() {
        int bitLen = this.bitLength();
        if (bitLen > 24) {
            int lowest = this.lowestSetBit();
            if (bitLen > 128) return false;
            if (lowest < bitLen - 24) return false;
            if (lowest >= 128) return false;
        }
        if (this.bitLengthOverflow()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidDouble() {
        int bitLen = this.bitLength();
        if (bitLen > 53) {
            int lowest = this.lowestSetBit();
            if (bitLen > 1024) return false;
            if (lowest < bitLen - 53) return false;
            if (lowest >= 1024) return false;
        }
        if (this.bitLengthOverflow()) return false;
        return true;
    }

    private boolean bitLengthOverflow() {
        BigInteger shifted = this.bigInteger().shiftRight(Integer.MAX_VALUE);
        return shifted.signum() != 0 && !shifted.equals(BigInt$.scala$math$BigInt$$$minusOne);
    }

    @Override
    public boolean isWhole() {
        return true;
    }

    @Override
    public BigInteger underlying() {
        return this.bigInteger();
    }

    public boolean equals(BigInt that) {
        if (this.longEncoding()) {
            return that.longEncoding() && this._long() == that._long();
        }
        return !that.longEncoding() && BoxesRunTime.equals(this._bigInteger(), that._bigInteger());
    }

    @Override
    public int compare(BigInt that) {
        if (this.longEncoding()) {
            if (that.longEncoding()) {
                return Long.compare(this._long(), that._long());
            }
            BigInteger x$proxy2 = that._bigInteger();
            if (x$proxy2 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return -x$proxy2.signum();
        }
        if (that.longEncoding()) {
            BigInteger x$proxy3 = this._bigInteger();
            if (x$proxy3 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy3.signum();
        }
        BigInteger x$proxy4 = this._bigInteger();
        if (x$proxy4 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        return x$proxy4.compareTo(that._bigInteger());
    }

    public BigInt $plus(BigInt that) {
        long z;
        long y;
        long x;
        if (this.longEncoding() && that.longEncoding() && (((x = this._long()) ^ (y = that._long()) ^ 0xFFFFFFFFFFFFFFFFL) & (x ^ (z = x + y))) >= 0L) {
            return BigInt$.MODULE$.apply(z);
        }
        return BigInt$.MODULE$.apply(this.bigInteger().add(that.bigInteger()));
    }

    public BigInt $minus(BigInt that) {
        long z;
        long y;
        long x;
        if (this.longEncoding() && that.longEncoding() && (((x = this._long()) ^ (y = that._long())) & (x ^ (z = x - y))) >= 0L) {
            return BigInt$.MODULE$.apply(z);
        }
        return BigInt$.MODULE$.apply(this.bigInteger().subtract(that.bigInteger()));
    }

    public BigInt $times(BigInt that) {
        if (this.longEncoding() && that.longEncoding()) {
            long x = this._long();
            long y = that._long();
            long z = x * y;
            if (x == 0L || y == z / x) {
                return BigInt$.MODULE$.apply(z);
            }
        }
        return BigInt$.MODULE$.apply(this.bigInteger().multiply(that.bigInteger()));
    }

    public BigInt $div(BigInt that) {
        if (this.longEncoding() && that.longEncoding()) {
            return BigInt$.MODULE$.apply(this._long() / that._long());
        }
        return BigInt$.MODULE$.apply(this.bigInteger().divide(that.bigInteger()));
    }

    public BigInt $percent(BigInt that) {
        if (this.longEncoding() && that.longEncoding()) {
            return BigInt$.MODULE$.apply(this._long() % that._long());
        }
        return BigInt$.MODULE$.apply(this.bigInteger().remainder(that.bigInteger()));
    }

    public Tuple2<BigInt, BigInt> $div$percent(BigInt that) {
        if (this.longEncoding() && that.longEncoding()) {
            long x = this._long();
            long y = that._long();
            return Tuple2$.MODULE$.apply(BigInt$.MODULE$.apply(x / y), BigInt$.MODULE$.apply(x % y));
        }
        BigInteger[] dr = this.bigInteger().divideAndRemainder(that.bigInteger());
        return Tuple2$.MODULE$.apply(BigInt$.MODULE$.apply(dr[0]), BigInt$.MODULE$.apply(dr[1]));
    }

    public BigInt $less$less(int n) {
        if (this.longEncoding() && n <= 0) {
            return this.$greater$greater(-n);
        }
        return BigInt$.MODULE$.apply(this.bigInteger().shiftLeft(n));
    }

    public BigInt $greater$greater(int n) {
        if (this.longEncoding() && n >= 0) {
            if (n < 64) {
                return BigInt$.MODULE$.apply(this._long() >> n);
            }
            if (this._long() < 0L) {
                return BigInt$.MODULE$.apply(-1);
            }
            return BigInt$.MODULE$.apply(0);
        }
        return BigInt$.MODULE$.apply(this.bigInteger().shiftRight(n));
    }

    public BigInt $amp(BigInt that) {
        if (this.longEncoding() && that.longEncoding()) {
            return BigInt$.MODULE$.apply(this._long() & that._long());
        }
        return BigInt$.MODULE$.apply(this.bigInteger().and(that.bigInteger()));
    }

    public BigInt $bar(BigInt that) {
        if (this.longEncoding() && that.longEncoding()) {
            return BigInt$.MODULE$.apply(this._long() | that._long());
        }
        return BigInt$.MODULE$.apply(this.bigInteger().or(that.bigInteger()));
    }

    public BigInt $up(BigInt that) {
        if (this.longEncoding() && that.longEncoding()) {
            return BigInt$.MODULE$.apply(this._long() ^ that._long());
        }
        return BigInt$.MODULE$.apply(this.bigInteger().xor(that.bigInteger()));
    }

    public BigInt $amp$tilde(BigInt that) {
        if (this.longEncoding() && that.longEncoding()) {
            return BigInt$.MODULE$.apply(this._long() & (that._long() ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return BigInt$.MODULE$.apply(this.bigInteger().andNot(that.bigInteger()));
    }

    public BigInt gcd(BigInt that) {
        while (this_.longEncoding()) {
            if (this_._long() == 0L) {
                return that.abs();
            }
            if (that.longEncoding()) {
                if (that._long() == 0L) {
                    return this_.abs();
                }
                return BigInt$.MODULE$.apply(BigInt$.MODULE$.scala$math$BigInt$$$longGcd(RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(this_._long())), RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(that._long()))));
            }
            BigInt bigInt = that;
            BigInt bigInt2 = this_;
            BigInt this_ = bigInt;
            that = bigInt2;
        }
        if (that.longEncoding()) {
            if (that._long() == 0L) {
                return this_.abs();
            }
            BigInteger x$proxy5 = this_._bigInteger();
            if (x$proxy5 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            long red = x$proxy5.mod(BigInteger.valueOf(RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(that._long())))).longValue();
            if (red == 0L) {
                return that.abs();
            }
            return BigInt$.MODULE$.apply(BigInt$.MODULE$.scala$math$BigInt$$$longGcd(RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(that._long())), red));
        }
        return BigInt$.MODULE$.apply(this_.bigInteger().gcd(that.bigInteger()));
    }

    public BigInt mod(BigInt that) {
        if (this.longEncoding() && that.longEncoding() && that._long() > 0L) {
            long res = this._long() % that._long();
            if (res >= 0L) {
                return BigInt$.MODULE$.apply(res);
            }
            return BigInt$.MODULE$.apply(res + that._long());
        }
        return BigInt$.MODULE$.apply(this.bigInteger().mod(that.bigInteger()));
    }

    public BigInt min(BigInt that) {
        if (this.$less$eq(that)) {
            return this;
        }
        return that;
    }

    public BigInt max(BigInt that) {
        if (this.$greater$eq(that)) {
            return this;
        }
        return that;
    }

    public BigInt pow(int exp) {
        return BigInt$.MODULE$.apply(this.bigInteger().pow(exp));
    }

    public BigInt modPow(BigInt exp, BigInt m) {
        return BigInt$.MODULE$.apply(this.bigInteger().modPow(exp.bigInteger(), m.bigInteger()));
    }

    public BigInt modInverse(BigInt m) {
        return BigInt$.MODULE$.apply(this.bigInteger().modInverse(m.bigInteger()));
    }

    public BigInt unary_$minus() {
        if (this.longEncoding()) {
            return BigInt$.MODULE$.apply(-this._long());
        }
        return BigInt$.MODULE$.apply(this.bigInteger().negate());
    }

    public BigInt abs() {
        if (this.signum() < 0) {
            return this.unary_$minus();
        }
        return this;
    }

    public int signum() {
        if (this.longEncoding()) {
            return Long.signum(this._long());
        }
        BigInteger x$proxy6 = this._bigInteger();
        if (x$proxy6 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        return x$proxy6.signum();
    }

    public BigInt sign() {
        return BigInt$.MODULE$.apply(this.signum());
    }

    public BigInt unary_$tilde() {
        if (this.longEncoding() && this._long() != Long.MAX_VALUE) {
            return BigInt$.MODULE$.apply(-(this._long() + 1L));
        }
        return BigInt$.MODULE$.apply(this.bigInteger().not());
    }

    public boolean testBit(int n) {
        if (this.longEncoding() && n >= 0) {
            if (n <= 63) {
                return (this._long() & 1L << n) != 0L;
            }
            return this._long() < 0L;
        }
        return this.bigInteger().testBit(n);
    }

    public BigInt setBit(int n) {
        if (this.longEncoding() && n <= 62 && n >= 0) {
            return BigInt$.MODULE$.apply(this._long() | 1L << n);
        }
        return BigInt$.MODULE$.apply(this.bigInteger().setBit(n));
    }

    public BigInt clearBit(int n) {
        if (this.longEncoding() && n <= 62 && n >= 0) {
            return BigInt$.MODULE$.apply(this._long() & (1L << n ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return BigInt$.MODULE$.apply(this.bigInteger().clearBit(n));
    }

    public BigInt flipBit(int n) {
        if (this.longEncoding() && n <= 62 && n >= 0) {
            return BigInt$.MODULE$.apply(this._long() ^ 1L << n);
        }
        return BigInt$.MODULE$.apply(this.bigInteger().flipBit(n));
    }

    public int lowestSetBit() {
        if (this.longEncoding()) {
            if (this._long() == 0L) {
                return -1;
            }
            return Long.numberOfTrailingZeros(this._long());
        }
        return this.bigInteger().getLowestSetBit();
    }

    public int bitLength() {
        if (this.longEncoding()) {
            if (this._long() < 0L) {
                return 64 - Long.numberOfLeadingZeros(-(this._long() + 1L));
            }
            return 64 - Long.numberOfLeadingZeros(this._long());
        }
        BigInteger x$proxy7 = this._bigInteger();
        if (x$proxy7 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        return x$proxy7.bitLength();
    }

    public int bitCount() {
        if (this.longEncoding()) {
            if (this._long() < 0L) {
                return Long.bitCount(-(this._long() + 1L));
            }
            return Long.bitCount(this._long());
        }
        return this.bigInteger().bitCount();
    }

    public boolean isProbablePrime(int certainty) {
        return this.bigInteger().isProbablePrime(certainty);
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    public char charValue() {
        return (char)this.intValue();
    }

    @Override
    public int intValue() {
        if (this.longEncoding()) {
            return (int)this._long();
        }
        return this.bigInteger().intValue();
    }

    @Override
    public long longValue() {
        if (this.longEncoding()) {
            return this._long();
        }
        BigInteger x$proxy8 = this._bigInteger();
        if (x$proxy8 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        return x$proxy8.longValue();
    }

    @Override
    public float floatValue() {
        return this.bigInteger().floatValue();
    }

    @Override
    public double doubleValue() {
        if (this.isValidLong() && -9007199254740992L <= this._long() && this._long() <= 0x20000000000000L) {
            return this._long();
        }
        return this.bigInteger().doubleValue();
    }

    public NumericRange.Exclusive<BigInt> until(BigInt end, BigInt step) {
        package$.MODULE$.Range();
        return Range$BigInt$.MODULE$.apply(this, end, step);
    }

    public BigInt until$default$2() {
        return BigInt$.MODULE$.apply(1);
    }

    public NumericRange.Inclusive<BigInt> to(BigInt end, BigInt step) {
        package$.MODULE$.Range();
        return Range$BigInt$.MODULE$.inclusive(this, end, step);
    }

    public BigInt to$default$2() {
        return BigInt$.MODULE$.apply(1);
    }

    public String toString() {
        if (this.longEncoding()) {
            return BoxesRunTime.boxToLong(this._long()).toString();
        }
        return this._bigInteger().toString();
    }

    public String toString(int radix) {
        return this.bigInteger().toString(radix);
    }

    public byte[] toByteArray() {
        return this.bigInteger().toByteArray();
    }
}

