/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.service.event.RegistrationEvent;
import org.codehaus.xfire.service.event.RegistrationEventListener;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private Map name2service = new HashMap();
    private Map qname2service = new HashMap();
    private List eventListeners = new ArrayList();

    public Service getService(String name) {
        return (Service)this.name2service.get(name);
    }

    public Service getService(QName name) {
        return (Service)this.qname2service.get(name);
    }

    public void register(Service endpoint) {
        this.name2service.put(endpoint.getSimpleName(), endpoint);
        this.qname2service.put(endpoint.getName(), endpoint);
        Iterator iterator = this.eventListeners.iterator();
        while (iterator.hasNext()) {
            RegistrationEventListener listener = (RegistrationEventListener)iterator.next();
            RegistrationEvent event = new RegistrationEvent(this, endpoint);
            listener.endpointRegistered(event);
        }
    }

    public void unregister(Service endpoint) {
        Iterator iterator = this.eventListeners.iterator();
        while (iterator.hasNext()) {
            RegistrationEventListener listener = (RegistrationEventListener)iterator.next();
            RegistrationEvent event = new RegistrationEvent(this, endpoint);
            listener.endpointUnregistered(event);
        }
        if (this.name2service.containsValue(endpoint)) {
            this.name2service.remove(endpoint.getSimpleName());
        }
        if (this.qname2service.containsValue(endpoint)) {
            this.qname2service.remove(endpoint.getName());
        }
    }

    public boolean hasService(String name) {
        return this.name2service.containsKey(name);
    }

    public boolean hasService(QName name) {
        return this.qname2service.containsKey(name);
    }

    public Collection getServices() {
        return Collections.unmodifiableCollection(this.qname2service.values());
    }

    public void addRegistrationEventListener(RegistrationEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeRegistrationEventListener(RegistrationEventListener listener) {
        this.eventListeners.remove(listener);
    }
}

