/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.FreeColTestUtils;

public class ServerColonyTest
extends FreeColTestCase {
    private static final BuildingType chapelType = ServerColonyTest.spec().getBuildingType("model.building.chapel");
    private static final BuildingType carpenterHouseType = ServerColonyTest.spec().getBuildingType("model.building.carpenterHouse");
    private static final BuildingType depotType = ServerColonyTest.spec().getBuildingType("model.building.depot");
    private static final BuildingType lumberMillType = ServerColonyTest.spec().getBuildingType("model.building.lumberMill");
    private static final BuildingType townHallType = ServerColonyTest.spec().getBuildingType("model.building.townHall");
    private static final BuildingType warehouseType = ServerColonyTest.spec().getBuildingType("model.building.warehouse");
    private static final GoodsType bellsType = ServerColonyTest.spec().getGoodsType("model.goods.bells");
    private static final GoodsType crossesType = ServerColonyTest.spec().getGoodsType("model.goods.crosses");
    private static final GoodsType grainType = ServerColonyTest.spec().getGoodsType("model.goods.grain");
    private static final GoodsType hammerGoodsType = ServerColonyTest.spec().getGoodsType("model.goods.hammers");
    private static final GoodsType lumberGoodsType = ServerColonyTest.spec().getGoodsType("model.goods.lumber");
    private static final GoodsType foodType = ServerColonyTest.spec().getGoodsType("model.goods.food");
    private static final GoodsType foodGoodsType = ServerColonyTest.spec().getPrimaryFoodType();
    private static final ResourceType lumberResource = ServerColonyTest.spec().getResourceType("model.resource.lumber");
    private static final TileType coniferForest = ServerColonyTest.spec().getTileType("model.tile.coniferForest");
    private static final TileType desert = ServerColonyTest.spec().getTileType("model.tile.desert");
    private static final TileType marsh = ServerColonyTest.spec().getTileType("model.tile.marsh");
    private static final TileType plains = ServerColonyTest.spec().getTileType("model.tile.plains");
    private static final UnitType colonistType = ServerColonyTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType expertLumberJack = ServerColonyTest.spec().getUnitType("model.unit.expertLumberJack");
    private static final UnitType pioneerType = ServerColonyTest.spec().getUnitType("model.unit.hardyPioneer");

    public void testFoodConsumption() {
        ServerGame game = ServerTestHelper.startServerGame(ServerColonyTest.getTestMap(plains));
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Colony colony = FreeColTestUtils.getColonyBuilder().colonyTile(game.getMap().getTile(5, 8)).build();
        new ServerUnit(game, colony.getWorkLocationForProducing(bellsType), dutch, colonistType);
        ServerColonyTest.assertEquals((int)0, (int)colony.getGoodsCount(foodType));
        int quantity = colony.getFoodConsumption() * 2;
        colony.addGoods(foodGoodsType, quantity);
        int foodStored = colony.getGoodsCount(foodGoodsType);
        ServerColonyTest.assertEquals((int)quantity, (int)foodStored);
        int foodExpected = foodStored - colony.getFoodConsumption() + colony.getFoodProduction();
        ServerTestHelper.newTurn();
        ServerColonyTest.assertEquals((String)"Unexpected value for remaining food, ", (int)foodExpected, (int)colony.getGoodsCount(foodGoodsType));
    }

    public void testEqualFoodProductionConsumptionCase() {
        ServerGame game = ServerTestHelper.startServerGame(ServerColonyTest.getTestMap(coniferForest));
        Tile colonyTile = game.getMap().getTile(5, 8);
        Colony colony = FreeColTestUtils.getColonyBuilder().colonyTile(colonyTile).initialColonists(1).build();
        AbstractGoods foodGoods = CollectionUtils.first(CollectionUtils.transform(colonyTile.getType().getPossibleProduction(true), AbstractGoods.matches(foodGoodsType)));
        if (foodGoods != null) {
            foodGoods.setAmount(2);
        }
        Unit unit = colony.getUnitList().get(0);
        unit.setLocation(colony.getWorkLocationFor(unit, bellsType));
        colony.addGoods(foodGoodsType, colony.getFoodConsumption() * 2);
        ServerColonyTest.assertEquals((String)"Production not equal to consumption", (int)colony.getFoodConsumption(), (int)colony.getFoodProduction());
        int colonists = colony.getUnitCount();
        ServerColonyTest.assertEquals((String)"Unexpected change of colonists in colony", (int)colonists, (int)colony.getUnitCount());
        ServerColonyTest.assertEquals((String)"Unexpected change of production/consumption ratio", (int)colony.getFoodProduction(), (int)colony.getFoodConsumption());
    }

    public void testDeathByStarvation() {
        ServerGame game = ServerTestHelper.startServerGame(ServerColonyTest.getTestMap(marsh));
        int unitsBeforeNewTurn = 3;
        Colony colony = this.getStandardColony(unitsBeforeNewTurn);
        ServerPlayer player = (ServerPlayer)colony.getOwner();
        Building townHall = colony.getBuilding(townHallType);
        for (Unit u : colony.getUnitList()) {
            u.setLocation(townHall);
        }
        colony.removeGoods(foodGoodsType);
        colony.invalidateCache();
        int consumption = colony.getFoodConsumption();
        int production = colony.getFoodProduction();
        ServerColonyTest.assertTrue((String)("Food consumption (" + consumption + ") should be higher than production (" + production + ")"), (consumption > production ? 1 : 0) != 0);
        ServerColonyTest.assertEquals((String)"No food stored in colony", (int)0, (int)colony.getGoodsCount(foodType));
        ServerColonyTest.assertEquals((String)"Wrong number of units in colony", (int)unitsBeforeNewTurn, (int)colony.getUnitCount());
        ServerTestHelper.newTurn();
        consumption = colony.getFoodConsumption();
        production = colony.getFoodProduction();
        ServerColonyTest.assertTrue((String)("Food consumption (" + consumption + ") should be higher than production (" + production + ")"), (consumption > production ? 1 : 0) != 0);
        ServerColonyTest.assertEquals((String)"No food stored in colony", (int)0, (int)colony.getGoodsCount(foodType));
        ServerColonyTest.assertEquals((String)"Wrong number of units in colony", (int)(unitsBeforeNewTurn - 1), (int)colony.getUnitCount());
    }

    public void testAvoidStarvation() {
        ServerGame game = ServerTestHelper.startServerGame(ServerColonyTest.getTestMap(marsh));
        int unitsBeforeNewTurn = 3;
        Colony colony = this.getStandardColony(unitsBeforeNewTurn);
        ServerPlayer player = (ServerPlayer)colony.getOwner();
        ServerColonyTest.assertEquals((String)"Wrong number of units in colony", (int)unitsBeforeNewTurn, (int)colony.getUnitCount());
        Building townHall = colony.getBuilding(townHallType);
        for (Unit u : colony.getUnitList()) {
            u.setLocation(townHall);
        }
        colony.removeGoods(foodGoodsType);
        colony.invalidateCache();
        int consumption = colony.getFoodConsumption();
        int production = colony.getTile().getType().getPotentialProduction(grainType, null);
        ServerColonyTest.assertEquals((int)6, (int)consumption);
        ServerColonyTest.assertEquals((int)3, (int)production);
        ServerColonyTest.assertEquals((int)-3, (int)colony.getNetProductionOf(foodType));
        ServerColonyTest.assertEquals((int)0, (int)colony.getGoodsCount(foodType));
        ServerColonyTest.assertEquals((int)0, (int)colony.getTile().getUnitCount());
        colony.addGoods(foodType, 202);
        ServerTestHelper.newTurn();
        ServerColonyTest.assertEquals((int)199, (int)colony.getGoodsCount(foodType));
        ServerColonyTest.assertEquals((int)0, (int)colony.getTile().getUnitCount());
        ServerColonyTest.assertEquals((int)3, (int)colony.getUnitCount());
        colony.addGoods(foodType, 15);
        ServerTestHelper.newTurn();
        ServerColonyTest.assertEquals((int)11, (int)colony.getGoodsCount(foodType));
        ServerColonyTest.assertEquals((int)1, (int)colony.getTile().getUnitCount());
    }

    public void testBuildingCompletion() {
        ServerGame game = ServerTestHelper.startServerGame(ServerColonyTest.getTestMap(true));
        Colony colony = this.getStandardColony();
        ServerBuilding initialWarehouse = new ServerBuilding(ServerColonyTest.getGame(), colony, depotType);
        colony.addBuilding(initialWarehouse);
        ServerColonyTest.assertTrue((String)"Colony should be able to build warehouse", (boolean)colony.canBuild(warehouseType));
        colony.setCurrentlyBuilding(warehouseType);
        colony.addGoods(hammerGoodsType, 90);
        ServerColonyTest.assertFalse((String)"Colony should not have warehouse", (colony.getWarehouse().getType() == warehouseType ? 1 : 0) != 0);
        ServerTestHelper.newTurn();
        ServerColonyTest.assertTrue((String)"Colony should have warehouse", (colony.getWarehouse().getType() == warehouseType ? 1 : 0) != 0);
    }

    public void testInvalidCompletion() {
        ServerGame game = ServerTestHelper.startServerGame(ServerColonyTest.getTestMap(true));
        Colony colony = this.getStandardColony(2);
        Building carpenterHouse = colony.getBuilding(carpenterHouseType);
        ServerColonyTest.assertEquals((String)"Colony should not have lumber mill", (Object)carpenterHouse, (Object)colony.getBuilding(lumberMillType));
        ServerColonyTest.assertFalse((String)"Colony should not be able to build lumber mill", (boolean)colony.canBuild(lumberMillType));
        colony.setCurrentlyBuilding(lumberMillType);
        ServerColonyTest.assertEquals((String)"Colony should be building lumber mill", (Object)lumberMillType, (Object)colony.getCurrentlyBuilding());
        ServerUnit unit = new ServerUnit(game, colony.getTile(), colony.getOwner(), colonistType);
        unit.setLocation(colony);
        for (AbstractGoods ag : lumberMillType.getRequiredGoodsList()) {
            GoodsType type = ag.getType();
            int amount = ag.getAmount() + 1;
            colony.addGoods(type, amount);
            ServerColonyTest.assertEquals((String)("Wrong quantity of " + type), (int)amount, (int)colony.getGoodsCount(type));
        }
        ServerTestHelper.newTurn();
        ServerColonyTest.assertEquals((String)"Colony should have lumber mill", (Object)lumberMillType, (Object)colony.getBuilding(lumberMillType).getType());
        ServerColonyTest.assertFalse((String)"Colony should no longer be building lumber mill", (colony.getCurrentlyBuilding() == lumberMillType ? 1 : 0) != 0);
    }

    public void testNoBuildingMaterialsProductionWhenBuildingNothing() {
        Game game = ServerColonyTest.getGame();
        game.changeMap(ServerColonyTest.getTestMap(true));
        Colony colony = this.getStandardColony(4);
        Building carpenterHouse = colony.getBuilding(carpenterHouseType);
        Unit unit = colony.getFirstUnit();
        int initialLumber = 100;
        int initialHammers = 0;
        colony.addGoods(lumberGoodsType, initialLumber);
        colony.setCurrentlyBuilding(null);
        ServerColonyTest.assertEquals((String)"Wrong initial lumber quantity.", (int)initialLumber, (int)colony.getGoodsCount(lumberGoodsType));
        ServerColonyTest.assertEquals((String)"Colony should not have initial hammers.", (int)initialHammers, (int)colony.getGoodsCount(hammerGoodsType));
        unit.setLocation(carpenterHouse);
        ServerColonyTest.assertTrue((String)"Colony should be producing hammers.", (colony.getTotalProductionOf(hammerGoodsType) > 0 ? 1 : 0) != 0);
        ServerTestHelper.newTurn();
        ServerColonyTest.assertEquals((String)"Colony should not have produced hammers.", (int)initialHammers, (int)colony.getGoodsCount(hammerGoodsType));
        ServerColonyTest.assertEquals((String)"Wrong final lumber quantity.", (int)initialLumber, (int)colony.getGoodsCount(lumberGoodsType));
    }

    public void testLibertyAndImmigration() {
        ServerGame game = ServerTestHelper.startServerGame(ServerColonyTest.getTestMap(true));
        int population = 3;
        Colony colony = this.getStandardColony(3);
        ServerBuilding townHall = (ServerBuilding)colony.getBuilding(townHallType);
        Unit statesman = colony.getUnitList().get(0);
        townHall.setWorkFor(statesman);
        ServerColonyTest.assertEquals((Object)bellsType, (Object)statesman.getWorkType());
        ServerBuilding church = (ServerBuilding)colony.getBuilding(chapelType);
        church.upgrade();
        Unit preacher = colony.getUnitList().get(1);
        church.setWorkFor(preacher);
        ServerColonyTest.assertEquals((Object)crossesType, (Object)preacher.getWorkType());
        ServerColonyTest.assertEquals((int)3, (int)colony.getUnitCount());
        ServerColonyTest.assertEquals((int)1, (int)townHall.getUnitCount());
        ServerColonyTest.assertEquals((int)1, (int)church.getUnitCount());
        int bells0 = 3;
        ServerColonyTest.assertEquals((int)0, (int)colony.getGoodsCount(bellsType));
        ServerColonyTest.assertEquals((int)bells0, (int)colony.getNetProductionOf(bellsType));
        ServerColonyTest.assertEquals((int)0, (int)colony.getLiberty());
        ServerTestHelper.newTurn();
        ServerColonyTest.assertEquals((int)bells0, (int)colony.getGoodsCount(bellsType));
        ServerColonyTest.assertEquals((int)bells0, (int)colony.getNetProductionOf(bellsType));
        ServerColonyTest.assertEquals((int)bells0, (int)colony.getLiberty());
        colony.addGoods(bellsType, 7);
        int bells1 = bells0 + 7;
        ServerColonyTest.assertEquals((int)bells1, (int)colony.getGoodsCount(bellsType));
        ServerColonyTest.assertEquals((int)bells0, (int)colony.getNetProductionOf(bellsType));
        ServerColonyTest.assertEquals((int)bells1, (int)colony.getLiberty());
        colony.removeGoods(bellsType, 5);
        int bells2 = bells1 - 5;
        ServerColonyTest.assertEquals((int)bells2, (int)colony.getGoodsCount(bellsType));
        ServerColonyTest.assertEquals((int)bells0, (int)colony.getNetProductionOf(bellsType));
        ServerColonyTest.assertEquals((int)bells2, (int)colony.getLiberty());
        int crosses = colony.getTotalProductionOf(crossesType) - colony.getConsumptionOf(crossesType);
        ServerColonyTest.assertEquals((int)crosses, (int)colony.getNetProductionOf(crossesType));
        ServerColonyTest.assertEquals((int)crosses, (int)colony.getGoodsCount(crossesType));
        ServerColonyTest.assertEquals((int)crosses, (int)colony.getImmigration());
        colony.addGoods(crossesType, 7);
        ServerColonyTest.assertEquals((int)(crosses += 7), (int)colony.getGoodsCount(crossesType));
        ServerColonyTest.assertEquals((int)crosses, (int)colony.getImmigration());
        colony.removeGoods(crossesType, 5);
        ServerColonyTest.assertEquals((int)(crosses -= 5), (int)colony.getGoodsCount(crossesType));
        ServerColonyTest.assertEquals((int)crosses, (int)colony.getImmigration());
    }
}

