/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import gnu.getopt.Getopt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CertUtil;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.data.DataHelper;
import net.i2p.socks.SOCKS4Client;
import net.i2p.socks.SOCKS5Client;
import net.i2p.util.Addresses;
import net.i2p.util.DNSOverHTTPS;
import net.i2p.util.EepGet;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PSSLSocketFactory;
import net.i2p.util.InternalSocket;
import net.i2p.util.SocketTimeout;

public class SSLEepGet
extends EepGet {
    private int _saveCerts;
    private boolean _bypassVerification;
    private boolean _commandLine;
    private final SSLContext _sslContext;
    private SavingTrustManager _stm;
    private final ProxyType _proxyType;
    private int _forceDoH;
    private static final String CERT_DIR = "certificates/ssl";
    private static final String PROP_USE_DNS_OVER_HTTPS = "eepget.useDNSOverHTTPS";
    private static final boolean DEFAULT_USE_DNS_OVER_HTTPS = true;

    public SSLEepGet(I2PAppContext ctx, OutputStream outputStream, String url) {
        this(ctx, outputStream, url, null);
    }

    public SSLEepGet(I2PAppContext ctx, OutputStream outputStream, String url, SSLState state) {
        this(ctx, null, outputStream, url, -1L, state);
    }

    public SSLEepGet(I2PAppContext ctx, OutputStream outputStream, String url, long maxSize, SSLState state) {
        this(ctx, null, outputStream, url, maxSize, state);
    }

    public SSLEepGet(I2PAppContext ctx, String outputFile, String url) {
        this(ctx, outputFile, url, null);
    }

    public SSLEepGet(I2PAppContext ctx, String outputFile, String url, SSLState state) {
        this(ctx, outputFile, null, url, -1L, state);
    }

    public SSLEepGet(I2PAppContext ctx, ProxyType type, String proxyHost, int proxyPort, OutputStream outputStream, String url) {
        this(ctx, type, proxyHost, proxyPort, outputStream, url, null);
    }

    public SSLEepGet(I2PAppContext ctx, ProxyType type, String proxyHost, int proxyPort, OutputStream outputStream, String url, SSLState state) {
        super(ctx, type != ProxyType.NONE, proxyHost, proxyPort, 0, -1L, -1L, null, outputStream, url, true, null, null);
        if (type != ProxyType.NONE && !this._shouldProxy) {
            throw new IllegalArgumentException("Bad proxy params");
        }
        this._proxyType = type;
        this._sslContext = state != null && state.context != null ? state.context : this.initSSLContext();
        if (this._sslContext == null) {
            this._log.error("Failed to initialize custom SSL context, using default context");
        }
    }

    public SSLEepGet(I2PAppContext ctx, ProxyType type, String proxyHost, int proxyPort, String outputFile, String url) {
        this(ctx, type, proxyHost, proxyPort, outputFile, url, null);
    }

    public SSLEepGet(I2PAppContext ctx, ProxyType type, String proxyHost, int proxyPort, String outputFile, String url, SSLState state) {
        super(ctx, type != ProxyType.NONE, proxyHost, proxyPort, 0, -1L, -1L, outputFile, null, url, true, null, null);
        if (type != ProxyType.NONE && !this._shouldProxy) {
            throw new IllegalArgumentException("Bad proxy params");
        }
        this._proxyType = type;
        this._sslContext = state != null && state.context != null ? state.context : this.initSSLContext();
        if (this._sslContext == null) {
            this._log.error("Failed to initialize custom SSL context, using default context");
        }
    }

    private SSLEepGet(I2PAppContext ctx, String outputFile, OutputStream outputStream, String url, long maxSize, SSLState state) {
        super(ctx, false, null, -1, 0, -1L, maxSize, outputFile, outputStream, url, true, null, null);
        this._proxyType = ProxyType.NONE;
        this._sslContext = state != null && state.context != null ? state.context : this.initSSLContext();
        if (this._sslContext == null) {
            this._log.error("Failed to initialize custom SSL context, using default context");
        }
    }

    public static void main(String[] args) {
        SSLEepGet get;
        int saveCerts = 0;
        boolean noVerify = false;
        String proxyHost = "127.0.0.1";
        int proxyPort = 0;
        ProxyType ptype = ProxyType.NONE;
        boolean doh = false;
        boolean error = false;
        Getopt g = new Getopt("ssleepget", args, "dp:y:sz");
        try {
            int c;
            block9: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 112: {
                        String s = g.getOptarg();
                        int colon = s.indexOf(58);
                        if (colon >= 0) {
                            proxyHost = s.substring(0, colon);
                            String port = s.substring(colon + 1);
                            proxyPort = Integer.parseInt(port);
                            continue block9;
                        }
                        proxyHost = s;
                        continue block9;
                    }
                    case 121: {
                        String y = g.getOptarg().toUpperCase(Locale.US);
                        if (y.equals("HTTP") || y.equals("HTTPS")) {
                            ptype = ProxyType.HTTP;
                            continue block9;
                        }
                        if (y.equals("SOCKS4")) {
                            ptype = ProxyType.SOCKS4;
                            continue block9;
                        }
                        if (y.equals("SOCKS5")) {
                            ptype = ProxyType.SOCKS5;
                            continue block9;
                        }
                        if (y.equals("I2P")) {
                            ptype = ProxyType.INTERNAL;
                            proxyHost = "localhost";
                            proxyPort = 4444;
                            continue block9;
                        }
                        error = true;
                        continue block9;
                    }
                    case 115: {
                        ++saveCerts;
                        continue block9;
                    }
                    case 122: {
                        noVerify = true;
                        continue block9;
                    }
                    case 100: {
                        doh = true;
                        continue block9;
                    }
                }
                error = true;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            error = true;
        }
        if (error || args.length - g.getOptind() != 1) {
            SSLEepGet.usage();
            System.exit(1);
        }
        String url = args[g.getOptind()];
        String saveAs = SSLEepGet.suggestName(url);
        if (proxyHost != null) {
            if (proxyPort == 0) {
                proxyPort = ptype == ProxyType.HTTP ? 8080 : 1080;
            } else if (proxyPort == 4444 && ptype != ProxyType.INTERNAL && (proxyHost.equals("localhost") || proxyHost.equals("127.0.0.1") || proxyHost.equals("::1"))) {
                ptype = ProxyType.INTERNAL;
            }
            get = new SSLEepGet(I2PAppContext.getGlobalContext(), ptype, proxyHost, proxyPort, saveAs, url);
        } else {
            get = new SSLEepGet(I2PAppContext.getGlobalContext(), saveAs, url);
        }
        if (saveCerts > 0) {
            get._saveCerts = saveCerts;
        }
        if (noVerify) {
            get._bypassVerification = true;
        }
        if (doh) {
            get.forceDNSOverHTTPS(true);
        }
        get._commandLine = true;
        SSLEepGet sSLEepGet = get;
        sSLEepGet.getClass();
        get.addStatusListener(sSLEepGet.new EepGet.CLIStatusListener(1024, 40));
        if (!get.fetch(45000L, -1L, 60000L)) {
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("Usage: SSLEepGet [-dpsyz] https://url\n  -d use DNSOverHTTPS\n  -p proxyHost[:proxyPort]    // default port 8080 for HTTPS and 1080 for SOCKS; default localhost:4444 for I2P\n  -y HTTPS|SOCKS4|SOCKS5|I2P  // proxy type, default HTTPS if proxyHost is set\n  -s save unknown certs\n  -s -s save all certs\n  -z bypass hostname verification");
    }

    private SSLContext initSSLContext() {
        int adds;
        KeyStore ks = KeyStoreUtil.loadSystemKeyStore();
        if (ks == null) {
            this._log.error("Key Store init error");
            return null;
        }
        if (this._log.shouldLog(20)) {
            int count = KeyStoreUtil.countCerts(ks);
            this._log.info("Loaded " + count + " default trusted certificates");
        }
        File dir = new File(this._context.getBaseDir(), CERT_DIR);
        int totalAdds = adds = KeyStoreUtil.addCerts(dir, ks);
        if (adds > 0 && this._log.shouldLog(20)) {
            this._log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
        }
        if (!this._context.getBaseDir().getAbsolutePath().equals(this._context.getConfigDir().getAbsolutePath())) {
            dir = new File(this._context.getConfigDir(), CERT_DIR);
            adds = KeyStoreUtil.addCerts(dir, ks);
            totalAdds += adds;
            if (adds > 0 && this._log.shouldLog(20)) {
                this._log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
            }
        }
        dir = new File(System.getProperty("user.dir"));
        if (!this._context.getBaseDir().getAbsolutePath().equals(dir.getAbsolutePath())) {
            dir = new File(this._context.getConfigDir(), CERT_DIR);
            adds = KeyStoreUtil.addCerts(dir, ks);
            totalAdds += adds;
            if (adds > 0 && this._log.shouldLog(20)) {
                this._log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Loaded total of " + totalAdds + " new trusted certificates");
        }
        try {
            SSLContext sslc = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            this._stm = new SavingTrustManager(defaultTrustManager);
            sslc.init(null, new TrustManager[]{this._stm}, null);
            return sslc;
        }
        catch (GeneralSecurityException gse) {
            this._log.error("Key Store update error", gse);
        }
        catch (ExceptionInInitializerError eiie) {
            this._log.error("SSL context error - Java 9 bug?", eiie);
        }
        return null;
    }

    private static void saveCerts(String host, SavingTrustManager stm) {
        X509Certificate[] chain = stm.chain;
        if (chain == null) {
            System.out.println("Could not obtain server certificate chain");
            return;
        }
        for (int k = 0; k < chain.length; ++k) {
            X509Certificate cert = chain[k];
            String name = host + '-' + (k + 1) + ".crt";
            System.out.println("NOTE: Saving X509 certificate as " + name);
            System.out.println("      Issuer:     " + cert.getIssuerX500Principal());
            System.out.println("      Valid From: " + cert.getNotBefore());
            System.out.println("      Valid To:   " + cert.getNotAfter());
            try {
                cert.checkValidity();
            }
            catch (GeneralSecurityException e) {
                System.out.println("      WARNING: Certificate is not currently valid, it cannot be used");
            }
            CertUtil.saveCert(cert, new File(name));
        }
        System.out.println("NOTE: To trust them, copy the certificate file(s) to the certificates directory and rerun without the -s option");
    }

    public SSLState getSSLState() {
        return new SSLState(this._sslContext);
    }

    public void forceDNSOverHTTPS(boolean on) {
        this.forceDNSOverHTTPS(on, false);
    }

    public void forceDNSOverHTTPS(boolean on, boolean forceIPv6) {
        this._forceDoH = on ? (forceIPv6 ? 3 : 2) : 1;
    }

    @Override
    protected void doFetch(SocketTimeout timeout) throws IOException {
        this._aborted = false;
        this.readHeaders();
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP headers");
        }
        if (timeout != null) {
            if (this._fetchTotalTimeout > 0) {
                timeout.resetTimer();
            } else {
                timeout.cancel();
                timeout = null;
            }
        }
        if (this._fetchInactivityTimeout > 0) {
            this._proxy.setSoTimeout(this._fetchInactivityTimeout);
        } else {
            this._proxy.setSoTimeout(60000);
        }
        if (this._redirectLocation != null) {
            if (!this._redirectLocation.startsWith("https://")) {
                throw new IOException("Server redirect to " + this._redirectLocation + " not allowed");
            }
            ++this._redirects;
            if (this._redirects > 5) {
                throw new IOException("Too many redirects: to " + this._redirectLocation);
            }
            if (this._log.shouldInfo()) {
                this._log.info("Redirecting to " + this._redirectLocation);
            }
            this._actualURL = this._redirectLocation;
            EepGet.AuthState as = this._authState;
            if (as != null) {
                as.authSent = false;
            }
            this._bytesRemaining = -1L;
            this._redirectLocation = null;
            this._etag = this._etagOrig;
            this._lastModified = this._lastModifiedOrig;
            this._contentType = null;
            this._encodingChunked = false;
            this.sendRequest(timeout);
            this.doFetch(timeout);
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Headers read completely, reading " + this._bytesRemaining);
        }
        boolean strictSize = this._bytesRemaining >= 0L;
        I2PAppThread pusher = null;
        this._decompressException = null;
        if (this._isGzippedResponse) {
            PipedInputStream pi = new PipedInputStream(65536);
            PipedOutputStream po = new PipedOutputStream(pi);
            pusher = new I2PAppThread(new EepGet.Gunzipper(pi, this._out), "EepGet Decompressor");
            this._out = po;
            ((Thread)pusher).start();
        }
        int remaining = (int)this._bytesRemaining;
        byte[] buf = new byte[16384];
        while (!(!this._keepFetching || remaining <= 0 && strictSize || this._aborted)) {
            int read;
            int toRead = buf.length;
            if (strictSize && toRead > remaining) {
                toRead = remaining;
            }
            if ((read = this._proxyIn.read(buf, 0, toRead)) == -1) break;
            if (timeout != null) {
                timeout.resetTimer();
            }
            this._out.write(buf, 0, read);
            this._bytesTransferred += (long)read;
            if ((remaining -= read) == 0 && this._encodingChunked) {
                int char1 = this._proxyIn.read();
                if (char1 == 13) {
                    int char2 = this._proxyIn.read();
                    if (char2 == 10) {
                        remaining = (int)this.readChunkLength();
                    } else {
                        this._out.write(char1);
                        this._out.write(char2);
                        this._bytesTransferred += 2L;
                        remaining -= 2;
                        read += 2;
                    }
                } else {
                    this._out.write(char1);
                    ++this._bytesTransferred;
                    --remaining;
                    ++read;
                }
            }
            if (timeout != null) {
                timeout.resetTimer();
            }
            if (this._bytesRemaining >= (long)read) {
                this._bytesRemaining -= (long)read;
            }
            if (read <= 0) continue;
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).bytesTransferred(this._alreadyTransferred, read, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url);
            }
            this._alreadyTransferred += (long)read;
        }
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
        if (this._isGzippedResponse) {
            try {
                pusher.join();
            }
            catch (InterruptedException toRead) {
                // empty catch block
            }
            pusher = null;
            if (this._decompressException != null) {
                this._keepFetching = false;
                throw this._decompressException;
            }
        }
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP data");
        }
        if (timeout != null) {
            timeout.cancel();
        }
        if (this._transferFailed) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).attemptFailed(this._url, this._bytesTransferred, this._bytesRemaining, this._currentAttempt, this._numRetries, new Exception("Attempt failed"));
            }
        } else if (this._bytesRemaining == -1L || remaining == 0) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).transferComplete(this._alreadyTransferred, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url, this._outputFile, this._notModified);
            }
        } else {
            throw new IOException("Disconnection on attempt " + this._currentAttempt + " after " + this._bytesTransferred);
        }
    }

    @Override
    protected void sendRequest(SocketTimeout timeout) throws IOException {
        int port;
        String host;
        String req;
        block39: {
            File outFile;
            if (this._outputStream == null && (outFile = new File(this._outputFile)).exists()) {
                this._alreadyTransferred = outFile.length();
            }
            req = this.getRequest();
            try {
                URI url = new URI(this._actualURL);
                if ("https".equals(url.getScheme())) {
                    host = url.getHost();
                    if (host == null) {
                        throw new MalformedURLException("Bad URL");
                    }
                    if (host.toLowerCase(Locale.US).endsWith(".i2p")) {
                        throw new MalformedURLException("I2P addresses unsupported");
                    }
                    port = url.getPort();
                    if (port == -1) {
                        port = 443;
                    }
                    String originalHost = host;
                    boolean useDNSOverHTTPS = this._forceDoH == 1 || this._shouldProxy ? false : (this._forceDoH >= 2 ? true : this._context.getProperty(PROP_USE_DNS_OVER_HTTPS, true));
                    String ip = null;
                    if (useDNSOverHTTPS && !host.equals("dns.google") && !Addresses.isIPAddress(host)) {
                        DNSOverHTTPS doh = new DNSOverHTTPS(this._context, this.getSSLState());
                        ip = this._forceDoH == 3 ? doh.lookup(host, DNSOverHTTPS.Type.V6_ONLY) : doh.lookup(host);
                        if (ip != null) {
                            if (this._log.shouldDebug()) {
                                this._log.debug("DoH success: " + host + ' ' + ip);
                            }
                        } else if (this._log.shouldWarn()) {
                            this._log.debug("DoH fail: " + host);
                        }
                    }
                    if (this._shouldProxy) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Connecting to " + (Object)((Object)this._proxyType) + " proxy");
                        }
                        switch (this._proxyType) {
                            case HTTP: {
                                this.httpProxyConnect(host, port);
                                break;
                            }
                            case INTERNAL: {
                                this.internalHttpProxyConnect(host, port);
                                break;
                            }
                            case SOCKS4: {
                                this.socksProxyConnect(false, host, port);
                                break;
                            }
                            case SOCKS5: {
                                this.socksProxyConnect(true, host, port);
                                break;
                            }
                            default: {
                                throw new IOException("Unsupported proxy type " + (Object)((Object)this._proxyType));
                            }
                        }
                        this._proxy = this._sslContext != null ? this._sslContext.getSocketFactory().createSocket(this._proxy, host, port, true) : ((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(this._proxy, host, port, true);
                        if (this._log.shouldLog(10)) {
                            this._log.debug((Object)((Object)this._proxyType) + " proxy headers read completely");
                        }
                    } else if (ip != null) {
                        if (this._fetchHeaderTimeout > 0) {
                            this._proxy = new Socket();
                            this._proxy.setSoTimeout(this._fetchHeaderTimeout);
                            this._proxy.connect(new InetSocketAddress(ip, port), this._fetchHeaderTimeout);
                        } else {
                            this._proxy = new Socket(ip, port);
                        }
                        this._proxy = this._sslContext != null ? this._sslContext.getSocketFactory().createSocket(this._proxy, host, port, true) : ((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(this._proxy, host, port, true);
                    } else {
                        this._proxy = this._sslContext != null ? this._sslContext.getSocketFactory().createSocket(host, port) : SSLSocketFactory.getDefault().createSocket(host, port);
                        if (this._fetchHeaderTimeout > 0) {
                            this._proxy.setSoTimeout(this._fetchHeaderTimeout);
                        }
                    }
                    if (timeout != null) {
                        timeout.setSocket(this._proxy);
                    }
                    SSLSocket socket = (SSLSocket)this._proxy;
                    I2PSSLSocketFactory.setProtocolsAndCiphers(socket);
                    if (this._bypassVerification) break block39;
                    String vhost = originalHost;
                    if (vhost.startsWith("[") && vhost.endsWith("]")) {
                        vhost = vhost.substring(1, vhost.length() - 1);
                    }
                    try {
                        I2PSSLSocketFactory.verifyHostname(this._context, socket, vhost);
                        break block39;
                    }
                    catch (SSLException ssle) {
                        if (this._saveCerts > 0 && this._stm != null) {
                            SSLEepGet.saveCerts(host, this._stm);
                        }
                        throw ssle;
                    }
                }
                throw new MalformedURLException("Only https supported: " + this._actualURL);
            }
            catch (URISyntaxException use) {
                MalformedURLException ioe = new MalformedURLException("Redirected to invalid URL");
                ioe.initCause(use);
                throw ioe;
            }
        }
        this._proxyIn = this._proxy.getInputStream();
        this._proxyOut = this._proxy.getOutputStream();
        try {
            this._proxyOut.write(DataHelper.getUTF8(req));
            this._proxyOut.flush();
            if (this._saveCerts > 1 && this._stm != null) {
                SSLEepGet.saveCerts(host, this._stm);
            }
        }
        catch (SSLException sslhe) {
            this._log.error("SSL negotiation error with " + host + ':' + port + " - self-signed certificate or untrusted certificate authority?", sslhe);
            if (this._saveCerts > 0 && this._stm != null) {
                SSLEepGet.saveCerts(host, this._stm);
            } else if (this._commandLine) {
                System.out.println("FAILED (probably due to untrusted certificates) - Run with -s option to save certificates");
            }
            throw sslhe;
        }
        this._proxyIn = new BufferedInputStream(this._proxyIn);
        if (this._log.shouldLog(10)) {
            this._log.debug("Request flushed");
        }
    }

    private void httpProxyConnect(String host, int port) throws IOException {
        if (this._fetchHeaderTimeout > 0) {
            this._proxy = new Socket();
            this._proxy.setSoTimeout(this._fetchHeaderTimeout);
            this._proxy.connect(new InetSocketAddress(this._proxyHost, this._proxyPort), this._fetchHeaderTimeout);
        } else {
            this._proxy = new Socket(this._proxyHost, this._proxyPort);
        }
        this.httpProxyConnect(this._proxy, host, port);
    }

    private void internalHttpProxyConnect(String host, int port) throws IOException {
        this._proxy = InternalSocket.getSocket(this._proxyHost, this._proxyPort);
        this.httpProxyConnect(this._proxy, host, port);
    }

    private void httpProxyConnect(Socket proxy, String host, int port) throws IOException {
        this._proxyIn = this._proxy.getInputStream();
        this._proxyOut = this._proxy.getOutputStream();
        StringBuilder buf = new StringBuilder(64);
        buf.append("CONNECT ").append(host).append(':').append(port).append(" HTTP/1.1\r\nHost: ").append(host).append(':').append(port).append("\r\n");
        if (this._authState != null && this._authState.authMode != EepGet.AUTH_MODE.NONE) {
            buf.append("Proxy-Authorization: ");
            buf.append(this._authState.getAuthHeader("CONNECT", host));
            buf.append("\r\n");
        }
        buf.append("\r\n");
        this._proxyOut.write(DataHelper.getUTF8(buf.toString()));
        this._proxyOut.flush();
        this._aborted = false;
        this.readHeaders();
        if (this._aborted) {
            throw new IOException("Timed out reading the proxy headers");
        }
        if (this._responseCode == 407) {
            throw new IOException("Authorization unsupported on HTTP Proxy");
        }
        if (this._responseCode != 200) {
            throw new IOException("Invalid proxy response: " + this._responseCode + ' ' + this._responseText);
        }
        if (this._redirectLocation != null) {
            throw new IOException("Proxy redirect not allowed");
        }
    }

    private void socksProxyConnect(boolean isSocks5, String host, int port) throws IOException {
        if (this._fetchHeaderTimeout > 0) {
            this._proxy = new Socket();
            this._proxy.setSoTimeout(this._fetchHeaderTimeout);
            this._proxy.connect(new InetSocketAddress(this._proxyHost, this._proxyPort), this._fetchHeaderTimeout);
        } else {
            this._proxy = new Socket(this._proxyHost, this._proxyPort);
        }
        if (this._authState != null) {
            if (!isSocks5) {
                throw new IOException("Authorization unsupported on SOCKS 4");
            }
            SOCKS5Client.connect(this._proxy, host, port, this._authState.getUsername(), this._authState.getPassword());
        } else if (isSocks5) {
            SOCKS5Client.connect(this._proxy, host, port);
        } else {
            SOCKS4Client.connect(this._proxy, host, port);
        }
        this._proxyIn = this._proxy.getInputStream();
        this._proxyOut = this._proxy.getOutputStream();
    }

    public static class SSLState {
        private final SSLContext context;

        private SSLState(SSLContext ctx) {
            this.context = ctx;
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }

    public static enum ProxyType {
        NONE,
        HTTP,
        HTTPS,
        INTERNAL,
        SOCKS4,
        SOCKS5,
        TRANSPARENT;

    }
}

